
#ifndef DKUTIL_DETAIL_STREAM_FUNCTOR_HPP
#define DKUTIL_DETAIL_STREAM_FUNCTOR_HPP

#include <dkutil/macro.hpp>
#include <dkutil/config.hpp>
#include <dkutil/scoped_buffer.hpp>
#include <dkutil/detail/serialize_interface.hpp>
#include <stdio.h>

namespace dkutil{


/**
@param STREAM_T stream̌^
@param FUNCTOR_ ȉ̃R[ĥ悤Ȍ`
@code
class f{
	converter *mp;
public:
	f(converter *p) : mp(p){}
	void operator()(const unsigned char *p,size_t size){
		mp->convert(p,size);
	}
};
@endcode
*/
///ǂݍ
template<class STREAM_T,class FUNCTOR_>
struct div_read_each_functor{
	uint64 mReadSize;
	div_read_each_functor(){
		mReadSize = 0;
	}
	uint64 get_readsize()const{
		return mReadSize;
	}
	/**
	@param ps[in][out] streamIuWFNgւ̃|C^
	@param func_[in] [hf[^ׂ̃t@N^[
	//@param ope[in] ̃t@C̃o֐(readwrite)
	@param innerbuffsize[in] Ŏgobt@̃TCY
	*/
	bool operator()(STREAM_T *ps,FUNCTOR_ func_,size_t innerbuffsize = 1024 * 512)
	{
		scoped_buffer_byte t(innerbuffsize);
		for(;false==ps->eof();)
		{
			if(true==ps->error() ){
				throw filesystem_error("ferror error");
			}
			size_t count = ps->read(t.get(),t.size());
			//肦ȂG[`FbN
			dkcmNOT_ASSERT(count > t.size());
			mReadSize += count;
			func_(t.get(),count);
		}
		return true;
		//return referenced_functor(ps,func_,innerbuffsize);
	}
	bool referenced_functor(STREAM_T *ps,FUNCTOR_ &func_,size_t innerbuffsize = 1024 * 512)
	{
		scoped_buffer_byte t(innerbuffsize);
		for(;false==ps->eof();)
		{
			if(true==ps->error() ){
				throw filesystem_error("ferror error");
			}
			size_t count = ps->read(t.get(),t.size());
			//肦ȂG[`FbN
			dkcmNOT_ASSERT(count > t.size());
			mReadSize += count;
			func_(t.get(),count);
		}
		return true;

	}
};

///
template<class STREAM_T,class FUNCTOR_>
struct div_write_each_functor{

	bool operator()(STREAM_T *ps,FUNCTOR_ func_,size_t innerbuffsize = 1024 * 512)
	{
		scoped_buffer_byte t(innerbuffsize);
		for(;false==ps->eof();)
		{
			if(true==ps->error() ){
				throw filesystem_error("ferror error");
			}
			size_t count = ps->write(t.get(),t.size());
			//肦ȂG[`FbN
			dkcmNOT_ASSERT(count > t.size());

			func_(t.get(),count);
		}
		return true;
	}
};

///~bgtǂݍ
template<class STREAM_T,class FUNCTOR_>
struct div_read_limit_functor{

	bool operator()(STREAM_T *ps,FUNCTOR_ func_,size_t limit_size,
		size_t innerbuffsize = 1024 * 512)
	{
		scoped_buffer_byte t(innerbuffsize);
		size_t lc = 0;
		for(;false==ps->eof();)
		{
			if(true==ps->error() ){
				throw filesystem_error("ferror error");
			}
			
			size_t count;
			count = ps->read(t.get(),t.size());
			lc+=count;
			//Ȃ񂩂̃~bgroOĂ悤ȁEEE
			if(lc == limit_size){
				func_(t.get(),count);
				return true;
			}else if(lc > limit_size){//ɃRR
				size_t readsize;
				if(t.size() > limit_size){//ɃRR
					readsize = limit_size;
				}else{
					readsize = lc - limit_size;
				}
				func_(t.get(),readsize);
				return true;
			}else{
				
				func_(t.get(),count);
			}
			
			//肦ȂG[`FbN
			dkcmNOT_ASSERT(count > t.size());

			
		}
		return true;
	}
};


template<class STREAM_T>
struct responsible_read_functor{

	///w肵TCYKǂݍ
	void operator()(STREAM_T *ps,void *buf,size_t size){
		//sizẽe|
		size_t tsize = size;
		//ǂݍ񂾃TCỸe|
		size_t t;
		//ɏITCỸe|
		size_t tf = 0;

		while(1){
			t = ps->read(buf,tsize);
			tf += t;
			if(t == size){
				break;
			}else if(tf == size){
				break;
			}
			if(ps->eof()){
				throw filesystem_error("responsible_read eof");
			}
			if(ps->error()){
				throw filesystem_error("responsible_read error");
			}
			tsize = tsize - t;
			buf = (char *)buf + t;

		}

		return;
	}
};


template<class STREAM_T>
struct responsible_write_functor{

	///w肵TCYK
	void operator()(STREAM_T *ps,const void *buf,size_t size){

		size_t tsize = size;

		size_t t = 0;

		size_t tf = 0;
		while(1){
			t = ps->write(buf,tsize);
			tf += t;
			if(t == size){
				break;
			}else if(tf == size){
				break;
			}
			if(ps->eof()){
				throw filesystem_error("responsible_write eof");
			}
			if(ps->error()){
				throw filesystem_error("responsible_write error");
			}
			tsize = tsize - t;
			buf = (char *)buf + t;

		}
		//return size;
	}
};



}//end of dkutil namespace



#endif