
#ifndef DKUTIL_DETAIL_STREAM_INTERFACE_HPP
#define DKUTIL_DETAIL_STREAM_INTERFACE_HPP

#include <dkutil/define.hpp>
#include <dkutil/config.hpp>
#include <dkutil/scoped_buffer.hpp>
#include <dkutil/detail/serialize_interface.hpp>
#include <dkutil/detail/stream_functor.hpp>
#include <dkutil/boost/parm_string.hpp>

namespace dkutil{

enum{
	//V[NIvV
	///擪
	seek_begin = SEEK_SET,
	///̈ʒu
	seek_current = SEEK_CUR,
	///Ō̈ʒu
	seek_end = SEEK_END,
};

///seek()̃ItZbgɎgϐ
typedef LONGLONG seek_arg_type;


///stream̓̃C^[tF[X
struct IStreamAction{
	virtual bool action(uint8 *p,size_t size) = 0;
};

///Xg[̏̎Ɋ荞ݏ鎞g
struct stream_process_interrupt_arg{
	///\ׂ̂ẴTCY
	uint64 mAllSize;
	///܂ł̏ITCY
	uint64 mFinishedSize;
	///ĂXg[̃f[^̃e|obt@ւ̃|C^
	const void *mStreamData;
	///ITCY
	size_t mNowFinishedSize;
	stream_process_interrupt_arg(uint64 allsize = 0,uint64 finished_size = 0,
		const void *sd = NULL,size_t now_finished_size = 0) : mAllSize(allsize),
		mFinishedSize(finished_size) , mStreamData(sd),
		mNowFinishedSize(now_finished_size)
	{
	}
};


///Xg[̎Ɋ荞ݏ鎞Ɏgfunctorbase

struct stream_process_interrupt_functor_base{
	/**
	@param arg[in] stream_process_interrupt_arg^̏Ă|C^
	@param user_ptr[in] ŏg鎞Ɏg|C^
	*/
	bool operator()(const stream_process_interrupt_arg *arg,void *user_ptr)
	{
		return true;
	}
};
/*
struct IStreamProcessInterrupt{
	virtual bool 

};
*/
template<class POLICY>
class stream_interface {
public:
	typedef POLICY policy_type;
	typedef typename policy_type::size_type size_type;
	typedef uint32 size_type32;
	typedef uint64 size_type64;
	typedef stream_interface<POLICY> self_type;

	stream_interface(){}
	~stream_interface(){}


	size_type read(void *buf,size_type size){
		return mP.read(buf,size);
	}
	
	
	size_type write(const void *buf,size_type size){
		
		return mP.write(buf,size);
	}
	///for string
	/*size_t write(const char *buf){
		return mP.write(buf,strlen(buf));
	}*/
	size_type write(parm_string str){
		return mP.write(str.c_str(),str.size());
	}

	//size_t write(
	size_type ref(void *buf,size_type size){
		return mP.ref(buf,size);
	}
	bool eof()const{
		return mP.eof();
	}
	bool error()const{
		
		return mP.error();
	}
#if 0
	bool seek(long offset, int origin ){
		return mP.seek(offset,origin);
	}
	
	bool seek(size_type offset){
		return mP.seek(offset);
	}
	
	size_type tell()const{
		return mP.tell();
	}
#else
	bool seek(seek_arg_type offset, int origin ){
		return mP.seek(offset,origin);
	}
	
	bool seek(seek_arg_type offset){
		return mP.seek(offset);
	}
	
	seek_arg_type tell()const{
		return mP.tell();
	}
	static uint64 limit(){
		return policy_type::limit_size;
	}
#endif
	size_type size(){
		return mP.size();
	}
	///w肵TCYKǂݍ
	void responsible_read(void *buf,size_t size){
		//sizẽe|
		size_t tsize = size;
		//ǂݍ񂾃TCỸe|
		size_t t;
		//ɏITCỸe|
		size_t tf = 0;

		while(1){
			t = read(buf,tsize);
			tf += t;
			if(t == size){
				break;
			}else if(tf == size){
				break;
			}
			if(eof()){
				throw filesystem_error("responsible_read eof");
			}
			if(error()){
				throw filesystem_error("responsible_read error");
			}
			tsize = tsize - t;
			buf = (char *)buf + t;

		}

		return;
	}
	///w肵TCYK
	void responsible_write(const void *buf,size_t size){

		size_t tsize = size;

		size_t t = 0;

		size_t tf = 0;
		while(1){
			t = write(buf,tsize);
			tf += t;
			if(t == size){
				break;
			}else if(tf == size){
				break;
			}
			if(eof()){
				throw filesystem_error("responsible_write eof");
			}
			if(error()){
				throw filesystem_error("responsible_write error");
			}
			tsize = tsize - t;
			buf = (char *)buf + t;

		}
		//return size;
	}

	class all_read_functor{
	private:
		BYTE *mp;
		//size_type msize;
		size_type mrest;
	public:
		all_read_functor(BYTE *ptr,size_type size){
			mp = ptr;
			mrest = size;
		}
		void operator()(const BYTE *buff,size_type size){
			if(mrest < size){
				DKUTIL_THROW_OR_NOTICE(std::out_of_range("all_read_functor buffer over flow"));
			}
			memcpy(mp,buff,size);
			mp += size;
			mrest -= size;
		}

	};


	///̈ʒuŌ܂œǂݍ @return ۓǂݍ񂾃TCY
	uint64 all_read(void *buf,size_type size,size_t innerbuffsize = 1024 * 512){
		all_read_functor func((BYTE *)buf,size);
		div_read_each_functor<self_type,all_read_functor> div_read_each;
		div_read_each(this,func,innerbuffsize);
		return div_read_each.get_readsize();
	}
	class text_read_functor{
	private:
		BYTE *mp;
		//size_type msize;
		size_type mrest;
		size_t mreadsize;
	public:
		text_read_functor(BYTE *ptr,size_type size){
			mp = ptr;
			mrest = size;
			mreadsize = 0;
		}
		void operator()(const BYTE *buff,size_type size){
			if(mrest < size){
				DKUTIL_THROW_OR_NOTICE(std::out_of_range("text_read_functor buffer over flow"));
			}
			memcpy(mp,buff,size);
			mp += size;
			mrest -= size;
			mreadsize += size;
		}
		size_t readsize()const{
			return mreadsize;
		}

	};

	///textŌ܂œǂݍ @return ǂݍ񂾃eLXg̃TCY
	size_t text_all_read(void *buf,size_type size,size_t innerbuffsize = 1024 * 512){
		text_read_functor func((BYTE *)buf,size);
		div_read_each_functor<self_type,text_read_functor> div_read_each;
		div_read_each.referenced_functor(this,func,innerbuffsize);
		return func.readsize();
	}


protected:
	policy_type mP;
	policy_type &getPolicy()const{
		return mP;
	}
		
		
};



namespace policy{

class empty_stream_policy{
public:
	typedef size_t size_type;
	typedef void *handle_type;

	size_type tell()const{
		return 0;
	}

	size_type read(void *buf,size_type size){
		return 0;
	}
	size_type write(const void *buf,size_type size){
		
		return 0;
	}
	bool eof()const{
		return false;
	}
	bool error()const{
		
		return false;
	}
	bool seek(long offset, int origin ){
		return 0;
	}
	size_type size(){
		return 0;
	}
	void resize(size_type){}
	void reserve(size_type){}
};



}//end of policy

/**
<PRE>
OS 	R[h\L 16i\L 10i\L 
UNIX 	<LF> 	    0A 	     10 
Windows <CR><LF>    0D 0A    13 10 
Macintosh <CR> 	    0D 	     13 
</PRE>
*/
template<class STREAM_T>
class stream_convert_line_feed_code_writer_win32{
public:
	STREAM_T::size_type operator()(STREAM_T *p,parm_string str){
		const char *a = str.c_str();
		size_t c=0;
		char crlf[3]={0x0D,0x0A,'\0'};
		while(*a != '\0')
		{
			if(*a == '\n')
			{
				c += p->write(crlf);
			}else{
				c += p->write(a,1);
			}
			a++;
		}
		return c;
	}

};


/**
Xg[G[Ƀu
*/

/*
class stream_error : public std::runtime_error{
public:
	stream_error(const char *str) : std::runtime_error(str){}
	stream_error(const std::string &str) : std::runtime_error(str){}
};
*/
DKUTIL_DEFINE_DERIVE_STANDARD_RUNTIME_ERROR(stream_error);


///񂵂݂oȂXg[
class IOneTimeWriteStream{
public:
	virtual ~IOneTimeWriteStream(){}
	/*!
	@param buff[in] ރf[^ւ̃|C^
	@param size[in] buff̃TCY
	@return falseȂG[Bistream̃obt@Ȃ)
	*/
	///
	virtual bool write(const void *buff,size_t size,size_t *write_size) = 0;
	
	virtual size_t write(const void *buff,size_t size){
		size_t writesize;
		if(false==write(buff,size,&writesize)){
			//DKUTIL_THROW_OR_NOTICE(stream_error("read false"));
		}
		return writesize;
	}
	///ӔCď @see write() @return ӔCď߂Ȃfalse
	inline bool responsible_write(const void *buff,size_t size){
		char *pBuffer = (char *)buff;
		size_t Rest = size;
		size_t write_ed;

		while ( Rest > 0 )
		{

			bool r = write( pBuffer, Rest, &write_ed );
			if(r==false){
				goto End;
			}

			// write_i߂
			Rest -= write_ed;
			pBuffer += write_ed;
		}
	End:
		write_ed = (size - Rest);
		return write_ed == size;
	}

	///@return Xg[gp\ȂtrueԂ
	virtual bool good()const = 0;


};

///񂵂ǂݍ݂oȂXg[
class IOneTimeReadStream{
public:
	virtual ~IOneTimeReadStream(){}
		/*!
	@param buff[out] obt@[
	@param size[in] obt@̃TCY
	@param readsize[in] ۂɓǂݍ񂾃TCY
	@return falseȂG[iobt@Ȃ j
	*/
	///ǂݍ
	virtual bool read(void *buff,size_t size,size_t *readsize) = 0;
	virtual size_t read(void *buff,size_t size){
		size_t readsize;
		if(false==read(buff,size,&readsize)){
			//DKUTIL_THROW_OR_NOTICE(stream_error("read false"));
		}
		return readsize;
	}
	

	///ӔCēǂ݂ @see read()
	inline bool responsible_read(void *buff,size_t size)
	{
		char *pBuffer = (char *)buff;
		size_t Rest = size;
		size_t readed;
		

		while ( Rest > 0 )
		{

			bool r = read( pBuffer, Rest, &readed );
			if(r==false){
				goto End;
			}

			// readi߂
			Rest -= readed;
			pBuffer += readed;
		}
	End:
		readed = (size - Rest);
		return readed == size;
	}


};
/**
dȌׂȂA΂ɃC^[tFCX̎ςȂB
i̊֐̏ԂȂɂĎłB
@todo
܂sSȂ̂ŃC^[tFCXς\͑ɂB
@note
dlF
- StreamnNX̃C^[tFCXƂĂ̎ncłB

*/
class IStream : public IOneTimeReadStream,public IOneTimeWriteStream{
public:
	typedef IStream self_type;
	typedef size_t size_type;

	
	virtual ~IStream(){}

	/*!
	@param buff[out] obt@[
	@param size[in] obt@̃TCY
	@param readsize[in] ۂɓǂݍ񂾃TCY
	@return falseȂG[B
	@note
	read()Ƃ̈ႢF
	ref()͓̃ItZbgJEgύXȂB
	*/
	///gB
	virtual bool ref(void *buff,size_t size,size_t *readsize)
	{
		seek_arg_type t = tell();
		bool r = read(buff,size,readsize);
		if(false==r) return r;
		seek(t,seek_begin);
		return r;
	}
	/*!
	@param offset[in] originw肩牽oCgAV[N邩B
	@param origin[in] 
	@note
	fseekƓłBij
	originfseekƓwqԂł肵܂OOG
	*/
	///V[NB
	virtual bool seek(seek_arg_type offset,int origin) = 0;
	///̃obt@̍ŏ̃ItZbgԂB
	virtual seek_arg_type tell()const = 0;

	///̃Xg[̏݃~bg擾Blimit() == tell()eof()?
	virtual seek_arg_type limit()const = 0;
	virtual bool eof()const{
		return tell()>=limit();
	}
		///Xg[̃^Cv擾
	virtual int type()const = 0;
	///o֐ev[gŔėpxUP!!H
	template<class T>
	void push_back(const T &x){
		size_type size = sizeof(x);
		BYTE *t = (BYTE *)&x;
		bool r = responsible_write(t,size);
		if(false==r){
			throw stream_error ("stream_interface::push_back()");//(DKUTIL_MAKESIGNATURE(T));
		}
	}
	template<class T>
	void push_back(const T *buf,size_type size){
		//const BYTE *t = (BYTE *)buf;
		bool r = responsible_write(buf,size);
		if(false==r){
			throw stream_error ("stream_interface::push_back()");//(DKUTIL_MAKESIGNATURE(T));
		}
	}
	///@return little endiantrue
	static bool isLittleEndian(){
		return TRUE==dkcIsLittleEndian();
	}

	//stream_interface* operator=(const stream_interface *ptr){}


};


/*!
dȌׂȂA΂ɃC^[tFCX̎ςȂB
i̊֐̏ԂȂɂĎłB
@todo
܂sSȂ̂ŃC^[tFCXς\͑ɂB
@note
dlF
- read write ref́@قځAKAw肵TCY܂œ삷B
- 
*/
class IMemoryStream : public IStream{
public:
	typedef IStream base_type;
	//typedef base_type::seek_arg_type seek_arg_type;
	typedef base_type::size_type size_type;
	typedef IMemoryStream self_type;
	//typedef size_t size_type;
	typedef uint64 size_type64;
	typedef uint32 size_type32;


	
/*
	#ifdef BOOST_NO_INCLASS_MEMBER_INITIALIZATION
	enum{
		///obt@ƂĎgB
		buffer = edkcStreamInitBuffer,
		///t@CƂĎgB
		file = edkcStreamInitFile,
	};
#else
	const static int buffer = edkcStreamInitBuffer,
	const static int file = edkcStreamInitFile,
#endif
	*/
protected:

public:

	
	virtual ~IMemoryStream(){}

	/*!
	@note
	serialize_interfacẽ|C^Ԃ߂΁A
	VACYAfVACY肵Ă܂B
	*/
	///VACYB
	//virtual bool serialize(serialize_interface *) = 0;
	///obt@ւ̃|C^𒸂ï܂ށB댯B
	///type()ł̖߂lmemory_stream_type݂̎̂ɌgpB
	virtual const void *data()const = 0;
	///obt@̃TCYB
	virtual size_type size()const = 0;
	///obt@TCYB
	virtual void resize(size_type size) = 0;
	///obt@NAB
	virtual void clear() = 0;


	///sizeV[N܂BF/--*-//-*--/̕ɃV[N銴BB
	inline void pop_back(int size){
		if(false==seek(-abs(size),edkcStreamSeekCurrent)){
			throw stream_error("IMemoryStream::pop_back()");
			//DKUTIL_THROW_OR_NOTICE(std::runtime_error("IStream::pop_back()"));
		}
	}

	//stream_interface* operator=(const stream_interface *ptr){}


};


}//end of dkutil namespace



#endif