

/*!
  @author d
  @since 2004/1/13
	@note
	licence:BSD Licence
*/


#ifndef _dktl_orderless_container__h_
#define _dktl_orderless_container__h_

namespace dkutil{


template<class T,class A=std::allocator<T>,class CONTAINER=std::vector<T,A> >
class orderless_container{
public:
	typedef A allocator_type;
  typedef A::size_type size_type;
  typedef A::difference_type difference_type;
  typedef A::reference reference;
  typedef A::const_reference const_reference;
  typedef A::value_type value_type;

	typedef CONTAINER CONTAINER_TYPE;
	typedef T DATA_TYPE;

	typedef CONTAINER_TYPE::iterator iterator;
	typedef CONTAINER_TYPE::const_iterator const_iterator;
	//typedef CONTAINER_TYPE::reverse_iterator reverse_iterator;
	//typedef CONTAINER_TYPE::const_reverse_iterator const_reverse_iterator;
private:
	CONTAINER m;


public:
	orderless_container(){}
	orderless_container(const orderless_container<T,CONTAINER> &cop){}

	iterator begin(){return m.begin();}
	iterator end(){return m.end();}
	const_iterator begin()const{return m.begin();}
	const_iterator end()const{return m.end();}
	//reverse_iteratorgƋĂ܂ߔp~B
	//reverse_iterator rbegin(){return m.rbegin();}
	//reverse_iterator rend(){return m.rend();}
	//const_reverse_iterator rbegin()const{return m.rbegin();}
	//const_reverse_iterator rend()const{return m.rend();}
	void clear(){m.clear();}
	///pop()Wrapper
	iterator erase(iterator it){return pop(it);}
	//iterator erase(iterator first,iterator last){m.erase(first,last);}

	bool empty()const{return m.empty();}
	

	size_type size()const{ return m.size();}
	//vectorcapacity
	//size_type capacity()const{	return m.capacity();}
	CONTAINER_TYPE &get_container(){return m;}

	///AP[^Qbg
	allocator_type get_allocator()const{return m.get_allocator();}

	void resize(size_type new_size,const T &x=T()){		m.resize(new_size,x);}
	void reserve(size_type n){m.reserve(n);}
	iterator back_iterator(){
		return boost::prior(end());
	}
	reference back(){return m.back();}
	reference front(){return m.front();}

	void push(const T &x){
		m.push_back(x);
	}


	iterator pop(iterator it){
		if(empty()) return it;
		if(size()<=1){
			it = m.erase(it);
			return it;
		}
		if(it == back_iterator()){
			it = m.erase(it);
			return it;
		}
		//̕폜̈ɃRs[Ă܂I
		(*it) = m.back();

		//̕폜
		m.pop_back();
		it++;
		return it;
	}


	
	
	
	
	
};


}//end of dkutil namepsace

#endif //end of include once