

/*!
  @author d
  @since 2003/8/21
	@note
	licence:BSD Licence
*/


#ifndef DKUTIL_DKTL_SINGLETON_HPP
#define DKUTIL_DKTL_SINGLETON_HPP

#include <dkutil/config.hpp>
#include <dkutil/macro.hpp>
#include <dkutil/synchronized.hpp>

namespace dkutil{

template <class T>
class singleton {

//˂炨YTL/singleton.hQlɂ܂B
public:
	
	typedef T self_type;
	//typedef UTIL thread_policy;
	singleton(){
		//ODS("OK singleton\n");
	}
	virtual ~singleton() { Release(); }
	///	|C^̂ӂ邽߂̎d|@(ȂقǁI͕֗łB
	T& operator*() { return *get(); }
	T* operator->() { return get();	}
	///CX^XmF擾
	T* get() { CheckInstance(); return m_lpObj; }
	///mFBU|C^擾
	T *get_fast(){return m_lpObj;}
	bool	isNull() const { return m_lpObj == NULL; }
	void Release(){
		if (m_lpObj!=NULL) {
			synchronized swimming;
			
			if(m_lpObj!=NULL){		
				delete m_lpObj;
				m_lpObj = NULL;
			}
			
		}
	}
	void CheckInstance(){
		if (m_lpObj==NULL) {
			synchronized swimming;
			if(m_lpObj==NULL){
				m_lpObj = new T;
			}
		}
	}
BOOST_PROTECTED:
	static T*	m_lpObj;
	//UTIL m_util;
};

//	static ȃIuWFNg
template <class T> T* singleton<T>::m_lpObj = 0;


/*!
@section g

intrusive_singleton_after_new( T *p,void *)
intrusive_singleton_before_delete( T *p,void *)
̓`ĂB
O҂newɌĂяoׂ
҂deleteOɌĂяoׂ
łB

Global namespace ,܂anonymous namespaceɒ`ĂB
C[WIɂ
boost::intrusive_ptr@ƓłB
http://www.kmonos.net/alang/boost/classes/intrusive_ptr.html

*/
///t܂singleton() boost::intrusive_ptr݂Ȃ
template <class T>
class intrusive_singleton {
	//˂炨YTL/singleton.hQlɂ܂B
public:
	typedef T self_type;
	//typedef UTIL thread_policy;
	intrusive_singleton(){
		//ODS("OK singleton\n");
	}
	///@see set_param()
	intrusive_singleton(void *Ptr,bool overwrite=false){
		set_param(Ptr,overwrite);
	}
	/*
	@param Ptr[in] דǃ|C^
	@param overwrite[in] OAn|C^NULLł͂ȂA㏑鎞TRUE
	@param create[in] trueƑsCX^X𐶐(Ptr㏑Ă܂댯邽߁B
	@note
	Ȃ񂩁Asingleton̈Ӌ`̈̂́uKvɂȂ쐬v
	Ă̂ȂɂȂĂ悤ȋCOOG
	*/
	intrusive_singleton(bool create,void *Ptr,bool overwrite=false){
		if(create){
			force_create_instance(Ptr);
		}else{
			set_param(Ptr,overwrite);
		}
	}	
	/*!
	@param Ptr[in] דǃ|C^ intrusive_singleton_after_new before_deletȇɓnz
	@param overwrite[in] OAn|C^NULLł͂ȂA㏑鎞TRUE
	*/
	void set_param(void *Ptr,bool overwrite=false){
	
		if(overwrite){
			mPtr = Ptr;
		}else if(NULL==mPtr){
			mPtr = Ptr;
		}
	}
	/*!
	IɑUinstance쐬܂B
	@see  set_param()ƓB
	@return falseƂłinstanceĂ܂ĂB
	*/
	bool force_create_instance(void *Ptr){
		synchronized swimming;
		if(false==isNull()){
			return false;
		}
		set_param(Ptr,true);
		CheckInstance();
	}

	
	virtual ~intrusive_singleton() { Release(); }
	///	|C^̂ӂ邽߂̎d|@(ȂقǁI͕֗łB
	T& operator*() { return *get(); }
	T* operator->() { return get();	}
	///CX^XmF擾
	T* get() { CheckInstance(); return m_lpObj; }
	///mF@U|C^B
	T* get_fast(){ return m_lpObj;}

	bool	isNull() const { return m_lpObj == NULL; }
	void Release(){
		if (m_lpObj!=NULL) {
			synchronized swimming;
			//DKUTIL_LOCKTHREAD(m_util);
			if(m_lpObj!=NULL){
				intrusive_singleton_before_delete(m_lpObj,mPtr); 
				delete m_lpObj;
				m_lpObj = NULL;
			}
			//DKUTIL_UNLOCKTHREAD(m_util);
		}
	}
	void CheckInstance(){
		if (m_lpObj==NULL) {
			synchronized swimming;
			//DKUTIL_LOCKTHREAD(m_util);
			if(m_lpObj==NULL){
				m_lpObj = new T;
				intrusive_singleton_after_new(m_lpObj,mPtr); 
			}
			//DKUTIL_UNLOCKTHREAD(m_util);
		}
	}

BOOST_PROTECTED:
	static T* m_lpObj;
	static void *mPtr;
};

//	static ȃIuWFNg
template <class T> T* intrusive_singleton<T>::m_lpObj = 0;
template <class T> void* intrusive_singleton<T>::mPtr = 0;
/*
//X}ALokisingletongȂ̂ť
template <class T,class UTIL=DKConfigUtility>
class phoenix_singleton{
public:
	typedef T self_type;
	typedef UTIL thread_policy;
	phoenix_singleton(){
		//ODS("OK singleton\n");
	}
	virtual ~phoenix_singleton() { Release(); }
	///	|C^̂ӂ邽߂̎d|@(ȂقǁI͕֗łB
	T& operator*() { return *get(); }
	T* operator->() { return get();	}
	T* get() { CheckInstance(); return m_lpObj; }
	bool	isNull() const { return m_lpObj == NULL; }
	void Release(){
		if (m_lpObj!=NULL) {
			DKUTIL_LOCKTHREAD(m_util);
			if(m_lpObj!=NULL){		
				delete m_lpObj;
				m_lpObj = NULL;
			}
			DKUTIL_UNLOCKTHREAD(m_util);
		}
	}
	void CheckInstance(){
		if (m_lpObj==NULL) {
			DKUTIL_LOCKTHREAD(m_util);
			if(m_lpObj==NULL){
				m_lpObj = new T;
			}
			DKUTIL_UNLOCKTHREAD(m_util);
		}
	}
BOOST_PROTECTED:
	static T*	m_lpObj;
	UTIL m_util;
};


//	static ȃIuWFNg
template <class T,class UTIL> T* phenix_singleton<T,UTIL>::m_lpObj = 0;
*/

}//end of dkutil namepsace

#endif //end of include once