/**
@file big_filestream.hpp
@brief 64bit̃TCỸt@CXg[


*/
#ifndef DKUTIL_FILE_SYSTEM_BIG_FILESTREAM_HPP
#define DKUTIL_FILE_SYSTEM_BIG_FILESTREAM_HPP

#include <dkutil/filesystem/interface.hpp>
#include <dkutil/synchronized.hpp>
#include <dkutil/os.hpp>
#include <dkutil/macro.hpp>
#include <dkutil/output.hpp>



namespace dkutil{

namespace policy{


#ifdef WIN32


class bigfile_operate_policy{

public:
	struct open_arg_data{
		DWORD DesiredAccess; // access (read-write) mode

		DWORD ShareMode; // share mode

		LPSECURITY_ATTRIBUTES lpSecurityAttributes;// pointer to security attributes

		DWORD CreationDisposition; // how to create

		DWORD FlagsAndAttributes; // file attributes

		HANDLE TemplateFile; // handle to file with 
	};
	typedef uint64 size_type;
	typedef size_type size_type64;
	typedef std::size_t size_type32;
	typedef HANDLE handle_type;
private:
	///nh
	HANDLE mfp;
	///OpenƂ̈̕ۑ
	open_arg_data mArg;
	///t@C̃ItZbg
	ULONGLONG mOffset;
	///
	OVERLAPPED mOL;


	///GetLastError̕ۑp
	DWORD mLastError;

	///EOF̎TRUE eof()ĂяoƃtOfalseɂȂ饥B
	bool mIsEOF;

	void _construct___(){
	
		mfp = INVALID_HANDLE_VALUE;
		mIsEOF = false;
		mLastError = NO_ERROR;
		DKUTIL_STRUCTURE_INIT(mOL);
	}
	static void exception__(const char *p){
		throw filesystem_error(p);
	}
	void check_fp()const{
		if(mfp==INVALID_HANDLE_VALUE){
			exception__("big_file_operator:openĂȂB");
		}
	}

	void correct_copy_arg_data(open_arg_data &data,const open_arg_data &x)
	{
		data = x;

		if(isOS9x()){
			//WinNT̂
			if(data.ShareMode & FILE_SHARE_DELETE){
				DKUTIL_FLAG_DOWN(data.ShareMode,FILE_SHARE_DELETE);
			}
			//FILE_FLAG_BACKUP_SEMANTICS 
			//Windows NT ̂ : obNAbv܂͕̂߂ɁAt@CI[v܂͍쐬܂B 
			if(data.FlagsAndAttributes & FILE_FLAG_BACKUP_SEMANTICS){
				DKUTIL_FLAG_DOWN(data.FlagsAndAttributes,FILE_FLAG_BACKUP_SEMANTICS);
			}
			//NULLŖꍇ͎sB
			if(isOSWin95()){
				if(data.TemplateFile){
					throw filesystem_error("Windows95Ȃ̂TemplateFilew肵ĂBR(`DL)ɃLB");
				}
			}

		}
	}
	inline void to_arg_data(open_arg_data &data,ULONG flag)
	{
		bool wm = (flag & write_mode) != 0;
		bool rm = (flag & read_mode) != 0;
		bool pm = (flag & postscript_mode) != 0;
	
		if(pm){	//ǋL[h
			/*if(wm && rm){
				data.CreationDisposition |= OPEN_EXISTING;
			}else if(wm){
				data.CreationDisposition |= OPEN_EXISTING;
			}else if(rm){
				data.CreationDisposition |= OPEN_EXISTING;
			}*/
			data.CreationDisposition |= OPEN_EXISTING;
		}else{//ǋLȂ[h
			if(wm && rm){
				//A݂I[vw
				data.CreationDisposition |= OPEN_EXISTING;
			}else if(wm){
				//㏑w
				data.CreationDisposition |= CREATE_ALWAYS;
			}else if(rm){
				//݂I[vw
				data.CreationDisposition |= OPEN_EXISTING;
			}

		}


		if(wm){
			//ݒ͓ǂݍ݂
			data.ShareMode |= FILE_SHARE_READ;
			
			data.DesiredAccess |= GENERIC_WRITE;
		}
		if(rm){
			//ǂݍݒ
			data.ShareMode |= FILE_SHARE_READ;
			
			data.DesiredAccess |= GENERIC_READ;
		}



		//ʃt@Cw
		data.FlagsAndAttributes |= FILE_ATTRIBUTE_NORMAL;

		
	}
public:
	static void visual_lasterror(){
#	ifdef DEBUG
		VISUAL_LASTERROR();
#	else
		Win32LastError err;
		dODS(err());
#	endif
	}
	BOOST_STATIC_CONSTANT(int,invalid_handle = INVALID_HANDLE_VALUE);

	/*bigfile_operate_policy(parm_string filename,open_arg_data &data){
		_construct___();
		if(filename.c_str()){
			mfilename = filename.c_str();
		}
		mArg = data;
		
	}*/
	bigfile_operate_policy(){
		_construct___();
	}

	/*bigfile_operate_policy(const bigfile_operate_policy &c){
		_construct___();
		mfp = c.mfp;
		//mfilename = c.filename();//.c_str();
		//mArg = c.mArg;
		
		
	}*/

	virtual ~bigfile_operate_policy(){
		close();
	}


	inline bool open(const char *filename,ULONG flag)
	{
		open_arg_data data={0};
		bool r = false;
		
		//dkcmFORCE_NOT_ASSERT(flag & text_mode || "eLXg[h̓T|[gĂȂ");
		to_arg_data(data,flag);

		
		if(flag & postscript_mode){
			size_type64 sz = size(filename);
			if(sz > LONGLONG_MAX){
				return false;
			}
			r = open(filename,data,(LONGLONG)sz);
		}else{
			r = open(filename,data);
		}
	
		return r;
	}
	/*!
	@param filename[in] t@C
	@param Arg[in] open_arg_data\̂ւ̎Q
	@param file_poiner[in] t@C̏݁Aǂݏo͉oCgڂ͂߂邩̒l
	*/
	bool open(const char *filename,const open_arg_data &GetArg,LONGLONG file_pointer = 0)
	{
		close();

		open_arg_data Arg;

		correct_copy_arg_data(Arg,GetArg);
				


		mfp = CreateFile(
				filename,
				Arg.DesiredAccess, // access (read-write) mode
				Arg.ShareMode, // share mode
				Arg.lpSecurityAttributes,// pointer to security attributes
				Arg.CreationDisposition, // how to create
				Arg.FlagsAndAttributes,// file attributes
				Arg.TemplateFile // handle to file with 
			//GENERIC_WRITE, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
		);
		if(mfp==INVALID_HANDLE_VALUE){
			visual_lasterror();
			return false;
		}

		/*DWORD high,low;
		
		dkcULONGLONGToTwoDWORD(&high,&low,file_pointer);
		*/
		LONG high,low;
		dkcLONGLONGToTwoLONG(&high,&low,file_pointer);

		SetFilePointer(
			mfp,    // t@Cnh 
			low,    // t@C|C^ړ鋗
			&high,    // USrbg̏ʂRQrbg 
			FILE_BEGIN     // ړ̎d 
			 );

		//ItZbgL
		mOffset =file_pointer;

		//L
		mArg = Arg;

		//EOFtO|
		mIsEOF = false;

		//LastError
		mLastError = NO_ERROR;

		return true;
	}
	HANDLE handle()const{
		return mfp;
	}
	/*HANDLE *handle(){
		return mfp;
		}*/

	/*size_type64 filesize()const{
		check_fp();
		size_type64 ull;
		dkcFileSize64(filename(),&ull);
		return ull;
	}*/
	size_type read(void *buf,size_type32 size){
		check_fp();
		DWORD red = 0;
		//OVERLAPPED OverLapped={0};
		//hFile nh FILE_FLAG_OVERLAPPED tOƂɁAlpOverlapped p[^ NULL w肷ƁÅ֐́Aǂݎ葀삪ƊԈĒʒm邱Ƃ܂BFILE_FLAG_OVERLAPPED tOƂ́ANULL w肵ȂłB
		BOOL r = ReadFile(
			mfp, // handle of file to read
			buf, // pointer to buffer that receives data
			size, // number of bytes to read
			&red, // pointer to number of bytes read
			NULL//&mOL // pointer to structure for data
		);

		if(FALSE==r)
		{
			DWORD LastError =  GetLastError();
			mLastError = LastError;

			if ( LastError == ERROR_ACCESS_DENIED ){
				 visual_lasterror();
				 return false;
			}
			else if ( LastError == ERROR_BROKEN_PIPE ){
				mIsEOF = true;
				 return false;
			}
			/*else {//error
        
					return -1;
			}*/
		}
		if (FALSE != r && red== 0)
		{// t@C̏IɒBB
			mIsEOF = true;
		}
		//if(TRUE==r && 0==red || tell() >= size()){
		//}
		/*
		I
		bResult = ReadFile(hFile, &inBuffer, nBytesToRead, &nBytesRead, NULL) ;

		// t@C̏I`FbNB

		if (bResult && nBytesRead == 0,)

		{

				// t@C̏IɒBB

		}
		񓯊
		 ֐ĂяoĔ񓯊̓ǂݎ葀sۂ EOF oꍇA
		 ReadFile ֐ 0iFALSEjԂAGetLastError ֐ ERROR_HANDLE_EOF Ԃ܂B

		*/
		mOffset += red;

		return red;
	}

	size_type ref(void *buf,size_type32 size){
		size_type trs = 0;
		size_type64 to = 0;
		synchronized swimming;
		to = tell();
		trs = read(buf,size);
		if(false==seek(to,seek_begin)){
			goto Exception;
		}
		return trs;
	Exception:
		DKUTIL_THROW_OR_NOTICE(filesystem_error("big_file_operate_policy::ref() seek error"));
		return trs;
	}

	size_type write(const void *buf,size_type32 size){
		check_fp();
		DWORD dwAccBytes;
		BOOL r = WriteFile(mfp, buf, size , &dwAccBytes, NULL);
		if(r==FALSE){
			mLastError = GetLastError();
		}
		mOffset += size;

		return dwAccBytes;
	}
#if 0
	bool seek(long offset,int origin){
		return seek(offset,0,origin);
	}
#else
	bool seek(seek_arg_type offset,int origin){
		LONG high,low;
		dkcLONGLONGToTwoLONG(&high,&low,offset);
		return seek(low,high,origin);
	}

#endif
	bool seek(LONG low,LONG high,DWORD get_origin ){
		check_fp();
		DWORD origin;
		switch(get_origin){
		case seek_begin:
			origin = FILE_BEGIN;
			break;
		case seek_current:
			origin = FILE_CURRENT;
			break;
		case seek_end:
			origin = FILE_END;
			break;
		}
		
		//hFile nh FILE_FLAG_NO_BUFFERING ꍇ́AZN^TCY̐{̈ʒuɂt@C|C^ړł܂B
		//  2 : lpDistanceToMoveHigh != NULL ̏ꍇ
		DWORD dw = SetFilePointer(mfp,
								low,
								&high, origin//FILE_BEGIN
			);

		//multithread lock

		//ł̓_?
		//if (dw == 0xFFFFFFFF && error())
		
		
		if(dw == 0xFFFFFFFF)//SetFilePointerhighnĂ̂ł̏Kv from MSDN
		{
			DWORD LastError = GetLastError();
			mLastError = LastError;
			if(LastError != NOERROR)
			{
				visual_lasterror();
				//< G[ >
				return false;
			}
		}
		//Ȃ킯邩I
		{
			//V[NƂ肠EOF@R(`DL)ɳܧ
			//mIsEOF = false;
		}
		{
			LARGE_INTEGER temp;
			temp.QuadPart = tell();
			//t@CI[̃TCY擾
			LONGLONG ll;
			LONG high = 0, low = 0;
			low = SetFilePointer(mfp,low,&high, FILE_END);
			dkcTwoLONGToLONGLONG(&ll,high,low);
			
			if(ll != tell()){
				mIsEOF = false;
			}
			

			DWORD dw = SetFilePointer(mfp,temp.LowPart,&(temp.HighPart), FILE_BEGIN	);
			if(dw == 0xFFFFFFFF && GetLastError() != NOERROR)//SetFilePointerhighnĂ̂ł̏Kv from MSDN
			{
				DKUTIL_THROW_OR_NOTICE(filesystem_error("seek eof check error"));
			}

		}
		return true;
	}
	///t@C̍ŏsizeoCgV[NB
	//bool seek_for_begin(size_type size){
	bool seek(seek_arg_type size)
	{
		LONG high,low;
		dkcLONGLONGToTwoLONG(&high,&low,size);
		
		return seek(low,high,seek_begin);
	}

	seek_arg_type tell()const{
		check_fp();
		LONGLONG ull = 0;
		
		LONG high = 0, low = 0;
		low = SetFilePointer(mfp,
								low,
								&high, 
								FILE_CURRENT
								//FILE_BEGIN
			);

		//multithread lock
		
		//low high ꏏɃQbgĂ̂ť@͊ԈႢ
		//if (low == 0xFFFFFFFF && error())
		if(0xFFFFFFFF==low)//lpDistanceToMoveHigh p[^ NULL ȊÔƂ
		{
			DWORD LastError = GetLastError();
			if(LastError != NOERROR)
			{
				visual_lasterror();
				//< G[ >
				return false;
			}
		}

		dkcTwoLONGToLONGLONG(&ull,high,low);
		return ull;
	}
	///񏧗^
	size_type64 tell64()const{
		check_fp();
		size_type64 ull = 0;
		
		LONG high = 0, low = 0;
		low = SetFilePointer(mfp,
								low,
								&high, 
								FILE_CURRENT
								//FILE_BEGIN
			);

		//multithread lock
		
		//low high ꏏɃQbgĂ̂ť@͊ԈႢ
		//if (low == 0xFFFFFFFF && error())
		if(0xFFFFFFFF==low)//lpDistanceToMoveHigh p[^ NULL ȊÔƂ
		{
			DWORD LastError = GetLastError();
			if(LastError != NOERROR)
			{
				visual_lasterror();
				//< G[ >
				return false;
			}
		}

		dkcTwoLONGToULONGLONG(&ull,high,low);
		return ull;

	}
	/*
	size_type tell(){

		check_fp();
		LONGLONG ull = 0;
		
		LONG high = 0, low = 0;
		low = SetFilePointer(mfp,
								low,
								&high, FILE_CURRENT
			);


		DWORD LastError = GetLastError();
		mLastError = LastError;
		if(LastError != NOERROR)
		{
			visual_lasterror();
			//< G[ >
			return false;
		}

		dkcTwoLONGToLONGLONG(&ull,high,low);
		return (size_type)ull;
	}*/
	
	bool flush(){
		return (0==FlushFileBuffers(mfp));
	}
	///At@CB
	void close(){
		//check_fp();
		if(mfp==INVALID_HANDLE_VALUE){
			return;
		}
		
		if(CloseHandle(mfp) == 0){
			visual_lasterror();
		}
		mfp = INVALID_HANDLE_VALUE;
		
	}
	///t@C̏I[̈B
	void write_endoffile(){
		DWORD high=0,low=0,result=0;

		//seek(low,high,FILE_BEGIN);
		flush();
		SetEndOfFile(mfp);
	}
	///t@CÏtăt@CB
	void close_endoffile(){
		write_endoffile();
		close();
	}


	size_type64 size()const{

		DWORD high = 0,low = 0;
		size_type64 ull;

		check_fp();
		low = ::GetFileSize(mfp,&high);
		dkcTwoDWORDToULONGLONG(&ull,high,low);

		return ull;
	}
	bool eof()const{
		check_fp();
		//dkcmNOT_ASSERT("ăw");
		if(::GetLastError() == ERROR_HANDLE_EOF){
			return true;
		}
		{

			register seek_arg_type pos=tell();
			return 0<=pos && size()<=pos;//ꂪB
		}
		//t@XɏĂƂ̏A܂́Atell()t@CTCY𒴂Ăꍇ
		//ӁFtell()0琔 size()1琔@ĥ
		//return (tell() >= this->size()); 
		
		
		//EOFtO̍XVƂ̖ʓ|I񂫂̎ťiX}R(`DL)ɳܧ݁j
		return mIsEOF;//̃tOԈĂ邩ǂɂ邱ƁII
	}	

	bool error()const{
		check_fp();
		///̎Ɓ@read  write OɌĂяoNO_ERRORȊOԂ\B
		//return (::GetLastError() != NO_ERROR);
		return mLastError;
	}
	static size_type64 size(const char *filename){
		DWORD high = 0,low = 0;
		ULONGLONG ull;
		BOOL r = dkcFileSize64(filename,&high,&low);
		if(FALSE==r){
			//std::string s = filename;
			//s += "not found";
			//throw filesystem_error(filename);
			DKUTIL_THROW_OR_NOTICE(filesystem_error(filename));
		}
		dkcTwoDWORDToULONGLONG(&ull,high,low);
		return ull;
	}
	///{18446744073709551614byte܂OKseek_arg_typelimit()gƎvBX}
	BOOST_STATIC_CONSTANT(uint64,limit_size = ULONGLONG_MAX);


};




#else


#endif



}//end of policy namespace


typedef filestream_interface<policy::bigfile_operate_policy> big_filestream;



///ǂȂɑ傫t@Cłǂݍ߂
class CBigFileStream : public IFileStream{
public:
	typedef IFileStream base_type;
	typedef base_type::size_type64 size_type64;
	typedef base_type::size_type size_type;
	typedef CBigFileStream self_type;
private:
	big_filestream mS;
public:
	CBigFileStream() : base_type(read_mode | binary_mode){
		

	}
	CBigFileStream(const char *filename,UINT flag) : base_type(flag){
		

		reset(filename,flag);

	}
	virtual ~CBigFileStream(){
		//clear();Ȃ񂩃oÔmS̃fXgN^ɔCB
	}
	///obt@NAB
	virtual void clear(){
		mS.close();
	}
	virtual bool reset(const char *filename,UINT flag){
		clear();
		char f[4]="";
		if(false==mS.reset(filename,flag)){
			return false;
		}
		base_type::setOpenModeFlag(flag);
		return mS.open();
	}
	/*virtual ISerializeStream& operator << (ISerializeStream &c){
		*this << 

	}*/
	seek_arg_type limit()const{
		return mS.limit();
	}
	//t@C̃TCY
	/*virtual size_type64 filesize()const{
		
		//return mS.filesize();
		//return mS.size();
	}*/
	///obt@tbV((t@CɊSɏ))B
	virtual bool flush(){
		return mS.flush();
	}
	virtual bool good()const{
		int tmp = big_filestream::invalid_handle;
		return mS.handle() != (big_filestream::handle_type)tmp;
	}
	/*!
	@param buff[out] obt@[
	@param size[in] obt@̃TCY
	@param readsize[in] ۂɓǂݍ񂾃TCY
	@return falseȂG[Biobt@Ȃj
	*/
	///ǂݍ
	virtual bool read(void *buff,size_t size,size_t *readsize){

		bool r = false;
		//sizẽe|
		size_t tsize = size;
		//ǂݍ񂾃TCỸe|
		size_t t;
		//ɏITCỸe|
		size_t tf = 0;
		char *buf = (char *)buff;
		while(1){
			t = mS.read(buf,tsize);
			tf += t;

			if(t == size){
				break;
			}else if(tf == size){
				break;
			}
			if(eof()){
				goto End;
			}
			if(error()){
				goto End;
			}
			tsize = tsize - t;
			buf = (char *)buf + t;

		}
#	ifdef DEBUG
		/*if(redsize > ULONG_MAX){
			DKUTIL_THROW_OR_NOTICE(filesysytem_error("ȃAz邩I"));
		}*/
#	endif
		r = (error()==false);
	End:
		if(readsize){//ǂ݂񂾕
			*readsize = tf;
		}
		return r;
	}

	///(GfBA`FW͖) @see IStream::write()
	virtual size_t write(const void *buff,size_t size){
		mS.responsible_write(buff,size);
		return size;

	}

	///ӔCĂׂĂ܂Ȃ^Cv
	virtual bool write(const void *buff,size_t size,size_t *write_size)
	{
		dkcmASSERT(write_size);
		*write_size = mS.write(buff,size);
		return error()==false;
	}
	/*!
	@param buff[out] obt@[
	@param size[in] obt@̃TCY
	@param readsize[in] ۂɓǂݍ񂾃TCY
	@return falseȂG[B
	@note
	read()Ƃ̈ႢF
	ref()͓̃ItZbgJEgύXȂB
	*/
	///gB
	virtual bool ref(void *buff,size_t size,size_t *readsize){
		size_type redsize = mS.ref(buff,size);
#	ifdef DEBUG
		if(redsize > ULONG_MAX){
			DKUTIL_THROW_OR_NOTICE(filesystem_error("ȃAz邩I"));
		}
#	endif
		if(readsize){
			*readsize = (size_t)redsize;
		}
		return error()==false;
	}
	/*!
	@param offset[in] originw肩牽oCgAV[N邩B
	@param origin[in] 
	@note
	fseekƓłBij
	originfseekƓwqԂł肵܂OOG
	*/
	///V[NB
	virtual bool seek(seek_arg_type offset,int origin){
		return mS.seek(offset,origin);
	}
	///̃obt@̍ŏ̃ItZbgԂB
	virtual seek_arg_type tell()const{
		return mS.tell();
	}
	virtual bool eof()const{
		return mS.eof();
	}
	virtual bool error()const{
		return mS.error();
	}
	/*!
	@note
	serialize_interfacẽ|C^Ԃ߂΁A
	VACYAfVACY肵Ă܂B
	*/
	///VACYB
	//virtual bool serialize(serialize_interface *) = 0;
	///@see IStream::data()
	virtual const void *data()const{
		return NULL;
	}
	///obt@̃TCYB
	virtual size_type size()const{
		return 0;
	}
	///obt@TCYB
	virtual void resize(size_type size){
		return;
	}

	virtual int type()const{
		return file_stream_type;
	}
	virtual const char *filename()const{
		return mS.filename();
	}
	




};


}//end of dkutil namespace



#endif



