
/*!
@since 2004/03/17 2004/12/02
@author d

*/


#ifndef DKUTIL_FILESYSTEM_CURRENT_DIR_HPP
#define DKUTIL_FILESYSTEM_CURRENT_DIR_HPP

#include <string>
//#include <dkutil/filesystem/utility.hpp>
#include <dkutil/macro.hpp>
#include <dkutil/synchronized.hpp>

namespace dkutil{


///@return std::stringԂGetCurrentDirecory()
inline std::string SafeGetCurrentDirectory(){
	char buff[dkcdMAXPATH_BUFFER];
	if(FALSE==dkcGetCurrentDirectory(buff,sizeof(buff))){
		throw std::logic_error("SafeGetCurrentDirectory Error");
	}
	return std::string(buff);
}
/*!
@param s[in] fBNg̕񂪓std::string
@param bForce[in] trueƁAfBNg݂ȂĂIɃfBNg
@return true͐
*/
///ftHgł̓fBNgƂAIɃfBNg悤ɏoĂB
inline bool SafeSetCurrentDirectory(parm_string ps,bool bForce=true){
	std::string s = ps;
	std::string::iterator it = s.end() - 1;
	if(dkcmIS_PATH_SEP(*it) ){
		s.erase(it);
	}
	if(bForce==true){//IDirectory
		if(false==FileAndFolderExist(s.c_str())){
			DKUTIL_RETURN_FALSE(CreateDirectory(s.c_str()));
		}
	}
	if(FALSE==dkcSetCurrentDirectory(s.c_str()))
	{
		return false;
	}
	return true;
}

/*!
JgfBNgꎞ`FWAXR[vAEgƌɖ߂Ă܂B
*/
///fBNgꎞ`FWƂɎg܂B
class scoped_current_directory{
	std::string mPreviousDir;
public:
	scoped_current_directory(const char *dir=NULL){
		try{
			if(dir){
				reset(dir);
			}
		}catch(...){
			undo();//߂Ă
			throw;//󂯎̂܂Ă
		}
	}
	virtual ~scoped_current_directory(){
		undo();
	}
	///fBNgύXB
	bool reset(const char *dir,bool bForce=false)
	{
		synchronized lock;
		if(empty()==false){//łɎgpς݂ꎞ߂B
			undo();
		}

		if(bForce==true){//IDirectory
			if(false==FileAndFolderExist(dir)){
				DKUTIL_RETURN_FALSE(CreateDirectory(dir));
			}
		}else{
			DKUTIL_RETURN_FALSE(FileAndFolderExist(dir));
		}
		mPreviousDir = SafeGetCurrentDirectory();
		if(FALSE==SetCurrentDirectory(dir))
		{//܂AG[0ɋ߂悤ȋC邪
			mPreviousDir.clear();
			return false;
		}
		return true;
	}
	///fBNgɖ߂
	bool undo(){
		synchronized lock;
		if(mPreviousDir.empty()) return false;
		if(FALSE==SetCurrentDirectory(mPreviousDir.c_str()))
		{
			return false;
		}
		mPreviousDir.clear();
		return true;
	}
	bool empty()const{return mPreviousDir.empty();}
	const std::string &previous_directory()const{return mPreviousDir;}
	//const char* previous_directory()const{return mPreviousDir.c_str();}
};

/**
JgfBNg̏ԂۑNX
ۑĂJgfBNg̕ɑ΃pX΃pXɕϊ\͂
*/
class current_directory_state{
	std::string mDir;
	current_directory_state(parm_string dir=NULL){
		if(dir.empty()==false){
			reset(dir);
		}
	}
	bool reset(parm_string dir)
	{
		if(dir.empty()){
			return false;
		}
		if(false==FolderExist(dir))
		{//tH_ł͂ȂB
			return false;
		}
		mDir = dir.c_str();
		return true;
	}
	std::string getCurrentDirectory(){
		return SafeGetCurrentDirectory();
	}
	void setNowCurrentDirectory(){
		if(false==reset(getCurrentDirectory())){
			DKUTIL_THROW_OR_NOTICE(
				std::runtime_error("current_directory_state::setNowCurrentDirectory() SetCurrentDirectory()ƂŖȃpX͂\B")
			);
		}
	}

	std::string getDirectory()const{
		return mDir;
	}
	///ɕۑĂJgfBNgƈ̑΃pXɐ΃pXԂB
	std::string createPath(parm_string relative_path){
		std::string s;
		if(false==createPath(s,relative_path)){
			DKUTIL_THROW_OR_NOTICE(
				std::runtime_error("current_directory_state::createPath() path generate error")
			);
		}
		return s;
	}
	/*
	@return falseŎsAdest̏Ԃ͌ɖ߂Ȃ
	@note dest͊֐clear()B
	*/
	bool createPath(std::string &dest,parm_string relative_path){
		dest.clear();
		dest += getDirectory();
		if(false==DirectoryPlusFileName(dest,relative_path)){
			return false;
		}
		return true;
	}
	
};

}//end of dkutil namespace








#endif //end of include once 
