
#ifndef DKUTIL_FILESYSTEM_LITTLEENDIAN_FILESTREAM_HPP
#define DKUTIL_FILESYSTEM_LITTLEENDIAN_FILESTREAM_HPP

//#include <dkutil_c/dkc.h>
#include <dkutil/filesystem/interface.hpp>
#include <dkutil/synchronized.hpp>
#include <dkutil/macro.hpp>
#include <dkutil/filesystem/utility.hpp>
#include <dkutil/filesystem/big_filestream.hpp>


namespace dkutil{

class CLittleEndianFileStream : public IFileStream{
	big_filestream mS;
	//t@C
	//std::string mfilename;


public:
	typedef IFileStream base_type;
	typedef base_type::size_type size_type;
	typedef base_type::size_type64 size_type64;
	typedef CLittleEndianFileStream self_type;

	/*///ד
	big_filestream &getBase(){
		return mS;
		}
	*/
	CLittleEndianFileStream() : base_type(read_mode | binary_mode){
		

	}
	CLittleEndianFileStream(const char *filename,UINT flag) : base_type(flag){
		

		reset(filename,flag);

	}
	virtual ~CLittleEndianFileStream(){
		//clear();Ȃ񂩃oÔmS̃fXgN^ɔCB
	}
	///obt@NAB
	virtual void clear(){
		mS.close();
	}
	virtual bool reset(const char *filename,UINT flag){
		clear();
		char f[4]="";
		if(false==mS.reset(filename,flag)){
			return false;
		}
		base_type::setOpenModeFlag(flag);
		return mS.open();
	}
	/*virtual ISerializeStream& operator << (ISerializeStream &c){
		*this << 

	}*/
	
	//t@C̃TCY
	/*virtual size_type64 filesize()const{
		
		//return mS.filesize();
		//return mS.size();
	}*/
	///obt@tbV((t@CɊSɏ))B
	virtual bool flush(){
		return mS.flush();
	}
	virtual bool good()const{
		int tmp = big_filestream::invalid_handle;
		return mS.handle() != (big_filestream::handle_type)tmp;
	}
	/*!
	@param buff[out] obt@[
	@param size[in] obt@̃TCY
	@param readsize[in] ۂɓǂݍ񂾃TCY
	@return falseȂG[Biobt@Ȃj
	*/
	///ǂݍ
	virtual bool read(void *buff,size_t size,size_t *readsize){

		bool r = false;
		//sizẽe|
		size_t tsize = size;
		//ǂݍ񂾃TCỸe|
		size_t t;
		//ɏITCỸe|
		size_t tf = 0;
		char *buf = (char *)buff;
		while(1){
			t = mS.read(buf,tsize);
			tf += t;

			if(t == size){
				break;
			}else if(tf == size){
				break;
			}
			if(eof()){
				goto End;
			}
			if(error()){
				goto End;
			}
			tsize = tsize - t;
			buf = (char *)buf + t;

		}
#	ifdef DEBUG
		/*if(redsize > ULONG_MAX){
			DKUTIL_THROW_OR_NOTICE(filesysytem_error("ȃAz邩I"));
		}*/
#	endif
		r = (error()==false);
	End:
		if(readsize){//ǂ݂񂾕
			*readsize = tf;
		}
		return r;
	}

	///(GfBA`FW͖) @see IStream::write()
	virtual size_t write(const void *buff,size_t size){
		mS.responsible_write(buff,size);
		return size;

	}

	///ӔCĂׂĂ܂Ȃ^Cv
	virtual bool write(const void *buff,size_t size,size_t *write_size)
	{
		dkcmASSERT(write_size);
		*write_size = mS.write(buff,size);
		return error()==false;
	}
	/*!
	@param buff[out] obt@[
	@param size[in] obt@̃TCY
	@param readsize[in] ۂɓǂݍ񂾃TCY
	@return falseȂG[B
	@note
	read()Ƃ̈ႢF
	ref()͓̃ItZbgJEgύXȂB
	*/
	///gB
	virtual bool ref(void *buff,size_t size,size_t *readsize){
		size_type redsize = mS.ref(buff,size);
#	ifdef DEBUG
		if(redsize > ULONG_MAX){
			DKUTIL_THROW_OR_NOTICE(filesystem_error("ȃAz邩I"));
		}
#	endif
		if(readsize){
			*readsize = (size_t)redsize;
		}
		return error()==false;
	}
	/*!
	@param offset[in] originw肩牽oCgAV[N邩B
	@param origin[in] 
	@note
	fseekƓłBij
	originfseekƓwqԂł肵܂OOG
	*/
	///V[NB
	virtual bool seek(seek_arg_type offset,int origin){
		return mS.seek(offset,origin);
	}
	///̃obt@̍ŏ̃ItZbgԂB
	virtual seek_arg_type tell()const{
		return mS.tell();
	}
	virtual bool eof()const{
		return mS.eof();
	}
	virtual bool error()const{
		return mS.error();
	}
	/*!
	@note
	serialize_interfacẽ|C^Ԃ߂΁A
	VACYAfVACY肵Ă܂B
	*/
	///VACYB
	//virtual bool serialize(serialize_interface *) = 0;
	///@see IStream::data()
	virtual const void *data()const{
		return NULL;
	}
	///obt@̃TCYB
	virtual size_type size()const{
		return 0;
	}
	///obt@TCYB
	virtual void resize(size_type size){
		return;
	}

	virtual int type()const{
		return file_stream_type;
	}
	virtual const char *filename()const{
		return mS.filename();
	}
	virtual seek_arg_type limit()const{
		return mS.limit();
	}
/*
	virtual ISerializeStream& operator << (char &c){
		serialize_helper(c);
		return *this;
	}
	virtual ISerializeStream& operator << (short &s){
		serialize_helper(s);
		return *this;
	}
	virtual ISerializeStream& operator << (int &n){
		serialize_helper(n);
		return *this;
	}
	virtual ISerializeStream& operator << (long &l){
		serialize_helper(l);
		return *this;
	}
	virtual ISerializeStream& operator << (LONGLONG &ll){
		serialize_helper(ll);
		return *this;
	}
	virtual ISerializeStream& operator << (BYTE &uc){
		serialize_helper(uc);
		return *this;
	}
	virtual ISerializeStream& operator << (USHORT &us){
		serialize_helper(us);
		return *this;
	}
	virtual ISerializeStream& operator << (UINT &n){
		serialize_helper(n);
		return *this;
	}
	virtual ISerializeStream& operator << (ULONG &n){
		serialize_helper(n);
		return *this;
	}
	virtual ISerializeStream& operator << (ULONGLONG &ll){
		serialize_helper(ll);
		return *this;
	}
	virtual ISerializeStream& operator << (bool &b){
		serialize_helper(b);
		return *this;
	}
*/
};


}//end of dkutil namespace



#endif
