
#ifndef DKUTIL_FILESYSTEM_UTILITY_HPP
#define DKUTIL_FILESYSTEM_UTILITY_HPP

//#include <dkutil_c/dkc.h>
#include <string>
#include <dkutil/filesystem/path_string.hpp>
#include <dkutil/macro.hpp>
#include <dkutil/dll.hpp>
#include <dkutil/parser/char_util.hpp>
#include <math.h>

#ifdef WIN32
# include <dkutil/filesystem/win32_utility.hpp>
#endif

namespace dkutil{
		
inline bool FileBinaryCompare(path_string_ref f1,path_string_ref f2){
	return DKUTIL_SUCCEEDED_BOOL(dkcFileBinaryCompare(f1.c_str(),f2.c_str()));
}
///t@CTCY𓾂B
/*!
@param str[in] t@C̖O(pXj
@param high[out] t@C̃TCY̏ʃ_u[h(MAXDWORDlow𑫂ƃt@CTCYɂȂB
@param low[out] t@CTCỶʃ_u[h
*/
///t@CTCY𓾂BbNꂽt@Cł邱Ƃôŕ֗OOG
inline bool GetFileSizeHighLow(parm_string str,DWORD *high,DWORD *low){
	/*WIN32_FIND_DATA findData={0};
	HANDLE hFind=NULL;
	// t@CTCY擾
	if((hFind = FindFirstFile(str,&findData)) == INVALID_HANDLE_VALUE){
		return false;
	}

	//t@C̃TCY
	*high = findData.nFileSizeHigh;
	*low = findData.nFileSizeLow;
	FindClose(hFind);
	return true;
	*/
	return TRUE==dkcFileSize64(str.c_str(),high,low);

}
/*!
@param str[in] t@C̖O(pXj
@param  *GetSize[out] t@C̃TCYULONGLONG^̕ϐւ̃|C^
*/
///t@CTCY𓾂BdGetFileSizeHighLow̃bp[
//inline bool GetFileSize(const char *str,ULONGLONG *GetSize){
inline bool GetFileSize64(parm_string str,ULONGLONG *GetSize){
	DWORD High=0,Low=0;
	bool result=false;
	result=GetFileSizeHighLow(str,&High,&Low);
	*GetSize = ( High * MAXDWORD ) + Low;
	return result;
}
inline bool GetFileSize(parm_string str,ULONGLONG *GetSize){
	return GetFileSize64(str,GetSize);
}
/*!
ӁFSGBȉ̃t@CTCY𓾂邱ƂoBULONG_MAX bytełˁH<br>
@return t@CTCYԂB0dGetFileSize֐s,܂͖4GBȏi ULONG_MAX byteȏ)̃t@ĈƂ\B
*/
///t@CTCY𓾂idGetFileSizẽbp[)@ULONG_MAX byteȉ̃t@Cp
inline DWORD GetFileSizeMini(parm_string str){
	ULONGLONG Get;
	if(false==GetFileSize64(str.c_str(),&Get)) return 0;
	if(ULONG_MAX < Get) return 0;
	return static_cast< DWORD >(Get);
}



///@note t@Ĉ݌̂͂II2005/09/24dkcFileExist()͂ꂪۏ؂悤ɂȂB
inline bool FileExist(parm_string s){
/*
#ifdef WIN32
#	ifdef _DEBUG
	DWORD dw = ::GetFileAttributes(s.c_str());
	return (dw != 0xFFFFFFFF);
#	else
	return (::GetFileAttributes(s) != 0xFFFFFFFF);
#	endif
#else
	return dkcFileExist(s.c_str());
#endif
*/
	return TRUE==dkcFileExist(s.c_str());
}

	
/*!
f[^Z[u:<br>
f[^ƈÍăZ[u܂B<br>
Ȃ̂ŁAoCiGfB^ŊJĂꌩ܂B<br>
@param	*pFile[in]			: f[^
@param	*pData[out]			: f[^ւ̃|C^
@param	Size[in]	: f[^TCY
@return	  true / s false
*/
inline bool SaveData( const char *pFile, void *pData, unsigned long Size )
{
	bool result = false;
	unsigned char *p = (unsigned char *)pData;
	char *guid = "LSD";
	char key = (char)(Size&0xFF);
	FILE *fp = NULL;

	// t@CI[v
	fp = fopen( pFile, "wb" );
	if ( fp == NULL ) goto END;

	// ʎq
	//fwrite( guid, sizeof(char), 4, fp );
	if(FALSE==dkcFWriteAllCheck(guid,4,fp)) goto END;
	// f[^TCY
	//fwrite( &Size, sizeof(unsigned long), 1, fp );
	if(FALSE==dkcFWriteAllCheck(&Size,sizeof(unsigned long),fp)) goto END;

	// f[^o
	while ( Size-- )
	{
		// ȒPȈÍ
		char data = *p++;
		data ^= key++;
		char temp = 0;
		temp |= (char)((data&0x0F)<<4);
		temp |= (char)((data&0xF0)>>4);

		if(temp != fputc( temp, fp ))
			goto END;
	}

	result = true;

END:
	if ( fp != NULL ) fclose( fp );

	return result;
}

/*!
f[^[h:dkutil::SaveData()ŕۑf[^[h܂B
@param *pFile[in]			: f[^
@param *pData[out]			: f[^ւ̃|C^
@param Size[in]	: f[^TCY
@return :  true / s false

*/
inline bool LoadData( const char *pFile, void *pData, unsigned long Size )
{
	bool result = false;
	unsigned char *p = (unsigned char *)pData;
	char guid[4] = "";
	unsigned long SizeTemp = 0;
	char key = 0;
	FILE *fp = NULL;

	//ʂɂȂ^^;
	//Luna::ResetCurrentDirectory();

	 //t@CI[v
	fp = fopen( pFile, "rb" );
	if ( fp == NULL ) goto END;

	// ʎq
	fread( guid, sizeof(char), 4, fp );
	if ( strcmp( guid, "LSD" ) ) goto END;

	// f[^TCY
	fread( &SizeTemp, sizeof(unsigned long), 1, fp );
	if ( SizeTemp != Size ) goto END;

	// t@CTCYL[
	key = (char)(Size&0xFF);
	unsigned long i;
	// f[^ǂݏo
	for ( i = 0; i < Size; i++ )
	{
		// ȒPȈÍ
		char temp = (char)fgetc( fp );
		char data = 0;
		data |= (char)((temp&0x0F)<<4);
		data |= (char)((temp&0xF0)>>4);
		data ^= key++;

		p[i] = data;
	}

	result = true;

END:
	if ( fp != NULL ) fclose( fp );

	return result;
}
/*!
tH_tH_̐܂B
@param	 *pPath[in]		: tH_pX
@return	:  true / s false
*/
inline bool CreateDirectory( const char *pPath )
{
/*	SECURITY_ATTRIBUTES attr={0};
	char work[MAX_PATH] = "";
	unsigned long n = 0;
	unsigned long len = strlen(pPath);
	
	while ( n < len )
	{
		 //tH_擾
		while ( n < len )
		{
			if ( (pPath[n] == '\\') && (n != '\0') )
			{
				if ( work[n-1] != ':' )
				{
					break;
				}
			}
			work[n] = pPath[n];
			n++;
		}
		work[n] = '\0';

		 //tH_쐬
		attr.nLength = sizeof(SECURITY_ATTRIBUTES);
		attr.lpSecurityDescriptor = NULL;
		attr.bInheritHandle = false;

		::CreateDirectory( work, &attr );

		work[n++] = '\\';
	}
	
	
	return true;
	*/

	return DKUTIL_SUCCEEDED(dkcCreateDirectory(pPath));
}


inline bool CreateZeroByteFile(const char *filename,bool rewrite=false){
	return TRUE==dkcCreateZeroByteFile(filename,rewrite);
}


inline void EraseSlashDotSlash(std::string &t)
{
	do{//"\\.\\"폜
		std::string::size_type tpos = t.find("\\.\\");
		if(tpos==std::string::npos) break;
		t.erase(tpos,2);
	}while(1);
}
/*!
@param dir[in][out] fBNg̖O@AɃt@C̖OǋLB
@param filename[in] t@C̖O
@return trueƐ
@throw std::stringG񉽂𓊂B
@todo SJIS΍:΍ς / "\\.\\"΍:΍ς
*/
///fBNgƃt@C̖OqB
inline bool DirectoryPlusFileName(std::string &dir,parm_string filename){
	size_t len = filename.size();
	const char *fname = filename.c_str();
	std::string spl;
	if(len >= 2){
		//ȈՐ΃pX
		//dkcmNOT_ASSERT((dkutil::isAlpha(fname[0]) && fname[1] == ':'));
		dkcmFORCE_NOT_ASSERT((dkutil::isAlpha(fname[0]) && fname[1] == ':'));
		if((dkutil::isAlpha(fname[0]) && fname[1] == ':')){
			PathSplit split;split.reset(fname);
			spl = split.mFname + split.mExt;
			fname = spl.c_str();
			//return false;
		}
	}
	if(!dir.empty()){
		if(FALSE==dkcIsTailPathSep(dir.c_str(),dir.size())){//SJIS΍ς
			dir.insert(dir.end(),dkcdPATH_SEP);
		}
	}
	if(dkcmIS_PATH_SEP(*fname)){//SJIŜPڂ\\/͖vȁH
		dir += (fname + 1);
	}else{
		dir += fname;
	}
	EraseSlashDotSlash(dir);
	return true;
}


}//end of dkutil namespace



#endif
