/*!
@file map_chip.h
@file }bv`bṽf[^\ƏiCŁj
@todo kƂׂH@AX}iCBȂɂB
*/
#ifndef DKUTIL_GRAPHICS_2D_MAPCHIP_H
#define DKUTIL_GRAPHICS_2D_MAPCHIP_H

#include <dkutil/graphics/structure.h>
#include <dkutil_c/dkcDefined.h>
#include <helper/windows_header.h>
#include <dkutil_c/dkcSHA1.h>


typedef struct dkc_Graphics2DMapChipHeader{
	///
	size_t width;
	///
	size_t height;
	///nbVliSHA1)
	BYTE hash_value[SHA1_BIN_BUFFER_SIZE];
	///̌ɑ}bv`bvID̃ItZbg 1,2,4,8̂ǂꂩQS
	BYTE offset;
}DKC_GRAPHICS_2D_MAP_CHIP_HEADER;

typedef struct dkc_Graphics2DMapChipState{
	DKC_GRAPHICS_2D_MAP_CHIP_HEADER header;
	void *memory;
	size_t size;
	int flag;
}DKC_GRAPHICS_2D_MAP_CHIP_STATE;

enum edkcCompressFlag{
	edkcNotCompress = 0,
	edkcLZSS = 1,
};


DKC_EXTERN DKC_GRAPHICS_2D_MAP_CHIP_STATE *WINAPI dkcAllocGraphics2DMapChip();

DKC_EXTERN int WINAPI dkcFreeGraphics2DMapChip(DKC_GRAPHICS_2D_MAP_CHIP_STATE **);


/**
@return edk_SUCCEEDED t@C`[gĂedk_FileCheated_ChangeԂB


*/
DKC_EXTERN int WINAPI dkcGraphics2DMapChipLoad(
	DKC_GRAPHICS_2D_MAP_CHIP_STATE *p,const char *filename,
	const BYTE *dustbin,size_t dustbin_size
);

DKC_EXTERN DKC_GRAPHICS_2D_MAP_CHIP_HEADER *WINAPI dkcGraphics2DMapChipGetHeaderPointer(
	DKC_GRAPHICS_2D_MAP_CHIP_STATE *p
);

DKC_EXTERN BOOL WINAPI dkcGraphics2DMapChipGetChipArrayInfomation(
	DKC_GRAPHICS_2D_MAP_CHIP_STATE *p,void **memory_ptr,size_t *memory_size,BYTE *offset
);


DKC_EXTERN int WINAPI dkcGraphics2DMapChipSave(
	const char *filename,
	size_t width,size_t height,BYTE offset,const BYTE *memory,size_t memory_size,
	const BYTE *dustbin,size_t dustbin_size
);


#ifndef DKUTIL_GRAPHICS_2D_MAPCHIP_C
#	include <dkutil/graphics/2d/map_chip.c>
#endif

#endif