/*!
@file polygon.h
@brief 2Dp polygon`ASY(Cp)
*/


#ifndef DKUTIL_GRAPHICS_2D_POLYGON_H
#define DKUTIL_GRAPHICS_2D_POLYGON_H

#include <dkutil/graphics/structure.h>
#include <dkutil_c/dkcOSIndependent.h>

typedef int (*dkcfpDRAW_LINE)(int x1,int y1,int x2,int y2,int color);
typedef int (*dkcfpDRAW_PIXEL)(int x1,int y1,int color);
typedef int (*dkcfpDRAW_BOX)(int x1,int y1,int x2,int y2,int color);
typedef int (*dkcfpDRAW_CIRCLE)(int x , int y , int r , int color);
typedef int (*dkcfpDRAW_OVAL)( int x , int y , int rx , int ry , int color);
typedef int (*dkcfpDRAW_TRIANGLE)(int x1, int y1, int x2, int y2,int x3, int y3, int color);

typedef struct dkc_2DFigureDraw{
	dkcfpDRAW_LINE mLine;
	dkcfpDRAW_PIXEL mPixel;
	dkcfpDRAW_BOX mBox;
	dkcfpDRAW_CIRCLE mCircle;
	dkcfpDRAW_OVAL mOval;
	dkcfpDRAW_TRIANGLE mTriangle;
}DKC_2D_FIGURE_DRAW_INTERFACE;

DKC_EXTERN int WINAPI dkcDrawPolygon2D(DKC_POINT2D *p,size_t size,int color,DKC_2D_FIGURE_DRAW_INTERFACE *);
/*!
@param p[in] lp`Ɣ肵_f[^
@param size[in] p̃ANZX\TCY
@param rect[out] pɓꂽ_lp`̏ꍇÃ|C^Ɏlp`RECTll߂ĂBNULLłOK
@return TRUEƎlp`
*/

DKC_EXTERN BOOL WINAPI dkcIsSquare(DKC_POINT2D *p,size_t size,DKC_RECT *rect);


#ifndef DKUTIL_GRAPHICS_2D_POLYGON_C
#	include <dkutil/graphics/2d/polygon.c>
#endif

#endif