/*!
@file structure.hpp
@file {Iȃf[^\
@note
ς񂾂ˁ@_|P|
*/
#ifndef DKUTIL_GRAPHICS_STRUCTURE_HPP
#define DKUTIL_GRAPHICS_STRUCTURE_HPP

#include <dkutil/graphics/structure.h>


namespace dkutil{


///_f[^
template<class Coordinates>
struct Point{
	typedef Coordinates coordinates_type;
	Coordinates x;
	Coordinates y;
};

///`f[^
template<class Coordinates>
struct Rect{
	typedef Coordinates coordinates_type;
	Coordinates left;
	Coordinates top;
	Coordinates right;
	Coordinates bottom;
};

///J[f[^
template<class COLOR__>
class Color{
	COLOR__ mColor;
public:
	typedef color_type;
	Color(){
		mColor = 0;
	}
	void setColor(const color_type &x){
		mColor = x;
	}
	const color_type &getColor()const{
		return mColor;
		}
	color_type getColor(){
		return mColor;
	}

};

struct Color4byte : public Color<int>{
	typedef Color<int> base_type;
	typedef Color4byte self_type;
	typedef base_type::color_type color_type;




	///http://www.geocities.co.jp/SiliconValley-SanJose/5309/index1.html 
	color_type getGrayScale(){
		color_type color = base_type::getColor();

		unsigned char r,g,b;
		unsigned char y;
		r= (unsigned char) ((color) & 0xff);
		g =(unsigned char)(((color) & 0xff00)>>8);
		b =(unsigned char)(((color) & 0xff0000)>>16);
		y = (unsigned char) (0.299*(double)r + 0.587*(double)g + 0.114*(double)b);
		color = 0;
		color = y | y<<8 | y<<16;
		return color;
	}

};



}//end of dkutil namespace



#endif