#include "CommonControl.h"


#include <windows.h>
#include <shlobj.h>
#include <mbstring.h>
#include <Shlwapi.h>
#include <objbase.h>
#include <commctrl.h>
#include <commdlg.h>
//#include <winnls32.h> ƁApWindowsŋNł˂I
#include <imm.h>
#include <basetsd.h>


#if _MSC_VER >= 1200
#pragma comment(lib,"comctl32")
#pragma comment(lib,"comdlg32")
#pragma comment(lib,"imm32")
#endif
;
namespace dkutil{

FolderSelector::FolderSelector(char *GetPath,size_t BuffSize,const char *folder,bool *flag){
	*flag = DKUTIL_SUCCEEDED(FolderSelectLogic(GetPath,BuffSize,folder,NULL,BIF_EDITBOX,NULL));
}

FolderSelector::FolderSelector(std::string &GetPath,const char *folder)
{
	GetPath.clear();
	char path[MAX_PATH]="";
	FolderSelect(path,sizeof(path),folder);
	GetPath = path;
}
	// R[o[N֐
int CALLBACK FolderSelector::BrowseCallbackProc( HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData )
{
	// tH_I_CAȌ
	if ( (BFFM_INITIALIZED == uMsg) && lpData ){
		SendMessage( hWnd, BFFM_SETSELECTION, TRUE, lpData );
	}
	return 0;
}//BrowseCallbackProc
int FolderSelector::select_with_file(std::string &buff,const char *folder,const char *title,HWND handle )
{
	char a[MAX_PATH * 2]="";
	UINT flag = BIF_BROWSEINCLUDEFILES | BIF_EDITBOX ;
	int r = FolderSelectLogic(a,sizeof(a),folder,title,flag,handle);
	buff = a;
	return r;
}
int FolderSelector::FolderSelect(char *GetPath,size_t BuffSize,const char *folder){
	return FolderSelectLogic(GetPath,BuffSize,NULL,NULL,BIF_EDITBOX,NULL);
}
int FolderSelector::FolderSelectLogic(char *GetPath,size_t BuffSize,
		const char *folder,const char *Title,
		UINT Flag,HWND WindowHandle)
	{
	if(BuffSize == 0) return edk_FAILED;
	char *pDir = GetPath;
	pDir[0] = '\0';

	HRESULT hr;
	BROWSEINFO bi={0};
	ITEMIDLIST *lpid = NULL;
	LPMALLOC pMalloc = NULL;

	bi.hwndOwner	= WindowHandle;
	bi.ulFlags		= Flag;
	if(!Title){
		bi.lpszTitle	= "fBNgw";
	}else{
		bi.lpszTitle = Title;
	}
	if(folder){
		bi.lpfn   = BrowseCallbackProc; // R[o[N֐
		bi.lParam = (LPARAM)folder;       // tH_
	}
	//\ing
	lpid = SHBrowseForFolder( &bi );

	if ( lpid == NULL )
	{
		//cancelꂽB
		return edk_Not_Selected;
	}
	else
	{
		hr = SHGetMalloc( &pMalloc );
		if ( hr == E_FAIL )
		{
			MessageBox(WindowHandle,  "SHGetMalloc Error", "Error",MB_OK);
			return edk_FAILED;
		}

		SHGetPathFromIDList( lpid, pDir );
		if ( pDir[strlen(pDir) - 1] != '\\' ){
			if(false==dkcFileExist(pDir))
			{//tH_tH_ɂB
				dkstrcat_amap(pDir,BuffSize,strlen(pDir),"\\",strlen("\\"));
			}
			//strcat( pDir, "\\" );
		}

		pMalloc->Free( lpid );
		pMalloc->Release();
	}
	return edk_SUCCEEDED;
}


}//end of dkutil namespace


