/**
@note
ProgressDialog.hC++ wrapper
 */
#ifndef DKUTIL_GUI_WIN32_PROGRESS_DIALOG_HPP
#define DKUTIL_GUI_WIN32_PROGRESS_DIALOG_HPP

#include "ProgressDialog.h"

namespace dkutil{

	class ProgressDialogBase{
	protected:
		BOOL mIsCancel;
		unsigned int mPercentage;
		HWND mhwnd;
		void init(){
			mPercentage = 0;
			mIsCancel = FALSE;
			mhwnd = NULL;
		}

	public:
		ProgressDialogBase(){
			init();
		}
		virtual ~ProgressDialogBase(){
			close();
		}
		virtual bool open(const char *str=NULL) = 0;
		virtual void close() = 0;
		virtual bool setMoveText(const char *str,unsigned int textboxsize=0) = 0;
		unsigned int operator++(){
			return operator+=(1);
		}
		unsigned int operator++(int){
			return operator++();
		}
		unsigned int operator+=(unsigned int t){
			t += mPercentage ;
			setPercentage(t);
			return mPercentage;
		}
		void setPercentage(unsigned int t){
			mPercentage = t;
			if(mPercentage > 100){
				mPercentage = 100;
			}
		}
		///LZ{^ꂽ
		bool isCancel()const{
			return mIsCancel;
		}
		HWND getWindowHandle(){
			return mhwnd;
		}

	};

	///dKingyoProgressDialog.dllp
	class ProgressDialogDLL : public ProgressDialogBase
	{
		DKC_PROGRESS_DIALOG_DO_MODELESS_F_TYPE func;
		DKC_PROGRESS_DIALOG_FREE_F_TYPE free_f;
		DKC_PROGRESS_DIALOG_SET_MOVE_TEXT_F_TYPE settext_f;
		HMODULE h;
	public:
		ProgressDialogDLL(){
			func = NULL;
			free_f = NULL;

			h = NULL;

		}
		virtual ~ProgressDialogDLL(){
			close();
		}
		bool open(const char* movestr=NULL){
			close();
			h = LoadLibrary("dKingyoProgressDialog.dll");
			if(NULL==h){
				return false;
			}
			func = (DKC_PROGRESS_DIALOG_DO_MODELESS_F_TYPE)GetProcAddress(h,"dkcProgressDialogDoModeless");
			if(NULL==func){
				return false;
			}
			free_f = (DKC_PROGRESS_DIALOG_FREE_F_TYPE)GetProcAddress(h,"dkcProgressDialogFree");
			if(NULL==free_f){
				return false;
			}
			settext_f = (DKC_PROGRESS_DIALOG_SET_MOVE_TEXT_F_TYPE)GetProcAddress(h,"dkcProgressDialogSetMoveText");
			if(NULL==free_f) return false;

			mhwnd = func(&mPercentage,movestr,&mIsCancel);
			if(NULL==mhwnd){
				return false;
			}
			return true;
		}
		void close(){
			if(mhwnd){
				free_f(mhwnd);
			}
			if(h)
			{
				FreeLibrary(h);
				h = NULL;
				func = NULL;
				free_f = NULL;
			}
			init();
		}
		bool setMoveText(const char *str,unsigned int textboxsize=0){
			if(settext_f){
				return settext_f(mhwnd,str,textboxsize);
			}
			return false;
		}

		HMODULE getDLLHandle(){
			return h;
		}
	};

	///dkutil_gui_win32 p
	class ProgressDialog : public ProgressDialogBase{
	public:
		ProgressDialog(){
		}
		virtual ~ProgressDialog(){
			close();
		}
		virtual bool open(const char* movestr=NULL);
		virtual void close();
		virtual bool setMoveText(const char *str,unsigned int textboxsize=0);
		
	};
}

#endif