#include <windows.h>
#define DKINGYOPROGRESSDIALOG_NOT_IMPORT
#include "ProgressDialog.h"



int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	HMODULE h = LoadLibrary("dKingyoProgressDialog.dll");
	DKC_PROGRESS_DIALOG_DO_MODELESS_F_TYPE func;
	DKC_PROGRESS_DIALOG_FREE_F_TYPE free_f;
	DKC_PROGRESS_DIALOG_SET_MOVE_TEXT_F_TYPE settext_f;

	if(NULL==h){
		return -1;
	}
	func = (DKC_PROGRESS_DIALOG_DO_MODELESS_F_TYPE)GetProcAddress(h,"dkcProgressDialogDoModeless");
	if(NULL==func){
		return -2;
	}
	free_f = (DKC_PROGRESS_DIALOG_FREE_F_TYPE)GetProcAddress(h,"dkcProgressDialogFree");
	if(NULL==free_f){
		return -3;
	}
	settext_f = (DKC_PROGRESS_DIALOG_SET_MOVE_TEXT_F_TYPE)GetProcAddress(h,"dkcProgressDialogSetMoveText");
	if(NULL==settext_f){
		return -4;
	}
	//Loop
	{

		unsigned int percentage = 0;
		BOOL isCancel = FALSE;
		MSG msg;
		DWORD tt,t;
		HWND h = func(&percentage,NULL,&isCancel);
		if(NULL==h){
			return -4;
		}
		dkcProgressDialogShowAndUpdate(h,nShowCmd);
		tt = GetTickCount();
		while(dkcProgressDialogMessageProcess(&msg)){//processing loop
			t = GetTickCount();
			if(t - tt > 120){
				percentage += 1;
				tt = t;
			}
			if(percentage == 50){
				settext_f(h," :-D   50% over",0);
			}
			if(percentage >= 100 || isCancel){
				break;
			}
		}
		if(FALSE==free_f(h)){//not found
			return -5;
		}

	}
	return 0;
}
