


#include "..\ProgressDialog.h"
#include <helper/boost_assert.hpp>
#include <dkutil/dll.hpp>
#include <dkutil/output.hpp>

using namespace dkutil;
int loadlib(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{

	DLLManager mgr;
#ifdef _DEBUG
	const char *dllname = "dKingyoProgressDialogd.dll";
#else
	const char *dllname = "dKingyoProgressDialog.dll";
#endif
	const char *functionname="dkcProgressDialogDoModeless";
	const char *freefunctionname="dkcProgressDialogFree";

	if(false==mgr.reset(dllname)){
		dMB("not found %s",dllname);
		return -1;
	}
	DKC_PROGRESS_DIALOG_DO_MODELESS_F_TYPE func;
	DKC_PROGRESS_DIALOG_FREE_F_TYPE free_f;

	func = (DKC_PROGRESS_DIALOG_DO_MODELESS_F_TYPE)mgr.find(functionname);
	if(NULL==func){
		dMB("not found %s function",functionname);
		return -2;
	}
	free_f = (DKC_PROGRESS_DIALOG_FREE_F_TYPE)mgr.find(freefunctionname);
	if(NULL==free_f){
		dMB("not found %s function",freefunctionname);
		return -2;
	}
	{
		unsigned int percentage = 0;
		BOOL isCancel = FALSE;

		HWND hwnd = func(&percentage,NULL,&isCancel);

		if(!hwnd){
			dMB("can't create dialog");
			return -3;
		}
		dkcProgressDialogShowAndUpdate(hwnd,nShowCmd);
		MSG msg;
		DWORD tt = GetTickCount();
		while(dkcProgressDialogMessageProcess(&msg)){
			if(isCancel){
				break;
			}
			DWORD t = GetTickCount();
			if(t - tt > 200){
				percentage += 5;//ꂪdƎv
				tt = t;
			}
			if(percentage >= 100){
				break;
			}
		}
		free_f(hwnd);
	}
	return 0;
}


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	dkcCheckMemoryLeak(TRUE);
	return loadlib(hInstance,hPrevInstance,lpCmdLine,nShowCmd);

}
