/*!
@author d
@since 2004/2/4
@note
̃wb_łg悤ɂII
*/
#ifndef DKUTIL_MERSENNE_TWISTER_HPP
#define DKUTIL_MERSENNE_TWISTER_HPP
//#include "oldmath/dKingyoRandom.h"

#include <dkutil/math/interface.hpp>
#include <dkutil/math/utility.hpp>
#include <dkutil_c/mt/dkcMTRand.h>

namespace dkutil{
namespace policy{

class mt_rand32{
protected:
	DKC_MT_RAND32 *mpState;
	uint32 mSeed;
	void clear(){
		if(mpState){
			dkcFreeMTRand32(&mpState);
		}
	}

public:
	typedef uint32 result_type;
	typedef DKC_MT_RAND32 state_type;
	typedef uint32 seed_type;
	typedef random_functor<result_type,seed_type,mt_rand32> random_functor_type;
	typedef random_domain_functor<result_type,seed_type,mt_rand32> random_domain_functor_type;

	BOOST_STATIC_CONSTANT(result_type,rand_max = 0xffffffff);
	BOOST_STATIC_CONSTANT(uint32,bit_max = 32);
	result_type getRandMax()const
	{
		return rand_max;
	}
	ansi_rand(seed_type apple_seed = time(NULL)){
		mpState = NULL;
		seed(apple_seed);
	}
	const state_type &getState()const{	return *mpState;}
	state_type &getState(){return *mpState};

	void seed(seed_type l){
		clear();
		mpState = dkcAllocMTRand32(l);
	}
	result_type rand(){
		return dkcMTRand32Get_INL(mpState);
	}
	result_type random(result_type Max_){
		random_functor_type f
		return f(Max_,*this);
	}
	result_type random(result_type Min_,result_type Max_){
		random_domain_functor_type f;
		return f(Min_,Max_,*this);
		
	}


};		
}
typedef rng_interface<policy::mt_rand32> rngMersenneTwister;
}//end of dkutil namespace







#endif



