
#define DKUTIL_MEMORY_CHECK_LEAK_CPP


#include <dkutil/memory/check_leak.hpp>

static dkutil::MemoryLeakChecker ch;

namespace dkutil{
	

void check_memoryleak(bool flag){
	ch.setCheckFlag(flag);
}
void leak_output_debugstring(){
	ch.leak_output_debugstring();
}
void leak_output_printf(){
	ch.leak_output_printf();
}
MemoryLeakChecker::pointer check_memoryleak_alloc_base(size_t size,const char *filename,uint64 line_)
{
	return ch.allocate(size,filename,line_);
}

void check_memoryleak_free_base(MemoryLeakChecker::pointer p,const char *filename,uint64 line_)
{
	ch.deallocate(p,filename,line_);
}


}//end of dkutil namespace
/*
check_memoryleak_sig sig;
void test(){
	delete new int;
	//int *pp = ::new int[20];
	//delete[] pp;
	check_memoryleak_sig sss;
 int *p =  DKUTIL_CHECK_LEAK_NEW int;

 DKUTIL_CHECK_LEAK_DELETE(p);
 int *p2 = DKUTIL_CHECK_LEAK_NEW int[20];
 DKUTIL_CHECK_LEAK_DELETE_ARRAY(p2);


}
void *operator new(size_t size,check_memoryleak_sig sig,const char *filename,size_t line_ )
{
	return ch.allocate(size,filename,line_);

}

void* operator new[] (size_t size,check_memoryleak_sig sig,const char *filename,size_t line_ )
{
	return ch.allocate(size,filename,line_);

}

void operator delete (void *p,check_memoryleak_sig sig,const char *filename,size_t line_ )
{

	ch.deallocate(p,filename,line_);
}

void operator delete[] (void *p,check_memoryleak_sig sig,const char *filename,size_t line_ )
{

	ch.deallocate(p,filename,line_);
}*/