
#ifndef DKUTIL_NETWORK_SOCKET_ASYNC_IO_HPP
#define DKUTIL_NETWORK_SOCKET_ASYNC_IO_HPP

#include <helper/windows_header.h>
#include <dkutil/detail/lunalibdef.hpp>

namespace dkutil{



/**
	@brief	\PbgNX

	WindowsSocket߂̃bp[NXłB
	WinSock2.0̋@\gĂA񓯊ɂ
	ΉĂ܂B
	DirectPlayglbg[NƂ͈Ⴂ
	\PbgȂ̂LinuxȂǂ̂ق̃vbg
	tH[Ƃ̒ʐMeՂɍs܂B

    @todo	------------------------
    @bug	------------------------
*/

class LunaSocketAsyncIO
{
	typedef LunaSocketAsyncIO self_type;

	
	// VARIABLE
	
	static WORK_LUNASOCKETASYNCIO *pWork;
	//WORK_LUNASOCKETASYNCIO *pWork;

	
	/**
		NX̏܂B

		@param pWorkData	[in] [NGÃAhX

		@retval true	
		@retval false	s
	*/
	
	bool Initialize( void *pWorkData )
	{
		//Luna::LogoutMainCategory( "LunaSocketAsyncIONX̏" );
		//Luna::LogoutNextLine();

		//----------------------------------------------------------
		// [NGA̎擾
		//----------------------------------------------------------
		pWork = (WORK_LUNASOCKETASYNCIO*)pWorkData;

		//----------------------------------------------------------
		// [NGȀ
		//----------------------------------------------------------
		MemoryClear( pWork, sizeof(WORK_LUNASOCKETASYNCIO) );
		pWork->Socket = INVALID_SOCKET;

		return true;
	}

	
	/**
		NX̉܂B
	*/
	
	void Uninitialize( void )
	{
		//Luna::LogoutMainCategory( "LunaSocketAsyncIONX̉" );
		//Luna::LogoutNextLine();

		Shutdown();
	}

	
	/**
		ڑ̃lbg[Nؒf܂
	*/
	
	void Shutdown( void )
	{
		//-------------------------------------------------------
		// \Pbgؒf
		//-------------------------------------------------------
		if ( pWork->IsConnect )
		{
			char TempBuff[64] = "";
			::shutdown( pWork->Socket, SD_SEND );
			while ( ::recv( pWork->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
			::shutdown( pWork->Socket, SD_BOTH );
			::closesocket( pWork->Socket );

			pWork->IsConnect = false;
			pWork->IsInitialize = false;
		}
	}

	
	/*
		ŌɔG[𕶎̏ԂŎ擾܂

		@param pError	: G[i[obt@

		@retval true	G[ꍇ
		@retval false	G[Ȃꍇ
	*/
	
	bool GetLastError( char *pError )
	{
		if ( pWork->LastError[0] != '\0' )
		{
			strcpy( pError, pWork->LastError );
			return true;
		}

		return false;
	}

	
	/**
		WinSock̏܂

		@retval true	
		@retval false	s
	*/
	
	bool Start( void )
	{
		pWork->Socket = ::WSASocket( AF_INET, SOCK_STREAM, IPPROTO_TCP, NULL, 0, WSA_FLAG_OVERLAPPED );
		if ( pWork->Socket == INVALID_SOCKET )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}

		pWork->IsInitialize = true;

		return true;
	}

	
	/**
		w薼̃zXg擾܂

		@param pServerString	[in] zXgʖ̊i[AhXizXgłhołj
		@param pHost			[out] zXgi[AhX

		@retval true	
		@retval false	s
	*/
	
	bool GetHostInfo( const char *pServerString, HOSTINFO *pHost )
	{
		long i;
		IN_ADDR InAddrHost;
		HOSTENT *pHostEntry;

		//------------------------------------------------------------
		// w肳ꂽ񂪃zXghoAhXׂ
		//------------------------------------------------------------
		InAddrHost.s_addr = ::inet_addr( pServerString );
		if ( InAddrHost.s_addr == INADDR_NONE )
		{
			// hoł͂Ȃ̂ŃzXgƂď
			pHostEntry = ::gethostbyname( pServerString );
			if ( pHostEntry == NULL )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return false;
			}
		}
		else
		{
			// hoAhX̂悤ł
			pHostEntry = ::gethostbyaddr( (const char *)&InAddrHost, sizeof(IN_ADDR), AF_INET );
			if ( pHostEntry == NULL )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return false;
			}
		}

		//------------------------------------------------------------
		// zXg̕ۑ
		//------------------------------------------------------------
		MemoryClear( &pWork->HostInfo, sizeof(pWork->HostInfo) );

		// zXg
		strcpy( pWork->HostInfo.Name, pHostEntry->h_name );

		// zXg̕ʖ
		for ( i = 0; pHostEntry->h_aliases[i] != NULL; i++ )
		{
			strcpy( pWork->HostInfo.Alias[pWork->HostInfo.AliasCount++], pHostEntry->h_aliases[i] );
		}

		// AhX
		for ( i = 0; pHostEntry->h_addr_list[i] != NULL; i++ )
		{
			const char *p = ::inet_ntoa( *((IN_ADDR*)pHostEntry->h_addr_list[i]));
			strcpy( pWork->HostInfo.Address[pWork->HostInfo.AddressCount++], p );
		}

		// f[^TCY
		pWork->HostInfo.Length = pHostEntry->h_length;
		// f[^^Cv
		pWork->HostInfo.Type = pHostEntry->h_addrtype;

		//------------------------------------------------------------
		// zXgf[^Rs[
		//------------------------------------------------------------
		if ( pHost != NULL )
		{
			MemoryCopy( pHost, &pWork->HostInfo, sizeof(HOSTINFO) );
		}

		MemoryCopy( &pWork->HostEntry, pHostEntry, sizeof(HOSTENT) );

		return true;
	}


	/**
		[JzXg擾܂

		@param pName	[out] zXgi[|C^
	*/

	void GetLocalHostName( char *pName )
	{
		char Buff[256] = "";
		// zXg擾
		::gethostname( Buff, sizeof(Buff) );
		strcpy( pName, Buff );
	}


	/**
		w肵T[o[ւ̐ڑs܂

		@param pServerString	[in] zXgʖ̊i[AhXizXgłhołj
		@param PortNo			[in] |[gԍ

		@retval true	
		@retval false	s
	*/

	bool ConnectServer( const char *pServerString, unsigned short PortNo )
	{
		long ReturnCode;
		SOCKADDR_IN SockAddr;

		//------------------------------------------------------------
		// zXgf[^擾
		//------------------------------------------------------------
		if ( !GetHostInfo( pServerString, NULL ) )
		{
			return false;
		}

		//------------------------------------------------------------
		// ڑpf[^
		//------------------------------------------------------------
		MemoryClear( &SockAddr, sizeof(SOCKADDR_IN) );
		SockAddr.sin_family	= AF_INET;
		SockAddr.sin_port	= ::htons( PortNo );
		SockAddr.sin_addr	= *((IN_ADDR*)pWork->HostEntry.h_addr_list[0]);

		//------------------------------------------------------------
		// ڑ
		//------------------------------------------------------------
		ReturnCode = ::WSAConnect( pWork->Socket, (SOCKADDR*)&SockAddr, sizeof(SOCKADDR_IN), NULL, NULL, NULL, NULL );
		if ( ReturnCode == SOCKET_ERROR )
		{
			ReturnCode = ::WSAGetLastError();
			if ( ReturnCode != WSAEWOULDBLOCK )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return false;
			}
		}

		pWork->IsConnect = true;

		return true;
	}

	/**
		MopR[obN֐

		@param Error	[in] G[R[h
		@param Recv		[in] MoCg
		@param pOver	[in] I[o[bvf[^
		@param Flags	[in] tO
	*/

	static void WINAPI RecvComplete( unsigned long Error, unsigned long Recv, WSAOVERLAPPED *pOver, unsigned long Flags )
	{
		pWork->IsRequest = false;

		if ( Error != 0 )
		{
			GetMakeError( Error, pWork->LastError );
			pWork->RequestCode = -1;
			return;
		}

		if ( Recv == 0 )
		{
			pWork->RequestCode = -2;
			return;
		}

		pWork->RequestCode = 0;
	}


	/**
		MopR[obN֐

		@param Error	[in] G[R[h
		@param Send		[in] MoCg
		@param pOver	[in] I[o[bvf[^
		@param Flags	[in] tO
	*/

	static void WINAPI SendComplete( unsigned long Error, unsigned long Send, WSAOVERLAPPED *pOver, unsigned long Flags )
	{
		pWork->IsRequest = false;

		if ( Error != 0 )
		{
			GetMakeError( Error, pWork->LastError );
			pWork->RequestCode = -1;
			return;
		}

		if ( Send == 0 )
		{
			pWork->RequestCode = -2;
			return;
		}

		pWork->RequestCode = 0;
	}


	/**
		w肵f[^ڑɑM܂

		@param pData	[out] f[^MiM܂ł͕ێĂȂ΂ȂȂj
		@param Size		[in] MTCY

		@param pData	[in] f[^AhX
		@param Size		[in] f[^TCY

		@return		MoCg -1 Ŏs
	*/

	long SendRequest( const void *pData, unsigned long Size )
	{
		if ( !pWork->IsRequest )
		{
			unsigned long SendByte = 0;
			MemoryClear( &pWork->Overlap, sizeof(WSAOVERLAPPED) );

			//--------------------------------------------
			// Mf[^obt@
			//--------------------------------------------
			pWork->SendBuff.len	= Size;
			pWork->SendBuff.buf	= (char *)pData;

			//--------------------------------------------
			// f[^MNGXg
			//--------------------------------------------
			long Result = ::WSASend(
								pWork->Socket,
								&pWork->SendBuff,
								1,
								&SendByte,
								0,
								&pWork->Overlap,
								self_type::SendComplete );
			if ( Result == SOCKET_ERROR )
			{
				if ( ::WSAGetLastError() != WSA_IO_PENDING )
				{
					GetMakeError( ::WSAGetLastError(), pWork->LastError );
					return -1;
				}
			}

			pWork->RequestCode = -3;
			pWork->IsRequest = true;

			return 0;
		}

		return -3;
	}


	/**
		f[^ǂݍ݂̊Jnvs܂

		@param pData	[out] f[^MiM܂ł͕sj
		@param Size		[in] MTCY

		@retval -3		݃NGXg
		@retval -2		ڑ͕ꂽ
		@retval -1		Ms
		@retval	0		NGXgJn
	*/

	long ReceiveRequest( void *pData, unsigned long Size )
	{
		if ( !pWork->IsRequest )
		{
			unsigned long RecvByte = 0;
			unsigned long Flag = 0;
			MemoryClear( &pWork->Overlap, sizeof(WSAOVERLAPPED) );

			//--------------------------------------------
			// Mf[^obt@
			//--------------------------------------------
			pWork->RecvBuff.len	= Size;
			pWork->RecvBuff.buf	= (char *)pData;

			//--------------------------------------------
			// f[^MNGXg
			//--------------------------------------------
			long Result = ::WSARecv(
								pWork->Socket,
								&pWork->RecvBuff,
								1,
								&RecvByte,
								&Flag,
								&pWork->Overlap,
								self_type::RecvComplete );
			if ( Result == SOCKET_ERROR )
			{
				if ( ::WSAGetLastError() != WSA_IO_PENDING )
				{
					GetMakeError( ::WSAGetLastError(), pWork->LastError );
					return -1;
				}
			}

			pWork->RequestCode = -3;
			pWork->IsRequest = true;

			return 0;
		}

		return -3;
	}


	/**
		NGXgI`FbN

		@retval true	IĂ
		@retval false	IĂȂ
	*/

	bool IsRequestEnd( void )
	{
		if ( pWork->IsRequest )
		{
			::SleepEx( 0, TRUE );
		}

		return !pWork->IsRequest;
	}


	/**
		NGXgʎ擾

		@retval -3		݃NGXg
		@retval -2		ڑ͕ꂽ
		@retval -1		Ms
		@retval	0		NGXg
	*/

	long GetRequestResult( void )
	{
		return pWork->RequestCode;
	}




	/**
		G[R[hG[擾܂

		@param ErrorCode	[in] G[R[h
		@param pErrStr		[out] G[bZ[Wi[
	*/

	static void GetMakeError( long ErrorCode, char *pErrStr )
	{
		MemoryClear( pWork->LastError, sizeof(pWork->LastError) );
		GetSocketError( ErrorCode, pErrStr );
	}


};

}//end of dkutil namespace



#endif