
/** @file
    @brief		񓯊^\PbgT[o[NX
    @author		Noriyuki Lee
    @since		2003.07.01
*/


//=============================================================================
// INCLUDE
//=============================================================================
#include "Luna.h"
#include "LunaSocketServerAsync.h"
#include "LunaSystem.h"
#include "LunaMemory.h"

#include "LunaWork.h"


//=============================================================================
// VARIABLE
//=============================================================================
static WORK_LUNASOCKETSERVERASYNC *pWork;


//=============================================================================
/**
	NX̏܂B

	@param pWorkData	[in] [NGÃAhX

	@retval true	
	@retval false	s
*/
//=============================================================================
bool LunaSocketServerAsync::Initialize( void *pWorkData )
{
	Luna::LogoutMainCategory( "LunaSocketServerAsyncNX̏" );
	Luna::LogoutNextLine();

	//----------------------------------------------------------
	// [NGA̎擾
	//----------------------------------------------------------
	pWork = (WORK_LUNASOCKETSERVERASYNC*)pWorkData;

	//----------------------------------------------------------
	// [NGȀ
	//----------------------------------------------------------
	MemoryClear( pWork, sizeof(WORK_LUNASOCKETSERVERASYNC) );
	pWork->Socket = INVALID_SOCKET;

	return true;
}

//=============================================================================
/**
	NX̉܂B
*/
//=============================================================================
void LunaSocketServerAsync::Uninitialize( void )
{
	Luna::LogoutMainCategory( "LunaSocketServerAsyncNX̉" );
	Luna::LogoutNextLine();

	Release();
}

//=============================================================================
/**
	WinSock̉s܂
*/
//=============================================================================
void LunaSocketServerAsync::Release( void )
{
	Shutdown();
}

//=============================================================================
/**
	ڑ̃lbg[Nؒf܂
*/
//=============================================================================
void LunaSocketServerAsync::Shutdown( void )
{
	//-------------------------------------------------------
	// NCAgXg̉
	//-------------------------------------------------------
	CONNECTCLIENTDATA *p = pWork->pConnectionList;
	while ( p != NULL )
	{
		CONNECTCLIENTDATA *pNext = p->pNext;

		char TempBuff[64] = "";
		::shutdown( p->Socket, SD_SEND );
		while ( ::recv( p->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
		::shutdown( p->Socket, SD_BOTH );
		::closesocket( p->Socket );

		MemoryFree( p );

		p = pNext;
	}

	pWork->pConnectionList = NULL;

	//-------------------------------------------------------
	// \Pbgؒf
	//-------------------------------------------------------
	if ( pWork->IsConnect )
	{
		char TempBuff[64] = "";
		::shutdown( pWork->Socket, SD_SEND );
		while ( ::recv( pWork->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
		::shutdown( pWork->Socket, SD_BOTH );
		::closesocket( pWork->Socket );

		pWork->IsConnect = false;
	}
}

//=============================================================================
/*
	ŌɔG[𕶎̏ԂŎ擾܂

	@param pError	: G[i[obt@

	@retval true	G[ꍇ
	@retval false	G[Ȃꍇ
*/
//=============================================================================
bool LunaSocketServerAsync::GetLastError( char *pError )
{
	if ( pWork->LastError[0] != '\0' )
	{
		strcpy( pError, pWork->LastError );
		return true;
	}

	return false;
}

//=============================================================================
/**
	WinSock̏܂

	@retval true	
	@retval false	s
*/
//=============================================================================
bool LunaSocketServerAsync::Start( void )
{
	unsigned long Result;

	//------------------------------------------------------------
	// \Pbg
	//------------------------------------------------------------
	pWork->Socket = ::socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );
	if ( pWork->Socket == INVALID_SOCKET )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		return false;
	}

	//------------------------------------------------------------
	// 񓯊[h
	//------------------------------------------------------------
	pWork->hWindow	= Luna::GetWindowHandle();
	pWork->Message	= WM_SOCKET;
	Result = ::WSAAsyncSelect( pWork->Socket, pWork->hWindow, pWork->Message, FD_ACCEPT | FD_CLOSE | FD_READ | FD_WRITE );
	if ( Result == SOCKET_ERROR )
	{
		::closesocket( pWork->Socket );
		pWork->Socket = INVALID_SOCKET;

		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		return false;
	}

	pWork->IsInitialize = true;

	return true;
}

//=============================================================================
/**
	w薼̃zXg擾܂

	@param pServerString	[in] zXgʖ̊i[AhXizXgłhołj
	@param pHost			[out] zXgi[AhX

	@retval true	
	@retval false	s
*/
//=============================================================================
bool LunaSocketServerAsync::GetHostInfo( const char *pServerString, HOSTINFO *pHost )
{
	long i;
	IN_ADDR InAddrHost;
	HOSTENT *pHostEntry;

	//------------------------------------------------------------
	// w肳ꂽ񂪃zXghoAhXׂ
	//------------------------------------------------------------
	InAddrHost.s_addr = ::inet_addr( pServerString );
	if ( InAddrHost.s_addr == INADDR_NONE )
	{
		// hoł͂Ȃ̂ŃzXgƂď
		pHostEntry = ::gethostbyname( pServerString );
		if ( pHostEntry == NULL )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}
	}
	else
	{
		// hoAhX̂悤ł
		pHostEntry = ::gethostbyaddr( (const char *)&InAddrHost, sizeof(IN_ADDR), AF_INET );
		if ( pHostEntry == NULL )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}
	}

	//------------------------------------------------------------
	// zXg̕ۑ
	//------------------------------------------------------------
	MemoryClear( &pWork->HostInfo, sizeof(pWork->HostInfo) );

	// zXg
	strcpy( pWork->HostInfo.Name, pHostEntry->h_name );

	// zXg̕ʖ
	for ( i = 0; pHostEntry->h_aliases[i] != NULL; i++ )
	{
		strcpy( pWork->HostInfo.Alias[pWork->HostInfo.AliasCount++], pHostEntry->h_aliases[i] );
	}

	// AhX
	for ( i = 0; pHostEntry->h_addr_list[i] != NULL; i++ )
	{
		const char *p = ::inet_ntoa( *((IN_ADDR*)pHostEntry->h_addr_list[i]));
		strcpy( pWork->HostInfo.Address[pWork->HostInfo.AddressCount++], p );
	}

	// f[^TCY
	pWork->HostInfo.Length = pHostEntry->h_length;
	// f[^^Cv
	pWork->HostInfo.Type = pHostEntry->h_addrtype;

	//------------------------------------------------------------
	// zXgf[^Rs[
	//------------------------------------------------------------
	if ( pHost != NULL )
	{
		MemoryCopy( pHost, &pWork->HostInfo, sizeof(HOSTINFO) );
	}

	MemoryCopy( &pWork->HostEntry, pHostEntry, sizeof(HOSTENT) );

	return true;
}

//======================================================================================
/**
	[JzXg擾܂

	@param pName	[out] zXgi[|C^
*/
//======================================================================================
void LunaSocketServerAsync::GetLocalHostName( char *pName )
{
	char Buff[256] = "";
	// zXg擾
	::gethostname( Buff, sizeof(Buff) );
	strcpy( pName, Buff );
}

//======================================================================================
/**
	[JzXgT[o[ƂċN܂

	@param PortNo	[in] |[gԍ

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerAsync::CreateServer( unsigned short PortNo )
{
	long ReturnCode;
	SOCKADDR_IN SockAddr;

	//------------------------------------------------------------
	// ڑpf[^
	//------------------------------------------------------------
	MemoryClear( &SockAddr, sizeof(SOCKADDR_IN) );
	SockAddr.sin_family	= AF_INET;
	SockAddr.sin_port	= ::htons( PortNo );

	//------------------------------------------------------------
	// \PbgɃAhXƃ|[g֘At
	//------------------------------------------------------------
	ReturnCode = ::bind( pWork->Socket, (SOCKADDR*)&SockAddr, sizeof(SOCKADDR_IN) );
	if ( ReturnCode == SOCKET_ERROR )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		return false;
	}

	//------------------------------------------------------------
	// ڑ
	//------------------------------------------------------------
	ReturnCode = ::listen( pWork->Socket, 64 );
	if ( ReturnCode == SOCKET_ERROR )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		return false;
	}

	pWork->IsConnect = true;

	return true;
}

//======================================================================================
/**
	ڑ̃R[obN֐ݒ肵܂

	@param pCallBack		[in] ֐AhX
*/
//======================================================================================
void LunaSocketServerAsync::SetAsynCallBackAccept( PCALLBACKSOCKETPROC pCallBack )
{
	pWork->pCallBackAccept = pCallBack;
}


//======================================================================================
/**
	ڑĨR[obN֐ݒ肵܂

	@param pCallBack		[in] ֐AhX
*/
//======================================================================================
void LunaSocketServerAsync::SetAsynCallBackClose( PCALLBACKSOCKETPROC pCallBack )
{
	pWork->pCallBackClose = pCallBack;
}

//======================================================================================
/**
	M\̃R[obN֐ݒ肵܂

	@param pCallBack		[in] ֐AhX
*/
//======================================================================================
void LunaSocketServerAsync::SetAsynCallBackRead( PCALLBACKSOCKETPROC pCallBack )
{
	pWork->pCallBackRead = pCallBack;
}

//======================================================================================
/**
	M\̃R[obN֐ݒ肵܂

	@param pCallBack		[in] ֐AhX
*/
//======================================================================================
void LunaSocketServerAsync::SetAsynCallBackWrite( PCALLBACKSOCKETPROC pCallBack )
{
	pWork->pCallBackWrite = pCallBack;
}

//======================================================================================
/**
	EBhEbZ[W܂

	@param hWnd		[in] EBhEnh
	@param wParam	[in] p[^P
	@param lParam	[in] p[^Q
*/
//======================================================================================
void LunaSocketServerAsync::ReceiveMessage( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
	long EventCode = WSAGETSELECTEVENT( lParam );
	long ErrorCode = WSAGETSELECTERROR( lParam );

	SOCKET Socket = (SOCKET)wParam;
	CONNECTCLIENTDATA *p = (CONNECTCLIENTDATA*)List_Search( Socket );

	GetMakeError( ErrorCode, pWork->LastError );

	switch ( EventCode )
	{
	//------------------------------------------------------------
	// ڑ
	//------------------------------------------------------------
	case FD_ACCEPT:
		// NCAg̐ڑ҂
		if ( !ASyncAccept() )
		{
			GetMakeError( ErrorCode, pWork->LastError );
		}
		// R[obN
		else
		if ( pWork->pCallBackAccept != NULL )
		{
			pWork->pCallBackAccept( hWnd, (long)pWork->ConnectClient.Socket );
		}
		break;

	//------------------------------------------------------------
	// ڑI
	//------------------------------------------------------------
	case FD_CLOSE:
		if ( p != NULL )
		{
			// \Pbg̃NCAg擾
			MemoryCopy( &pWork->CloseClient, p, sizeof(CONNECTCLIENTDATA) );
			pWork->CloseClient.pNext = NULL;
			// NCAgؒf
			char TempBuff[64] = "";
			::shutdown( p->Socket, SD_SEND );
			while ( ::recv( p->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
			::shutdown( p->Socket, SD_BOTH );
			::closesocket( p->Socket );
			// wNCAgXg폜
			List_Erase( p );

			// R[obN
			if ( pWork->pCallBackClose != NULL )
			{
				pWork->pCallBackClose( hWnd, (long)wParam );
			}
		}
		break;

	//------------------------------------------------------------
	// ǂݍ݉\
	//------------------------------------------------------------
	case FD_READ:
		if ( p != NULL )
		{
			p->IsReadEnable = true;

			// R[obN
			if ( pWork->pCallBackRead != NULL )
			{
				pWork->pCallBackRead( hWnd, (long)wParam );
			}
		}
		break;

	//------------------------------------------------------------
	// ݉\
	//------------------------------------------------------------
	case FD_WRITE:
		if ( p != NULL )
		{
			p->IsWriteEnable = true;

			// Mobt@cĂ鎞͑Ms
			if ( p->SendData.pData != NULL )
			{
				long Send = ASyncSend( p->SendData.pData + p->SendData.Send, p->SendData.Size - p->SendData.Send, (long)wParam );
				if ( Send < 0 )
				{
				}
			}
			// Mobt@Ȃ΁AR[obN֐Ăяo
			else
			{
				// R[obN
				if ( pWork->pCallBackWrite != NULL )
				{
					pWork->pCallBackWrite( hWnd, (long)wParam );
				}
			}
		}
		break;
	}
}

//======================================================================================
/**
	NCAgڑ҂܂

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerAsync::ASyncAccept( void )
{
	long Result;
	SOCKET RemoteSocket;
	SOCKADDR_IN SocketAddr;
	int Size = sizeof(SOCKADDR_IN);

	//------------------------------------------------------------
	// NCAgM҂
	//------------------------------------------------------------
	RemoteSocket = ::accept( pWork->Socket, (SOCKADDR*)&SocketAddr, &Size );
	if ( RemoteSocket == SOCKET_ERROR )
	{
		if ( ::WSAGetLastError() != WSAEWOULDBLOCK )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}
	}

	//------------------------------------------------------------
	// V\Pbg񓯊ʒm󂯎悤ɂ
	//------------------------------------------------------------
	unsigned long Flag = FD_READ | FD_WRITE | FD_CLOSE;
	Result = ::WSAAsyncSelect( RemoteSocket, pWork->hWindow, pWork->Message, Flag );
	if ( Result == SOCKET_ERROR )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		return false;
	}

	//------------------------------------------------------------
	// VKNCAgf[^
	//------------------------------------------------------------
	MemoryClear( &pWork->ConnectClient, sizeof(pWork->ConnectClient) );
	pWork->ConnectClient.Socket		= RemoteSocket;
	pWork->ConnectClient.SockAddr	= SocketAddr;
	pWork->ConnectClient.Length		= Size;
	// ho擾
	const char *pAddress = ::inet_ntoa( pWork->ConnectClient.SockAddr.sin_addr );
	// zXg擾
	GetHostInfo( pAddress, &pWork->ConnectClient.HostInfo );
	// ho擾
	strcpy( pWork->ConnectClient.IPAddress, pAddress );

	// Xgɒǉ
	List_Insert( &pWork->ConnectClient );

	return true;
}

//======================================================================================
/**
	w肵f[^񓯊[hpŐڑ֎M

	@param pData	[out] f[^AhX
	@param Size		[in] f[^TCY
	@param Id		[in] NCAg\Pbghc

	@retval -2		ڑ͕ꂽ
	@retval -1		MɎs
	@retval 0ȏ	MoCg
*/
//======================================================================================
long LunaSocketServerAsync::ASyncSend( const void *pData, unsigned long Size, long Id )
{
	const char *pBuffer = (const char *)pData;
	unsigned long Rest = Size;

	SOCKET Socket = (SOCKET)Id;
	CONNECTCLIENTDATA *p = (CONNECTCLIENTDATA*)List_Search( Socket );
	if ( !p->IsWriteEnable ) return 0;

	//----------------------------------------------------
	// f[^Mp[v
	//----------------------------------------------------
	while ( Rest > 0 )
	{
		//--------------------------------------------
		// c̃oCg𑗐M
		//--------------------------------------------
		unsigned long SendSize = ::send( Socket, pBuffer, Rest, 0 );
		if ( SendSize == SOCKET_ERROR )
		{
			if ( ::WSAGetLastError() != WSAEWOULDBLOCK )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return -1;
			}
			else
			{
				p->IsWriteEnable = false;
				break;
			}
		}
		else
		if ( SendSize == 0 )
		{
			strcpy( pWork->LastError, "͐ؒf܂" );
			return -2;
		}

		// Mi߂
		Rest -= SendSize;
		pBuffer += SendSize;
	}

	// obt@
	MemoryFree( p->SendData.pData );
	MemoryClear( &p->SendData, sizeof(SOCKETSENDDATA) );

	return (Size - Rest);
}

//======================================================================================
/**
	w肵f[^񓯊[hpŐڑ悩M

	@param pData	[out] f[^AhX
	@param Size		[in] f[^TCY
	@param Id		[in] NCAghc

	@retval -2		ڑ͕ꂽ
	@retval -1		MɎs
	@retval 0ȏ	MoCg
*/
//======================================================================================
long LunaSocketServerAsync::ASyncReceive( void *pData, unsigned long Size, long Id )
{
	char *pBuffer = (char *)pData;
	unsigned long Rest = Size;

	SOCKET Socket = (SOCKET)Id;
	CONNECTCLIENTDATA *p = (CONNECTCLIENTDATA*)List_Search( Socket );
	if ( !p->IsReadEnable ) return 0;

	//----------------------------------------------------
	// f[^Mp[v
	//----------------------------------------------------
	while ( Rest > 0 )
	{
		//--------------------------------------------
		// c̃oCgM
		//--------------------------------------------
		unsigned long ReceiveSize = ::recv( Socket, pBuffer, Rest, 0 );
		if ( ReceiveSize == SOCKET_ERROR )
		{
			if ( ::WSAGetLastError() != WSAEWOULDBLOCK )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return -1;
			}
			else
			{
				p->IsReadEnable = false;
				break;
			}
		}
		else
		if ( ReceiveSize == 0 )
		{
			strcpy( pWork->LastError, "͐ؒf܂" );
			return -2;
		}

		// Mi߂
		Rest -= ReceiveSize;
		pBuffer += ReceiveSize;
	}

	return (Size - Rest);
}

//======================================================================================
/**
	w肵NCAgɑMf[^ݒ肵܂

	@param pSend	[in] f[^AhX
	@param Id		[in] NCAghc

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerAsync::SetSendData( SOCKETSENDDATA *pSend, long Id )
{
	SOCKET Socket = (SOCKET)Id;
	CONNECTCLIENTDATA *p = (CONNECTCLIENTDATA*)List_Search( Socket );

	if ( p->SendData.pData != NULL ) return false;
	if ( Id == -1 ) Id = (long)pWork->Socket;

	// f[^ݒ
	p->SendData.Send = 0;
	p->SendData.Size = pSend->Size;
	p->SendData.pData = (unsigned char *)MemoryClearAlloc( p->SendData.Size );
	MemoryCopy( p->SendData.pData, pSend->pData, p->SendData.Size );

	// ɑMn߂
	p->SendData.Send += ASyncSend( p->SendData.pData, p->SendData.Size - p->SendData.Send, Id );

	return true;
}

//======================================================================================
/**
	VKڑꂽNCAg̃zXg擾܂

	@param pHostInfo	[out] zXgi[AhX
	@param pAddr		[out] AhXi[obt@
*/
//======================================================================================
void LunaSocketServerAsync::GetConnectClientInfo( HOSTINFO *pHostInfo, char *pAddr )
{
	strcpy( pAddr, pWork->ConnectClient.IPAddress );
	MemoryCopy( pHostInfo, &pWork->ConnectClient.HostInfo, sizeof(HOSTINFO) );
}

//======================================================================================
/**
	ŌɐؒfꂽNCAg̃zXg擾܂

	@param pHostInfo	[out] zXgi[AhX
	@param pAddr		[out] AhXi[obt@
*/
//======================================================================================
void LunaSocketServerAsync::GetCloseClientInfo( HOSTINFO *pHostInfo, char *pAddr )
{
	strcpy( pAddr, pWork->CloseClient.IPAddress );
	MemoryCopy( pHostInfo, &pWork->CloseClient.HostInfo, sizeof(HOSTINFO) );
}

//======================================================================================
/**
	ݐڑ̃NCAg̐擾܂

	@return		NCAg
*/
//======================================================================================
long LunaSocketServerAsync::GetClientCount( void )
{
	return pWork->ClientCount;
}

//======================================================================================
/**
	w肵ԍ̃NCAg̃zXg擾܂

	@param No		[in] Xg̃CfbNXԍ
	@param pName	[out] Oi[obt@
	@param pAddress	[out] hoi[obt@
*/
//======================================================================================
void LunaSocketServerAsync::GetClientInfo( long No, char *pName, char *pAddress )
{
	CONNECTCLIENTDATA *pClient = (CONNECTCLIENTDATA*)List_Search( No );

	if ( pClient->HostInfo.Name[0] == '\0' )
	{
		strcpy( pName, "Unknown" );
	}
	else
	{
		strcpy( pName, pClient->HostInfo.Name );
	}

	if ( pClient->HostInfo.Address[0][0] == '\0' )
	{
		strcpy( pAddress, pClient->IPAddress );
	}
	else
	{
		strcpy( pAddress, pClient->HostInfo.Address[0] );
	}
}

//======================================================================================
/**
	G[R[hG[擾܂

	@param ErrorCode	[in] G[R[h
	@param pErrStr		[out] G[bZ[Wi[
*/
//======================================================================================
void LunaSocketServerAsync::GetMakeError( long ErrorCode, char *pErrStr )
{
	MemoryClear( pWork->LastError, sizeof(pWork->LastError) );
	LunaSystem::GetSocketError( ErrorCode, pErrStr );
}


//======================================================================================
/**
	VڑNCAgڑXgɒǉ܂

	@param pConnect		[in] NCAg
*/
//======================================================================================
void LunaSocketServerAsync::List_Insert( void *pConnect )
{
	//------------------------------------------------------------
	// VKf[^
	//------------------------------------------------------------
	CONNECTCLIENTDATA *pNew = (CONNECTCLIENTDATA*)MemoryClearAlloc( sizeof(CONNECTCLIENTDATA) );
	MemoryCopy( pNew, pConnect, sizeof(CONNECTCLIENTDATA) );
	MemoryClear( &pNew->SendData, sizeof(SOCKETSENDDATA) );
	pNew->pNext = NULL;

	//------------------------------------------------------------
	// Xgɒǉ
	//------------------------------------------------------------
	CONNECTCLIENTDATA *p = pWork->pConnectionList;
	// ŏ̂Pl
	if ( p == NULL )
	{
		// ̂܂ܐݒ
		pWork->pConnectionList = pNew;
	}
	else
	{
		// I[
		while ( p != NULL )
		{
			// ̎͒NȂH
			if ( p->pNext == NULL )
			{
				// ڑ
				p->pNext = pNew;
				break;
			}

			p = p->pNext;
		}
	}

	pWork->ClientCount++;
}

//======================================================================================
/**
	w肵ڑXg폜܂

	@param pConnect		[in] NCAg
*/
//======================================================================================
void LunaSocketServerAsync::List_Erase( void *pConnect )
{
	CONNECTCLIENTDATA *p = pWork->pConnectionList;
	// ŏ̂Pl
	if ( p == pConnect )
	{
		// ڑ
		pWork->pConnectionList = ((CONNECTCLIENTDATA*)pConnect)->pNext;
	}
	else
	{
		// I[
		while ( p != NULL )
		{
			// ͎łH
			if ( p->pNext == pConnect )
			{
				// ڑ
				p->pNext = ((CONNECTCLIENTDATA*)pConnect)->pNext;
				break;
			}

			p = p->pNext;
		}
	}

	pWork->ClientCount--;

	if ( ((CONNECTCLIENTDATA*)pConnect)->SendData.pData != NULL )
	{
		MemoryFree( ((CONNECTCLIENTDATA*)pConnect)->SendData.pData );
	}

	MemoryFree( pConnect );
}

//======================================================================================
/**
	w肵\Pbgڑ܂

	@param Socket	[in] Ώۃ\Pbg

	@return		NCAg
*/
//======================================================================================
void *LunaSocketServerAsync::List_Search( SOCKET Socket )
{
	CONNECTCLIENTDATA *p = pWork->pConnectionList;
	// 
	while ( p != NULL )
	{
		// łˁH
		if ( p->Socket == Socket )
		{
			return p;
		}

		p = p->pNext;
	}

	return NULL;
}

//======================================================================================
/**
	w肵ԍ̐ڑ܂

	@param No	[in] ԍ

	@return		NCAg
*/
//======================================================================================
void *LunaSocketServerAsync::List_Search( long No )
{
	CONNECTCLIENTDATA *p = pWork->pConnectionList;
	// 
	while ( p != NULL )
	{
		// łˁH
		if ( No-- == 0 )
		{
			return p;
		}

		p = p->pNext;
	}

	return NULL;
}


