
/** @file
    @brief		}`Xbh^\PbgT[o[NX
    @author		Noriyuki Lee
    @since		2003.07.01
*/


//==========================================================================
// INCLUDE

//==========================================================================
#include "Luna.h"
#include "LunaSystem.h"
#include "LunaSystem.h"
#include "LunaSocketServerMT.h"
#include "LunaMemory.h"

#include "LunaWork.h"


//==========================================================================
// VARIABLE
//==========================================================================
static WORK_LUNASOCKETSERVERMT *pWork;


//======================================================================================
/**
	NX̏܂B

	@param pWorkData	[in] [NGÃAhX

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerMT::Initialize( void *pWorkData )
{
	Luna::LogoutMainCategory( "LunaSocketServerMTNX̏" );
	Luna::LogoutNextLine();

	//----------------------------------------------------------
	// [NGA̎擾
	//----------------------------------------------------------
	pWork = (WORK_LUNASOCKETSERVERMT*)pWorkData;

	//----------------------------------------------------------
	// [NGȀ
	//----------------------------------------------------------
	MemoryClear( pWork, sizeof(WORK_LUNASOCKETSERVERMT) );
	pWork->Socket = INVALID_SOCKET;

	//----------------------------------------------------------
	// NeBJZNV
	//----------------------------------------------------------
	::InitializeCriticalSection( &pWork->LogCriticalSection );

	return true;
}

//======================================================================================
/**
	NX̉܂
*/
//======================================================================================
void LunaSocketServerMT::Uninitialize( void )
{
	Luna::LogoutMainCategory( "LunaSocketServerMTNX̉" );
	Luna::LogoutNextLine();

	//----------------------------------------------------------
	// NeBJZNV
	//----------------------------------------------------------
	::DeleteCriticalSection( &pWork->LogCriticalSection );

	Shutdown();
}

//======================================================================================
/**
	ڑ̃lbg[Nؒf܂
*/
//======================================================================================
void LunaSocketServerMT::Shutdown( void )
{
	//-------------------------------------------------------
	// \Pbgؒf
	//-------------------------------------------------------
	if ( pWork->IsConnect )
	{
		char TempBuff[64] = "";
		::shutdown( pWork->Socket, SD_SEND );
		while ( ::recv( pWork->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
		::shutdown( pWork->Socket, SD_BOTH );
		::closesocket( pWork->Socket );
		pWork->Socket = INVALID_SOCKET;

		pWork->IsConnect = false;
	}

	//-------------------------------------------------------
	// bXpXbh̏I҂
	//-------------------------------------------------------
	if ( pWork->hListenThread != NULL )
	{
		::WaitForSingleObject( pWork->hListenThread, INFINITE );
		::CloseHandle( pWork->hListenThread );
		pWork->hListenThread = NULL;
	}
}

//======================================================================================
/**
	ŌɔG[𕶎̏ԂŎ擾܂

	@param pError	[out] G[i[obt@

	@retval true	G[ꍇ
	@retval false	G[Ȃꍇ
*/
//======================================================================================
bool LunaSocketServerMT::GetLastError( char *pError )
{
	if ( pWork->LastError[0] != '\0' )
	{
		strcpy( pError, pWork->LastError );
		return true;
	}

	return false;
}

//======================================================================================
/**
	WinSock̏܂

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerMT::Start( void )
{
	bool Result = false;

	Logout( "\Pbg̊Jn" );

	//------------------------------------------------
	// Opobt@NA
	//------------------------------------------------
	::EnterCriticalSection( &pWork->LogCriticalSection );
	MemoryClear( pWork->SocketLog, sizeof(pWork->SocketLog) ); 
	pWork->SocketLogLine = 0;
	::LeaveCriticalSection( &pWork->LogCriticalSection );

	//------------------------------------------------
	// \Pbg̐
	//------------------------------------------------
	pWork->Socket = ::socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );
	if ( pWork->Socket == INVALID_SOCKET )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		Logout( pWork->LastError );
		goto EXIT;
	}

	pWork->IsInitialize = true;
	Result = true;

EXIT:
	return Result;
}

//======================================================================================
/**
	w薼̃zXg擾܂

	@param pServerString	[out] zXgʖ̊i[AhXizXgłhołj
	@param pHost			[out] zXgi[AhX

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerMT::GetHostInfo( const char *pServerString, HOSTINFO *pHost )
{
	long i;
	IN_ADDR InAddrHost;
	HOSTENT *pHostEntry;

	//------------------------------------------------------------
	// w肳ꂽ񂪃zXghoAhXׂ
	//------------------------------------------------------------
	InAddrHost.s_addr = ::inet_addr( pServerString );
	if ( InAddrHost.s_addr == INADDR_NONE )
	{
		// hoł͂Ȃ̂ŃzXgƂď
		pHostEntry = ::gethostbyname( pServerString );
		if ( pHostEntry == NULL )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}
	}
	else
	{
		// hoAhX̂悤ł
		pHostEntry = ::gethostbyaddr( (const char *)&InAddrHost, sizeof(IN_ADDR), AF_INET );
		if ( pHostEntry == NULL )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}
	}

	//------------------------------------------------------------
	// zXg̕ۑ
	//------------------------------------------------------------
	MemoryClear( &pWork->HostInfo, sizeof(pWork->HostInfo) );

	// zXg
	strcpy( pWork->HostInfo.Name, pHostEntry->h_name );

	// zXg̕ʖ
	for ( i = 0; pHostEntry->h_aliases[i] != NULL; i++ )
	{
		strcpy( pWork->HostInfo.Alias[pWork->HostInfo.AliasCount++], pHostEntry->h_aliases[i] );
	}

	// AhX
	for ( i = 0; pHostEntry->h_addr_list[i] != NULL; i++ )
	{
		const char *p = ::inet_ntoa( *((IN_ADDR*)pHostEntry->h_addr_list[i]));
		strcpy( pWork->HostInfo.Address[pWork->HostInfo.AddressCount++], p );
	}

	// f[^TCY
	pWork->HostInfo.Length = pHostEntry->h_length;
	// f[^^Cv
	pWork->HostInfo.Type = pHostEntry->h_addrtype;

	//------------------------------------------------------------
	// zXgf[^Rs[
	//------------------------------------------------------------
	if ( pHost != NULL )
	{
		MemoryCopy( pHost, &pWork->HostInfo, sizeof(HOSTINFO) );
	}

	MemoryCopy( &pWork->HostEntry, pHostEntry, sizeof(HOSTENT) );

	return true;
}

//======================================================================================
/**
	[JzXg擾܂

	@param pName	[out] zXgi[|C^
*/
//======================================================================================
void LunaSocketServerMT::GetLocalHostName( char *pName )
{
	char Buff[256] = "";
	// zXg擾
	::gethostname( Buff, sizeof(Buff) );
	strcpy( pName, Buff );
}


//======================================================================================
/**
	T[o[쐬

	@param PortNo	[in] |[gԍ

	@retval true	
	@retval false	s
*/
//======================================================================================
bool LunaSocketServerMT::CreateServer( unsigned short PortNo )
{
	if ( !pWork->IsInitialize ) return false;

	if ( pWork->pCallbackProc == NULL )
	{
		Logout( "pR[obN֐ݒ肳Ă܂" );
		return false;
	}

	long ReturnCode;
	SOCKADDR_IN SockAddr;

	//------------------------------------------------------------
	// ڑpf[^
	//------------------------------------------------------------
	MemoryClear( &SockAddr, sizeof(SOCKADDR_IN) );
	SockAddr.sin_family	= AF_INET;
	SockAddr.sin_port	= ::htons( PortNo );

	//------------------------------------------------------------
	// \PbgɃAhXƃ|[g֘At
	//------------------------------------------------------------
	ReturnCode = ::bind( pWork->Socket, (SOCKADDR*)&SockAddr, sizeof(SOCKADDR_IN) );
	if ( ReturnCode == SOCKET_ERROR )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		Logout( pWork->LastError );
		return false;
	}

	//------------------------------------------------------------
	// ڑ
	//------------------------------------------------------------
	ReturnCode = ::listen( pWork->Socket, 64 );
	if ( ReturnCode == SOCKET_ERROR )
	{
		GetMakeError( ::WSAGetLastError(), pWork->LastError );
		Logout( pWork->LastError );
		return false;
	}

	pWork->IsConnect = true;

	//------------------------------------------------------------
	// ڑ҂󂯃XbhJn
	//------------------------------------------------------------
	pWork->hListenThread = ::CreateThread( NULL, 0, ListenThreadProc, NULL, 0, &pWork->ListenThreadId );

	return (pWork->hListenThread != NULL);
}

//======================================================================================
/**
	NCAgւ̃f[^M

	@param pData	[in] Mf[^
	@param Size		[in] Mf[^TCY
	@param Id		[in] NCAghc

	@retval -2		ڑ͕ꂽ
	@retval -1		MɎs
	@retval 0ȏ	MoCg
*/
//======================================================================================
long LunaSocketServerMT::Send( const void *pData, unsigned long Size, long Id )
{
	const char *pBuffer = (const char *)pData;
	long Rest = (long)Size;

	if ( Id == -1 ) Id = (long)pWork->Socket;

	//----------------------------------------------------
	// f[^Mp[v
	//----------------------------------------------------
	while ( Rest > 0 )
	{
		//--------------------------------------------
		// c̃oCg𑗐M
		//--------------------------------------------
		long SendSize = ::send( Id, pBuffer, Rest, 0 );
		if ( SendSize == SOCKET_ERROR )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return -1;
		}
		else
		if ( SendSize == 0 )
		{
			strcpy( pWork->LastError, "͐ؒf܂" );
			return -2;
		}

		// Mi߂
		Rest -= SendSize;
		pBuffer += SendSize;
	}

	return (Size - Rest);
}

//======================================================================================
/**
	NCAgf[^M

	@param pData	[out] Mobt@
	@param Size		[in] Mobt@TCY
	@param Id		[in] NCAghc

	@retval -2		ڑ͕ꂽ
	@retval -1		MɎs
	@retval 0ȏ	MoCg
*/
//======================================================================================
long LunaSocketServerMT::Receive( void *pData, unsigned long Size, long Id )
{
	char *pBuffer = (char *)pData;
	long Rest = (long)Size;

	if ( Id == -1 ) Id = (long)pWork->Socket;

	//----------------------------------------------------
	// f[^Mp[v
	//----------------------------------------------------
	while ( Rest > 0 )
	{
		//--------------------------------------------
		// c̃oCgM
		//--------------------------------------------
		long ReceiveSize = ::recv( Id, pBuffer, Rest, 0 );
		if ( ReceiveSize == SOCKET_ERROR )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return -1;
		}
		else
		if ( ReceiveSize == 0 )
		{
			strcpy( pWork->LastError, "͐ؒf܂" );
			return -2;
		}

		// Mi߂
		Rest -= ReceiveSize;
		pBuffer += ReceiveSize;
	}

	return (Size - Rest);
}

//======================================================================================
/**
	R[obN֐ݒ

	@param pProc	[in] R[obN֐AhX
*/
//======================================================================================
void LunaSocketServerMT::SetCallBackProc( void (*pProc)( long Id ) )
{
	pWork->pCallbackProc = pProc;
}

//======================================================================================
/**
	ڑNCAg擾

	@return		 NCAg
*/
//======================================================================================
long LunaSocketServerMT::GetClientCount( void )
{
	return pWork->ClientCount;
}

//======================================================================================
/**
	NCAg擾

	@param No			[in] NCAgԍ
	@param pName		[out] ̊i[
	@param pAddress		[out] hoi[
*/
//======================================================================================
void LunaSocketServerMT::GetClientInfo( long No, char *pName, char *pAddress )
{
	::EnterCriticalSection( &pWork->ClientCriticalSection );

	SOCKETMTCLIENTDATA *p = pWork->pList;
	while ( (p != NULL) && (No-- != 0) ) p = p->pNext;

	if ( p != NULL )
	{
		// ho擾
		strcpy( pAddress, ::inet_ntoa( p->SocketAddr.sin_addr ) );
		// zXg擾
		GetHostInfo( pAddress, &p->HostInfo );
	}

	::LeaveCriticalSection( &pWork->ClientCriticalSection );
}

//======================================================================================
/**
	NCAgXg

	@return		NCAgCxgnh
*/
//======================================================================================
void LunaSocketServerMT::InitClientData( void )
{
	::InitializeCriticalSection( &pWork->ClientCriticalSection );

	pWork->pList = NULL;
	pWork->ClientCount = 0;
}

//======================================================================================
/**
	NCAgXg
*/
//======================================================================================
void LunaSocketServerMT::UninitClientData( void )
{
	::DeleteCriticalSection( &pWork->ClientCriticalSection );
}


//======================================================================================
/**
	ڑNCAgؒf

*/
//======================================================================================
void LunaSocketServerMT::ShutdownClient( void )
{
	::EnterCriticalSection( &pWork->ClientCriticalSection );

	SOCKETMTCLIENTDATA *pClient = pWork->pList;
	while ( pClient != NULL )
	{
		char TempBuff[64] = "";
		::shutdown( pClient->Socket, SD_SEND );
		while ( ::recv( pClient->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
		::shutdown( pClient->Socket, SD_BOTH );
		::closesocket( pClient->Socket );
		pClient->Socket = INVALID_SOCKET;

		pClient = pClient->pNext;
	}

	// Z
	pWork->ClientCount = 0;

	::LeaveCriticalSection( &pWork->ClientCriticalSection );
}


//======================================================================================
/**
	ڑNCAg{P

	@param pData	[in] NCAgf[^
*/
//======================================================================================
void LunaSocketServerMT::IncrementClient( void *pData )
{
	SOCKETMTCLIENTDATA *pClient = (SOCKETMTCLIENTDATA*)pData;

	::EnterCriticalSection( &pWork->ClientCriticalSection );

	// Xgɐڑ
	if ( pWork->pList != NULL )
	{
		SOCKETMTCLIENTDATA *p = pWork->pList;
		while ( p->pNext != NULL ) p = p->pNext;
		p->pNext = pClient;
	}
	else
	{
		pWork->pList = pClient;
	}

	// Z
	pWork->ClientCount++;

	::LeaveCriticalSection( &pWork->ClientCriticalSection );
}

//======================================================================================
/**
	ڑNCAg|P

	@param pData	[in] NCAgf[^
*/
//======================================================================================
void LunaSocketServerMT::DecrementClient( void *pData )
{
	SOCKETMTCLIENTDATA *pClient = (SOCKETMTCLIENTDATA*)pData;

	::EnterCriticalSection( &pWork->ClientCriticalSection );

	// Xg폜
	if ( pWork->pList != NULL )
	{
		if ( pWork->pList == pClient )
		{
			pWork->pList = pWork->pList->pNext;
		}
		else
		{
			SOCKETMTCLIENTDATA *p = pWork->pList;
			while ( p->pNext != pClient ) p = p->pNext;
			p->pNext = p->pNext->pNext;
		}
	}

	// Z
	if ( pWork->ClientCount > 0 ) pWork->ClientCount--;

	::LeaveCriticalSection( &pWork->ClientCriticalSection );
}

//======================================================================================
/**
	Oő吔

	@return		Oő吔
*/
//======================================================================================
long LunaSocketServerMT::GetLogMax( void )
{
	long Max = 0;

	::EnterCriticalSection( &pWork->LogCriticalSection );

	Max = pWork->SocketLogLine;

	::LeaveCriticalSection( &pWork->LogCriticalSection );

	return Max;;
}

//======================================================================================
/**
	O擾

	@param Line		[in] w胉C
	@param pBuff	[out] Mobt@
*/
//======================================================================================
void LunaSocketServerMT::GetLog( long Line, char *pBuff )
{
	::EnterCriticalSection( &pWork->LogCriticalSection );

	strcpy( pBuff, pWork->SocketLog[Line] );

	::LeaveCriticalSection( &pWork->LogCriticalSection );
}

//======================================================================================
/**
	OOobt@ɐݒ

	@param pStr		ݒ蕶
*/
//======================================================================================
void LunaSocketServerMT::Logout( const char *pStr,... )
{
	::EnterCriticalSection( &pWork->LogCriticalSection );

	long Day, Hour, Minute, Second;
	char Temp[1024] = "";
	long Len;

	// ݎԂ̎擾
	LunaSystem::GetLocalTime( NULL, NULL, NULL, &Day, &Hour, &Minute, &Second, NULL );

	// ̐
	sprintf( Temp, "%02d.%02d.%02d.%02d:", Day, Hour, Minute, Second );
	Len = (long)strlen( Temp );
	vsprintf( &Temp[Len], pStr, (char*)(&pStr + 1) );

	// Oۑ
	if ( pWork->SocketLogLine == SOCKET_LOG_LINE_MAX )
	{
		// 󂢂ĂȂ̂ŃXChčŌɐݒ
		MemoryMove( &pWork->SocketLog[0], &pWork->SocketLog[1], sizeof(char[SOCKET_LOG_LINE_MAX-1][1024]) );
		strcpy( pWork->SocketLog[SOCKET_LOG_LINE_MAX-1], Temp );
	}
	else
	{
		// 󂢂ĂƂɐݒ
		strcpy( pWork->SocketLog[pWork->SocketLogLine], Temp );
		pWork->SocketLogLine++;
	}

	::LeaveCriticalSection( &pWork->LogCriticalSection );
}

//======================================================================================
/**
	ڑ҂pXbh

	@param pParameter	[in] Xbhf[^nlf[^

	preturn		XbhIR[h
*/
//======================================================================================
unsigned long WINAPI LunaSocketServerMT::ListenThreadProc( void *pParameter )
{
	//------------------------------------------------------------
	// NCAgf[^
	//------------------------------------------------------------
	InitClientData();

	//------------------------------------------------------------
	// NCAg̐ڑ҂
	//------------------------------------------------------------
	Logout( "T[o[Jn" );

	while ( true )
	{
		unsigned long ClientThreadId;
		SOCKETMTCLIENTDATA *pClient;
		SOCKETMTCLIENTDATA ClientData;
		int Size = sizeof(SOCKADDR_IN);

		MemoryClear( &ClientData, sizeof(SOCKETMTCLIENTDATA) );

		// NCAgM҂
		ClientData.Socket = ::accept( pWork->Socket, (SOCKADDR*)&ClientData.SocketAddr, &Size );
		if ( ClientData.Socket == INVALID_SOCKET ) break;

		Logout( "[0x%08x] NCAg̐ڑmF", ClientData.Socket );

		// VKNCAg
		pClient = (SOCKETMTCLIENTDATA*)MemoryClearAlloc( sizeof(SOCKETMTCLIENTDATA) );
		MemoryCopy( pClient, &ClientData, sizeof(SOCKETMTCLIENTDATA) );

		// NCAgpXbhJn
		HANDLE hClientThread = ::CreateThread( NULL, 0, ClientThreadProc, pClient, 0, &ClientThreadId );
		if ( hClientThread == NULL )
		{
			Logout( "[0x%08x] NCAgpXbh̐Ɏs", ClientData.Socket );
		}

		::CloseHandle( hClientThread );
	}

	Logout( "T[o[~" );

	//------------------------------------------------------------
	// SNCAg̐ؒf
	//------------------------------------------------------------
	ShutdownClient();

	//------------------------------------------------------------
	// NCAgf[^
	//------------------------------------------------------------
	UninitClientData();

	return 0;
}

//======================================================================================
/**
	NCAgpXbh

	@param pParameter	[in] Xbhf[^nlf[^

	preturn		XbhIR[h
*/
//======================================================================================
unsigned long WINAPI LunaSocketServerMT::ClientThreadProc( void *pParameter )
{
	SOCKETMTCLIENTDATA *pClient = (SOCKETMTCLIENTDATA*)pParameter;

	SOCKET Socket = pClient->Socket;

	Logout( "[0x%08x] NCAgJn", pClient->Socket );

	//------------------------------------------------------------
	// NCAgZ
	//------------------------------------------------------------
	IncrementClient( pClient );

	//------------------------------------------------------------
	// [v
	//------------------------------------------------------------
	pWork->pCallbackProc( (long)Socket );

	//------------------------------------------------------------
	// NCAgZ
	//------------------------------------------------------------
	DecrementClient( pClient );

	Logout( "[0x%08x] NCAgI", pClient->Socket );

	//------------------------------------------------------------
	// NCAgf[^폜
	//------------------------------------------------------------
	MemoryFree( pParameter );

	return 0;
}

//======================================================================================
/**
	G[R[hG[擾܂

	@param ErrorCode	[in] G[R[h
	@param pErrStr		[out] G[bZ[Wi[
*/
//======================================================================================
void LunaSocketServerMT::GetMakeError( long ErrorCode, char *pErrStr )
{
	MemoryClear( pWork->LastError, sizeof(pWork->LastError) );
	LunaSystem::GetSocketError( ErrorCode, pErrStr );
}

