/**
@file internet.hpp
@brief C^[lbgɐڑ@\
@note
̏Win32Only...
Windows͉łĎ֗Ȃ`
*/

#ifndef DKUTIL_NETWORK_INTERNET_HPP
#define DKUTIL_NETWORK_INTERNET_HPP

#include <helper/windows_header.h>
#include <dkutil/network/tcp.hpp>
#include <dkutil/dll.hpp>
#include <dkutil/detail/stream_interface.hpp>
#include <dkutil/network/download.hpp>

namespace dkutil{
class IInternet : public IStream{
public:
	enum{
		///ǂɌ߂邩͍ŏ̐ݒ莟
		preconfig_type,
		///ڌq
		direct_type,
		///ProxygpČq
		proxy_type,
	};
		
	virtual ~IInternet(){}
	
	
};
#ifdef WIN32
	
	

	
class CWinInet : public IInternet
{
public:
	typedef BOOL (*InternetSetOption_type)(
    IN HINTERNET hInternet,
    IN DWORD dwOption,
    IN LPVOID lpBuffer,
    IN DWORD dwBufferLength
	);
	typedef BOOL (*InternetQueryOption_type)(
    IN HINTERNET hInternet,
    IN DWORD dwOption,
    OUT LPVOID lpBuffer,
    IN OUT LPDWORD lpdwBufferLength
	);


	typedef DWORD (*InternetAttemptConnect_type)(
    IN DWORD dwReserved
	);
	typedef BOOL (*InternetCloseHandle_type)(
    IN HINTERNET hInet
	);
	typedef HINTERNET (*InternetOpen_type)(
    IN LPCSTR lpszAgent,
    IN DWORD dwAccessType,
    IN LPCSTR lpszProxyName,
    IN LPCSTR lpszProxyBypass,
    IN DWORD dwFlags
	);
	typedef BOOL (*InternetWriteFile_type)(
    IN HINTERNET hFile,
    IN LPCVOID lpBuffer,
    IN DWORD dwNumberOfBytesToWrite,
    OUT LPDWORD lpdwNumberOfBytesWritten
	);

	typedef BOOL (*InternetReadFile_type)(
    IN HINTERNET hFile,
    IN LPVOID lpBuffer,
    IN DWORD dwNumberOfBytesToRead,
    OUT LPDWORD lpNumberOfBytesRead
	);


	/**
	Internet Explorer̃o[W𓾂B
	@return -1Ŏs 0IE3 ȍ~IẼo[Wオ邽тɖ߂l1Âオ (IE4 == 1 IE5 == 2 ... )
	*/
	static int GetIEVersion(){
		INTERNET_VERSION_INFO info;
	  DWORD dwSize;
		int r = -1;
	  dwSize = sizeof(info);
		
		DLLManager mgr("Wininet.dll");
		
		InternetQueryOption_type pf = 
			(InternetQueryOption_type)mgr.find("InternetQueryOption");

		if(NULL==pf){
			return -1;
		}
		
	  if( pf( 0, INTERNET_OPTION_VERSION, &info, &dwSize ) ){
	    if( info.dwMajorVersion == 1 ){
	    	if(info.dwMinorVersion < 0){
	    		r = -1;
	    	}else{
	    		r = info.dwMinorVersion;
	    	}
	      /*
	    	switch( info.dwMinorVersion ){
	        case 0:
	          Edit1->Text = "Internet Explorer 3";
	          break;
	        case 1:
	          Edit1->Text = "Internet Explorer 4";
	          break;
	        case 2:
	          Edit1->Text = "Internet Explorer 5";
	          break;
	        default:
	         	r = -1;
	          break;
	      }
	    	*/
	    	
	    }
	  }
		return r;
	}




private:
	///WinInetnh
	HINTERNET mH;
	///DLL}l[W[
	DLLManager mDLL;
	
	///G[bZ[W
	std::string mLastError[1024];
	
	//e֐ւ̃|C^
	

	InternetSetOption_type InternetSetOption;
	
	InternetAttemptConnect_type InternetAttemptConnect;

	InternetOpen_type InternetOpen;
	
	InternetCloseHandle_type InternetCloseHandle;

	InternetQueryOption_type InternetQueryOption;

	InternetReadFile_type InternetReadFile;

	InternetWriteFile_type InternetWriteFile;

public:


	CWinInet(const char *dllname="Wininet.dll"){
		mH = NULL;
		if(false==mDLL.reset(dllname)){
			return;
		}
#	define CWININET_LOAD_FUNC(name) \
	name = (name##_type)mDLL.find("##name##")
		
		CWININET_LOAD_FUNC(InternetSetOption);
		CWININET_LOAD_FUNC(InternetAttemptConnect);
		/*
		
		InternetSetOption = 
			(InternetSetOption_type)mDLL.find("InternetSetOption");
		
		InternetAttemptConnect = 
			(InternetAttemptConnect_type)mDLL.find("InternetAttemptConnect");
		
		InternetOpen =
			(InternetOpen_type)mDLL.find("InternetOpen");
		
		InternetCloseHandle = 
			(InternetCloseHandle_type)mDLL.find("InternetCloseHandle");
		
		InternetReadFile = 
			(InternetReadFile_type)mDLL.find("InternetReadFile");

		InternetWriteFile =
			(InternetWriteFile_type)mDLL.find("InternetWriteFile");
		*/

	}
	virtual ~CWinInet(){
		close();
	}
	///@return gԂȂtrue
	virtual bool good()const{
		return mDLL.empty()==false;
	}
	virtual bool read(void *buff,size_t size,size_t *readsize)
	{
		DWORD rs;
		BOOL r = InternetReadFile(mH,buff,size,&rs);
		*readsize = rs;
		return TRUE==r;
	}
	virtual bool write(const void *buff,size_t size,size_t *write_size)
	{
		DWORD ws;
		BOOL r = InternetWriteFile(mH,buff,size,&ws);
		*write_size = ws;
		return TRUE==r;
	}
		
	///C^[lbgɐڑmi펞ڑłȂꍇj
	bool attemptConnect()
	{//ERROR_SUCCESSƐ
		return ERROR_SUCCESS==InternetAttemptConnect(0);
	}
	///^CAEgݒ肷
	bool setTimeOut(size_t TimeOut = 5000)
	{
		return TRUE==InternetSetOption( mH, INTERNET_OPTION_RECEIVE_TIMEOUT, &TimeOut, sizeof(TimeOut) );
	}
	///C^[lbgɌq
	bool open(const char *userAgent,int option)
	{
		DWORD Opt;
		switch(option){
		case preconfig_type:
			Opt = INTERNET_OPEN_TYPE_PRECONFIG;
			break;
		case direct_type:
			Opt = INTERNET_OPEN_TYPE_DIRECT;
			break;
		case proxy_type:
			Opt = INTERNET_OPEN_TYPE_PROXY;
			break;
		default:
			return false;
		}
		mH = InternetOpen(userAgent,Opt,NULL,NULL,0);
		if(NULL==mH)
		{
			mLastError = GetWin32LastErrorString();
			return false;
		}
		return true;
	}
	///C^[lbgւ̐ڑI
	void close(){
		if(mH){
			InternetCloseHandle( mH );
			mH = NULL;
		}
	}
	
	void download(const char *URL,const char *filename){
		URLDownloadToFile(NULL,URL,filename,0,0);
	}
	//void downloadEx(const char *URL
	
	///G[̏Qbg
	const char *errorStr()const{
		return mLastError.c_str();
	}

	
	
};
	
typedef CWinInet CInternet;
	
#else //posix...
	
	
#endif

}//end of dkutil namespace



#endif