
#ifndef DKUTIL_NETWORK_SOCKET_HPP
#define DKUTIL_NETWORK_SOCKET_HPP

#include <gimite/socket.h>
#include <dkutil/detail/stream_interface.hpp>
#include <dkutil/detail/lunalibdef.hpp>
#include <dkutil/boost/parm_string.hpp>
#include <list>
#include <dkutil/filesystem/big_filestream.hpp>

/*
#include "Luna.h"
#include "LunaSocket.h"
#include "LunaSystem.h"
#include "LunaMemory.h"

#include "LunaWork.h"
*/
namespace dkutil{

///@see gimite::startup_socket()
inline bool init_socket(){
	return gimite::startup_socket();
}
///@see gimite::cleanup_socket()
inline void end_socket(){
	gimite::cleanup_socket();
}


/**
	lbg[NoCgI[_[zXgoCgI[_[ɕϊ

	@param pData	[in/out] ϊf[^̊i[
	@param Size		[in] f[^̃oCg
*/

inline void NetToHost( void *pData, long Size )
{
	switch ( Size )
	{
	case 2:
		*((unsigned short *)pData) = ::ntohs( *((unsigned short *)pData) );
		break;
	case 4:
		*((unsigned long *)pData) = ::ntohl( *((unsigned long *)pData) );
		break;
	}
}


/**
	G[R[hG[擾܂

	@param ErrorCode	[in] G[R[h
	@param pErrStr		[out] G[bZ[Wi[
*/

inline void GetSocketError( long ErrorCode, char *pErrStr )
{
	switch ( ErrorCode )
	{
	case WSABASEERR:				strcpy( pErrStr, "G[͔ĂȂ" );								break;
	case WSAEINTR:					strcpy( pErrStr, "֐Ăяofꂽ" );								break;
	case WSAEBADF:					strcpy( pErrStr, "ȃt@Cnh" );								break;
	case WSAEACCES:					strcpy( pErrStr, "ANZXۂꂽ" );									break;
	case WSAEFAULT:					strcpy( pErrStr, "ȃobt@AhX" );								break;
	case WSAEINVAL:					strcpy( pErrStr, "Ȉnꂽ" );									break;
	case WSAEMFILE:					strcpy( pErrStr, "gp̃\Pbg̐" );						break;
	case WSAEWOULDBLOCK:			strcpy( pErrStr, "̓ubLO" );								break;
	case WSAEINPROGRESS:			strcpy( pErrStr, "łɃubLO葱sĂ" );				break;
	case WSAEALREADY:				strcpy( pErrStr, "vꂽ͊ɎsA܂͎sς" );			break;
	case WSAENOTSOCK:				strcpy( pErrStr, "w肳ꂽ\Pbgł" );						break;
	case WSAEDESTADDRREQ:			strcpy( pErrStr, "̎sɑMAhXKv" );						break;
	case WSAEMSGSIZE:				strcpy( pErrStr, "bZ[WTCY傫" );							break;
	case WSAEPROTOTYPE:				strcpy( pErrStr, "\Pbg͗vꂽvgRɓKĂȂ" );		break;
	case WSAENOPROTOOPT:			strcpy( pErrStr, "sȃvgRIvV" );							break;
	case WSAEPROTONOSUPPORT:		strcpy( pErrStr, "vgRT|[gĂȂ" );						break;
	case WSAESOCKTNOSUPPORT:		strcpy( pErrStr, "w肳ꂽ\Pbg^Cv̓T|[gĂȂ" );		break;
	case WSAEOPNOTSUPP:				strcpy( pErrStr, "vꂽ̓T|[gĂȂ" );					break;
	case WSAEPFNOSUPPORT:			strcpy( pErrStr, "vgRt@~T|[gĂȂ" );				break;
	case WSAEAFNOSUPPORT:			strcpy( pErrStr, "AhXt@~T|[gĂȂ" );				break;
	case WSAEADDRINUSE:				strcpy( pErrStr, "AhX͊Ɏgpł" );							break;
	case WSAEADDRNOTAVAIL:			strcpy( pErrStr, "ȃlbg[NAhX" );							break;
	case WSAENETDOWN:				strcpy( pErrStr, "lbg[N_EĂ" );							break;
	case WSAENETUNREACH:			strcpy( pErrStr, "w肳ꂽlbg[NzXgɓBłȂ" );			break;
	case WSAENETRESET:				strcpy( pErrStr, "lbg[Nڑjꂽ" );							break;
	case WSAECONNABORTED:			strcpy( pErrStr, "lbg[Nڑjꂽ" );							break;
	case WSAECONNRESET:				strcpy( pErrStr, "lbg[NڑɂĔjꂽ" );				break;
	case WSAENOBUFS:				strcpy( pErrStr, "obt@sĂ" );								break;
	case WSAEISCONN:				strcpy( pErrStr, "\Pbg͊ɐڑĂ" );							break;
	case WSAENOTCONN:				strcpy( pErrStr, "\Pbg͐ڑĂȂ" );							break;
	case WSAESHUTDOWN:				strcpy( pErrStr, "\Pbg̓Vbg_EĂ" );					break;
	case WSAETOOMANYREFS:			strcpy( pErrStr, "QƂ̐" );									break;
	case WSAETIMEDOUT:				strcpy( pErrStr, "ڑv^CAEg" );							break;
	case WSAECONNREFUSED:			strcpy( pErrStr, "ڑۂꂽ" );										break;
	case WSAELOOP:					strcpy( pErrStr, "[v" );												break;
	case WSAENAMETOOLONG:			strcpy( pErrStr, "O" );										break;
	case WSAEHOSTDOWN:				strcpy( pErrStr, "zXg_EĂ" );								break;
	case WSAEHOSTUNREACH:			strcpy( pErrStr, "zXgւ̌oHȂ" );									break;
	case WSAENOTEMPTY:				strcpy( pErrStr, "fBNgł͂Ȃ" );								break;
	case WSAEPROCLIM:				strcpy( pErrStr, "vZX̐" );								break;
	case WSAEUSERS:					strcpy( pErrStr, "[U̐" );									break;
	case WSAEDQUOT:					strcpy( pErrStr, "fBXNNH[^" );										break;
	case WSAESTALE:					strcpy( pErrStr, "s悤Ƃ͔p~Ă" );					break;
	case WSAEREMOTE:				strcpy( pErrStr, "[g" );												break;
	case WSASYSNOTREADY:			strcpy( pErrStr, "lbg[NTuVXepłȂ" );				break;
	case WSAVERNOTSUPPORTED:		strcpy( pErrStr, "Winsock.dll̃o[W͈͊Oł" );					break;
	case WSANOTINITIALISED:			strcpy( pErrStr, "WinSockVXeĂȂ" );					break;
	case WSAEDISCON:				strcpy( pErrStr, "Vbg_E" );									break;
	case WSAENOMORE:				strcpy( pErrStr, "f[^͂ȏ㑶݂Ȃ" );							break;
	case WSAECANCELLED:				strcpy( pErrStr, "͎ꂽ" );									break;
	case WSAEINVALIDPROCTABLE:		strcpy( pErrStr, "T[rXvoC_̊֐e[u" );				break;
	case WSAEINVALIDPROVIDER:		strcpy( pErrStr, "T[rXvoC_" );								break;
	case WSAEPROVIDERFAILEDINIT:	strcpy( pErrStr, "T[rXvoC_̏Ɏs" );					break;
	case WSASYSCALLFAILURE:			strcpy( pErrStr, "VXeR[Ɏs" );								break;
	case WSASERVICE_NOT_FOUND:		strcpy( pErrStr, "T[rXȂ" );								break;
	case WSATYPE_NOT_FOUND:			strcpy( pErrStr, "^CvȂ" );									break;
	case WSA_E_CANCELLED:			strcpy( pErrStr, "LZꂽ" );								break;
	case WSAEREFUSED:				strcpy( pErrStr, "͋ۂꂽ" );										break;
	case WSAHOST_NOT_FOUND:			strcpy( pErrStr, "zXgȂ" );									break;
	case WSATRY_AGAIN:				strcpy( pErrStr, "w肳ꂽzXgȂA܂̓T[rẌُ" );	break;
	case WSANO_RECOVERY:			strcpy( pErrStr, "񕜕s\ȃG[" );							break;
	case WSANO_DATA:				strcpy( pErrStr, "vꂽ^Cṽf[^R[hȂ" );		break;
	}
}
/**
@brief		\PbgNX
@author		Noriyuki Lee
@since		2003.07.01
@note
LunaCuLunaSocketNXɁA
Luna؂藣CułB
*/
class Socket{
public:
	/**
		@brief	\Pbgpf[^

		WinSockǗ邽߂ɕKvȏ<BR>
		i[Ă\̂ł
	*/
	struct WORK_LUNASOCKET
	{
		char LastError[1024];							///< G[i[p
		bool IsInitialize;								///< tO
		HOSTINFO HostInfo;								///< zXg
		HOSTENT HostEntry;								///< zXgGg[
		SOCKET Socket;									///< ̃\Pbg
		bool IsConnect;									///< ڑۂ
	};
	// VARIABLE
private:
	WORK_LUNASOCKET *pWork;
public:
	Socket(){

		pWork = (WORK_LUNASOCKET *)malloc(sizeof(WORK_LUNASOCKET));
		if(pWork){
			Initialize(pWork);
		}
	}
	~Socket(){
		Uninitialize();
		if(pWork){
			free(pWork);
		}
	}
	void print(const char *p){
		printf(p);
	}
	void nextline(){
		printf("\n");
	}
	/**
		NX̏܂B

		@param pWorkData	[in] [NGÃAhX

		@retval true	
		@retval false	s
	*/
	bool Initialize( void *pWorkData )
	{
		print( "LunaSocketNX̏" );
		nextline();

		//----------------------------------------------------------
		// [NGA̎擾
		//----------------------------------------------------------
		pWork = (WORK_LUNASOCKET*)pWorkData;

		//----------------------------------------------------------
		// [NGȀ
		//----------------------------------------------------------
		MemoryClear( pWork, sizeof(WORK_LUNASOCKET) );
		pWork->Socket = INVALID_SOCKET;

		return true;
	}


	/**
		NX̉܂B
	*/

	void Uninitialize( void )
	{
		print( "LunaSocketNX̉" );
		nextline();

		Shutdown();
	}


	/**
		ڑ̃lbg[Nؒf܂
	*/

	void Shutdown( void )
	{
		if(!pWork)
			return;
		//-------------------------------------------------------
		// \Pbgؒf
		//-------------------------------------------------------
		if ( pWork->IsConnect )
		{
			char TempBuff[64] = "";
			::shutdown( pWork->Socket, SD_SEND );
			while ( ::recv( pWork->Socket, TempBuff, sizeof(TempBuff), 0 ) > 0 );
			::shutdown( pWork->Socket, SD_BOTH );
			::closesocket( pWork->Socket );

			pWork->IsConnect = false;
			pWork->IsInitialize = false;
		}
	}


	/*
		ŌɔG[𕶎̏ԂŎ擾܂

		@param pError	: G[i[obt@

		@retval true	G[ꍇ
		@retval false	G[Ȃꍇ
	*/

	bool GetLastError( char *pError )
	{
		if ( pWork->LastError[0] != '\0' )
		{
			strcpy( pError, pWork->LastError );
			return true;
		}

		return false;
	}


	/**
		WinSock̏܂

		@retval true	
		@retval false	s
	*/

	bool Start( void )
	{
		pWork->Socket = ::socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );
		if ( pWork->Socket == INVALID_SOCKET )
		{
			GetMakeError( ::WSAGetLastError(), pWork->LastError );
			return false;
		}

		pWork->IsInitialize = true;

		return true;
	}


	/**
		w薼̃zXg擾܂

		@param pServerString	[in] zXgʖ̊i[AhXizXgłhołj
		@param pHost			[out] zXgi[AhX

		@retval true	
		@retval false	s
	*/

	bool GetHostInfo( const char *pServerString, HOSTINFO *pHost )
	{
		long i;
		IN_ADDR InAddrHost;
		HOSTENT *pHostEntry;

		//------------------------------------------------------------
		// w肳ꂽ񂪃zXghoAhXׂ
		//------------------------------------------------------------
		InAddrHost.s_addr = ::inet_addr( pServerString );
		if ( InAddrHost.s_addr == INADDR_NONE )
		{
			// hoł͂Ȃ̂ŃzXgƂď
			pHostEntry = ::gethostbyname( pServerString );
			if ( pHostEntry == NULL )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return false;
			}
		}
		else
		{
			// hoAhX̂悤ł
			pHostEntry = ::gethostbyaddr( (const char *)&InAddrHost, sizeof(IN_ADDR), AF_INET );
			if ( pHostEntry == NULL )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return false;
			}
		}

		//------------------------------------------------------------
		// zXg̕ۑ
		//------------------------------------------------------------
		MemoryClear( &pWork->HostInfo, sizeof(pWork->HostInfo) );

		// zXg
		strcpy( pWork->HostInfo.Name, pHostEntry->h_name );

		// zXg̕ʖ
		for ( i = 0; pHostEntry->h_aliases[i] != NULL; i++ )
		{
			strcpy( pWork->HostInfo.Alias[pWork->HostInfo.AliasCount++], pHostEntry->h_aliases[i] );
		}

		// AhX
		for ( i = 0; pHostEntry->h_addr_list[i] != NULL; i++ )
		{
			const char *p = ::inet_ntoa( *((IN_ADDR*)pHostEntry->h_addr_list[i]));
			strcpy( pWork->HostInfo.Address[pWork->HostInfo.AddressCount++], p );
		}

		// f[^TCY
		pWork->HostInfo.Length = pHostEntry->h_length;
		// f[^^Cv
		pWork->HostInfo.Type = pHostEntry->h_addrtype;

		//------------------------------------------------------------
		// zXgf[^Rs[
		//------------------------------------------------------------
		if ( pHost != NULL )
		{
			MemoryCopy( pHost, &pWork->HostInfo, sizeof(HOSTINFO) );
		}

		MemoryCopy( &pWork->HostEntry, pHostEntry, sizeof(HOSTENT) );

		return true;
	}

	/**
		[JzXg擾܂

		@param pName	[out] zXgi[|C^
	*/

	void GetLocalHostName( char *pName )
	{
		char Buff[256] = "";
		// zXg擾
		::gethostname( Buff, sizeof(Buff) );
		strcpy( pName, Buff );
	}

	
	/**
		w肵T[o[ւ̐ڑs܂

		@param pServerString	[in] zXgʖ̊i[AhXizXgłhołj
		@param PortNo			[in] |[gԍ

		@retval true	
		@retval false	s
	*/
	
	bool ConnectServer( const char *pServerString, unsigned short PortNo )
	{
		long ReturnCode;
		SOCKADDR_IN SockAddr;

		//------------------------------------------------------------
		// zXgf[^擾
		//------------------------------------------------------------
		if ( !GetHostInfo( pServerString, NULL ) )
		{
			return false;
		}

		//------------------------------------------------------------
		// ڑpf[^
		//------------------------------------------------------------
		MemoryClear( &SockAddr, sizeof(SOCKADDR_IN) );
		SockAddr.sin_family	= AF_INET;
		SockAddr.sin_port	= ::htons( PortNo );
		SockAddr.sin_addr	= *((IN_ADDR*)pWork->HostEntry.h_addr_list[0]);

		//------------------------------------------------------------
		// ڑ
		//------------------------------------------------------------
		ReturnCode = ::connect( pWork->Socket, (SOCKADDR*)&SockAddr, sizeof(SOCKADDR_IN) );
		if ( ReturnCode == SOCKET_ERROR )
		{
			ReturnCode = ::WSAGetLastError();
			if ( ReturnCode != WSAEWOULDBLOCK )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return false;
			}
		}

		pWork->IsConnect = true;

		return true;
	}

	
	/**
		w肵f[^ڑɑM܂

		@param pData	[in] f[^AhX
		@param Size		[in] f[^TCY

		@retval -2		ڑ͕ꂽ
		@retval -1		MɎs
		@retval 0ȏ	MoCg
	*/
	
	long Send( const void *pData, unsigned long Size )
	{
		const char *pBuffer = (const char *)pData;
		unsigned long Rest = Size;

		//----------------------------------------------------
		// f[^Mp[v
		//----------------------------------------------------
		while ( Rest > 0 )
		{
			//--------------------------------------------
			// c̃oCg𑗐M
			//--------------------------------------------
			unsigned long SendSize = ::send( pWork->Socket, pBuffer, Rest, 0 );
			if ( SendSize == SOCKET_ERROR )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return -1;
			}
			else
			if ( SendSize == 0 )
			{
				strcpy( pWork->LastError, "͐ؒf܂" );
				return -2;
			}

			// Mi߂
			Rest -= SendSize;
			pBuffer += SendSize;
		}

		return (Size - Rest);
	}

	
	/**
		w肵f[^ڑ悩M܂

		@param pData	[in] f[^AhX
		@param Size		[in] f[^TCY

		@retval -2		ڑ͕ꂽ
		@retval -1		MɎs
		@retval 0ȏ	MoCg
	*/
	
	long Receive( void *pData, unsigned long Size )
	{
		char *pBuffer = (char *)pData;
		unsigned long Rest = Size;

		//----------------------------------------------------
		// f[^Mp[v
		//----------------------------------------------------
		while ( Rest > 0 )
		{
			//--------------------------------------------
			// c̃oCgM
			//--------------------------------------------
			unsigned long ReceiveSize = ::recv( pWork->Socket, pBuffer, Rest, 0 );
			if ( ReceiveSize == SOCKET_ERROR )
			{
				GetMakeError( ::WSAGetLastError(), pWork->LastError );
				return -1;
			}
			else
			if ( ReceiveSize == 0 )
			{
				strcpy( pWork->LastError, "͐ؒf܂" );
				return -2;
			}

			// Mi߂
			Rest -= ReceiveSize;
			pBuffer += ReceiveSize;
		}

		return (Size - Rest);
	}

	
	/**
		HTTPT[o[t@C擾܂<BR>
		VXeR[obNB

		@param pServerName		[in] T[o[
		@param pFileNameList[]	[in] t@CXg
		@param pDataList[]		[out] f[^i[
		@param DataSizeList		[out] f[^TCYi[
		@param FileCount		[in] t@C

		@retval true		
		@retval false		s
	*/
	
	bool GetFileFromHTTP( const char *pServerName, const char *pFileNameList[], void *pDataList[], unsigned long DataSizeList[], long FileCount )
	{
		const unsigned long BUFFER_SIZE = 4 * 1024;
		char *pBuffer = (char *)MemoryAlloc( BUFFER_SIZE );
		if ( pBuffer == NULL )
		{
			strcpy( pWork->LastError, "Ɨpmۂł܂ł" );
		}
		else
		{
			long Result;
			bool IsInit = pWork->IsInitialize;

			//------------------------------------------------------------------
			// WinSock̏
			//------------------------------------------------------------------
			if ( IsInit )
			{
				if ( !Start() )
				{
					MemoryFree( pBuffer );
					return false;
				}
			}
		
			//------------------------------------------------------------------
			// ڑ
			//------------------------------------------------------------------
			if ( !ConnectServer( pServerName, 80 ) )
			{
				MemoryFree( pBuffer );
				return false;
			}

			//------------------------------------------------------------------
			// t@CM
			//------------------------------------------------------------------
			for ( long i = 0; i < FileCount; i++ )
			{
				pDataList[i] = MemoryAlloc( 0 );
				DataSizeList[i] = 0;
				// t@CMNGXg𑗐M
				sprintf( pBuffer, "GET %s\n", pFileNameList[i] );
				Result = ::send( pWork->Socket, pBuffer, strlen(pBuffer), 0 );
				if ( Result == SOCKET_ERROR ) break;

				while ( true )
				{
					Result = ::recv( pWork->Socket, pBuffer, BUFFER_SIZE, 0 );
					if ( Result == SOCKET_ERROR )
					{
						MemoryFree( pDataList[i] );
						DataSizeList[i] = 0;
						break;
					}
					else
					if ( Result == 0 )
					{
						break;
					}
					else
					{
						// Ċ蓖
						void *pNew = MemoryReAlloc( pDataList[i], DataSizeList[i] + Result );
						if ( pNew == NULL )
						{
							DataSizeList[i] = 0;
							MemoryFree( pDataList[i] );
							strcpy( pWork->LastError, "Ɨpmۂł܂ł" );
							break;
						}

						pDataList[i] = pNew;
						MemoryCopy( (unsigned char*)pDataList[i] + DataSizeList[i], pBuffer, Result );

						DataSizeList[i] += Result;
					}
				}
			}

			//------------------------------------------------------------------
			// 
			//------------------------------------------------------------------
			if ( IsInit )
			{
				Shutdown();
			}

			MemoryFree( pBuffer );
		}

		return true;
	}

	
	/**
		G[R[hG[擾܂

		@param ErrorCode	[in] G[R[h
		@param pErrStr		[out] G[bZ[Wi[
	*/
	
	void GetMakeError( long ErrorCode, char *pErrStr )
	{
		MemoryClear( pWork->LastError, sizeof(pWork->LastError) );
		GetSocketError( ErrorCode, pErrStr );
	}

};//end of class
/**
@note
de\PbgCuQlɂčCułB
*/
class CEasySocket{
	
  SOCKET sd;
	BOOST_STATIC_CONSTANT(int,lasterror_str_length = 1024);
	char mLastError[lasterror_str_length + 1];
public:
#ifdef WIN32
	BOOST_STATIC_CONSTANT(SOCKET,invalid_socket = INVALID_SOCKET);
#else
	BOOST_STATIC_CONSTANT(SOCKET,invalid_socket = (SOCKET)(~0));
#endif
		//invalid_socket = -1
	
	CEasySocket(){
		//DKUTIL_STRUCTURE_INIT(sd);
		sd = invalid_socket;
		memset(mLastError,0,sizeof(mLastError));
	}
	~CEasySocket(){
		disconnect();
	}
	bool good()const{
		return sd != invalid_socket;
	}
	std::string getLastError()const{
		char copyed[lasterror_str_length + 1];
		memcpy(copyed,mLastError,lasterror_str_length);
		copyed[lasterror_str_length ] = '\0';
		std::string str = mLastError;
		return str;
	}

	void disconnect(){
		if(sd != invalid_socket){
      shutdown_output();
      shutdown_input();
      closesocket(sd);
			sd = invalid_socket;
    }
	}
	/*bool recv(char *buff,int size){
		 if(sd == invalid_socket){
        return false;
    }else{
			int ret = ::recv(sd, (char *)buff, size, 0);
      if(ret <= 0){
          return false;
      }else{
         
      }
    }
		return true;
	}*/
		/**
		w肵f[^ڑ悩M܂

		@param pData	[in] f[^AhX
		@param Size		[in] f[^TCY

		@retval -2		ڑ͕ꂽ
		@retval -1		MɎs
		@retval 0			
	*/
	
	long responsible_recv( void *pData, unsigned long Size ,size_t *readsize)
	{
		char *pBuffer = (char *)pData;
		unsigned long Rest = Size;

		//----------------------------------------------------
		// f[^Mp[v
		//----------------------------------------------------
		while ( Rest > 0 )
		{
			//--------------------------------------------
			// c̃oCgM
			//--------------------------------------------
			unsigned long ReceiveSize = ::recv( sd, pBuffer, Rest, 0 );
			if ( ReceiveSize == SOCKET_ERROR )
			{
				GetMakeError( ::WSAGetLastError(), mLastError );
				return -1;
			}
			else
			if ( ReceiveSize == 0 )
			{
				strcpy( mLastError, "͐ؒf܂" );
				if(Size == Rest){
					return -2;
				}else{
					goto End;
				}
			}

			// Mi߂
			Rest -= ReceiveSize;
			pBuffer += ReceiveSize;
		}
	End:
		*readsize = (Size - Rest);
		return 0;
	}

	void GetMakeError( long ErrorCode, char *pErrStr )
	{
		MemoryClear( mLastError, sizeof(mLastError) );
		GetSocketError( ErrorCode, pErrStr );
	}
	void MemoryLastError(){
		GetMakeError( ::WSAGetLastError(),mLastError);
	}
	/**
		w肵f[^ڑɑM܂

		@param pData	[in] f[^AhX
		@param Size		[in] f[^TCY

		@retval -2		ڑ͕ꂽ
		@retval -1		MɎs
		@retval 0ȏ	MoCg
		@note
		قڊmSizẽf[^𑗐M܂B
	*/
	int responsible_send(const void *pData,size_t Size){
		if(sd==invalid_socket){
			return -1;
		}
		const char *pBuffer = (const char *)pData;
		unsigned long Rest = Size;

		//----------------------------------------------------
		// f[^Mp[v
		//----------------------------------------------------
		while ( Rest > 0 )
		{
			//--------------------------------------------
			// c̃oCg𑗐M
			//--------------------------------------------
			unsigned long SendSize = ::send( sd, pBuffer, Rest, 0 );
			if ( SendSize == SOCKET_ERROR )
			{
				GetMakeError( ::WSAGetLastError(),mLastError);
				return -1;
			}
			else if ( SendSize == 0 )
			{
				strcpy( mLastError, "͐ؒf܂" );
				return -2;
			}

			// Mi߂
			Rest -= SendSize;
			pBuffer += SendSize;
		}

		return (Size - Rest);

	}
	void shutdown_input(){
		if(sd != invalid_socket){
        shutdown(sd, SHUT_RD);
    }
	}
  void shutdown_output(){
		if(sd != invalid_socket){
        shutdown(sd, SHUT_WR);
    }
	}
	bool connect(const char* address, unsigned short port)
	{
		sockaddr_in sa;
		memset(&sa, 0, sizeof(sa));

		// O
		unsigned long addr = inet_addr(address);
		if(addr != INADDR_NONE){
				sa.sin_family = AF_INET;
				sa.sin_addr.s_addr = addr;
				sa.sin_port = htons(port);
		}else{
				hostent* hp = gethostbyname(address);
				if(hp){
						sa.sin_family = AF_INET;
						sa.sin_addr.s_addr = *reinterpret_cast<unsigned long*>(hp->h_addr);
						sa.sin_port = htons(port);
				}else{
						return false;
				}
		}
		// \Pbg쐬
		sd = socket(AF_INET, SOCK_STREAM, 0);
		if(sd == invalid_socket){
				return false;
		}
		// ڑ
		if(::connect(sd, reinterpret_cast<sockaddr*>(&sa), sizeof(sockaddr)) != 0){
				// s
				closesocket(sd);
				sd = invalid_socket;
				return false;
		}
		return true;
	}


	struct HTTPDataType{
		HTTPDataType( parm_string get , parm_string filename ) : 
			mAccessValid(false) , mFileSize(0) ,
			mGET(get) ,mFilename(filename) , 
			mProcessValid(false)
		{
		
		}
		///Őǂ
		bool mProcessValid;
		///URLLǂ
		bool mAccessValid;
		///GET /hoge/hoge.html HTTP/1.0݂ȓź@/hoge/hoge.html̕
		std::string mGET;
		///o\̃t@C
		std::string mFilename;
		///ANZXɎgpNGXg
		std::string mAccessRequest;
		///t@CTCY
		ULONGLONG mFileSize;
	};
	typedef std::list<HTTPDataType> filelist_t;

	/**
	getDataHTTP()ŎgpHTTPڑėĂf[^t@N^[
	*/
	struct HTTPfile_functor{
		big_filestream mfs;
		///@return falseŎs
		bool operator()(const HTTPDataType &dt,int state,
			const BYTE *data,size_t size,void *pointer)
		{
			bool r = false;
			try{
				switch(state){
				case http_begin:
					if(dt.mFilename.empty()){
						return false;
					}
					r = mfs.reset(dt.mFilename,write_mode | binary_mode);
					/*if(false==r){
						return false;
					}*/
					r = mfs.open();
					//break;
				case http_loading:
					mfs.responsible_write(data,size);
					r = true;
					break;
				case http_end:
					mfs.responsible_write(data,size);
					mfs.close();
					r = true;
					break;
				case http_error:
					mfs.close();
					break;
				default:
					dkcmFORCE_NOT_ASSERT("HTTPfile_functor ԑJڃG[");
				}
			}catch(filesystem_error er){
				DEBUGMB(er.what());
				return false;
			}
			return r;
		}
	};

	bool getDataHTTP(parm_string ServerName,int port, 
		filelist_t &flist)
	{
		HTTPfile_functor func;
		return getDataHTTPEx(ServerName,port,flist,func);
	}
	/*
	static std::string DefaultRequestStr
		="GET %s HTTP/1.0\r\n \
			User-Agent:Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7) Gecko/20040803 Firefox/0.9.3 \
			\r\n\r\n";
	*/

	/**
	@param ServerName[in] T[o[
	@param port[in] 80ft@NgX^_[h 8080ƂB
	@param flist[in][out] 炩ߒ`_E[hXg
	@param functor__[in] t@N^[
	@param pointer[in] ւ̃|C^
	@param tempsize[in] e|obt@̃TCY ftHg256KB
	@note

	ServerName( T[o[w)  http://www.google.co.jp/hogehoge/index.html ̂悤URLnĂ͂ȂB
	肵IPAhXA̖Oi www.google.co.jp )n悤ɂB

	܂A	functor__@ɂ HTTPfile_functor ̂悤Ȋ̂̂g
	@see HTTPfile_functor
	*/
	enum{
		///VɎn܂
		http_begin = 0,
		///Aǂݍݒ
		http_loading,
		///肭I܂B
		http_end,
		///G[Ȃ̂ŁÃf[^͎gȂŉB
		http_error,
	};

	

	template<class FUNCTOR__>
	bool getDataHTTPEx( 
		parm_string ServerName,int port, 
		filelist_t &flist,FUNCTOR__ functor__ ,
		void *pointer = NULL,
		parm_string request = "GET %s HTTP/1.0\r\n \
			User-Agent:Mozilla/5.0 (Macintosh; U; PPC Mac OS X Mach-O; en-US; rv:1.7) Gecko/20040803 Firefox/0.9.3 \
			\r\n\r\n",
		size_t tempsize=1024 * 256)
	{
		bool r=false;
		if(false==connect(ServerName,port))
		{//q̂Ɏs
			MemoryLastError();
			return false;
		}
		if(good()==false){
			MemoryLastError();
			return false;
		}

		
		std::string tempstr;
		filelist_t::iterator it = flist.begin();



		scoped_buffer_byte tempbuff(tempsize);
		if(false==tempbuff.isValid()){
			strcpy(mLastError,"mۃG[");
			goto End;
		}

		int tr;
		tr = -1;

		for(;it != flist.end();it++)
		{
			tempstr.clear();


			
			//NGXg Mf[^p
			
			/*
			tempstr += "GET ";
			tempstr += (*it).mGET;
			tempstr += " HTTP/1.0";
			tempstr += "\r\n\r\n";
			*/
      
			// HTTPNGXgM
      /*
			sockout.write("GET " + url +" HTTP/1.1\r\n");
      sockout.write("Host: " + host + "\r\n");
      sockout.write("Connection: close\r\n");
      sockout.write("\r\n");
			*/
			tempstr += "GET " + (*it).mGET + " HTTP/1.1\r\n";
      tempstr += "Host: ";
			tempstr += ServerName.c_str();
			tempstr += "\r\n";
      tempstr += "Connection: close\r\n";
      tempstr += "\r\n";

			(*it).mAccessRequest = tempstr;

			if((*it).mGET.empty())
			{//ƁA΂Bꂶ႟G[B
				continue;
			}
			
			//
			tr = responsible_send(tempstr.c_str(),tempstr.size());

			if(tr < 0){
				goto End;
			}
			//ǂ݂񂾃TCYۑ
			size_t readsize;
			//tempbuff.size()temp
			size_t tempsize = tempbuff.size();
			//recvG[TRUE
			bool recv_error = false;
			//recv̖߂l
			int recv_res;
			//Xe[g ÕXe[g
			int state,back_state;
			
			back_state = state = -1;
			
			for(;;){
				//f[^Qbg
				recv_res = responsible_recv(tempbuff.get(),tempsize,&readsize);
				
				//recv_error = (recv_res < 0);
				if(-1 != state){
					back_state = state;
				}
				//Ԃd
				switch(recv_res){
				case -2:
					state = http_end;
					break;
				case -1:
					state = http_error;
					break;
				default:
					if(-1==state ){
						state = http_begin;
					}else{
						state = http_loading;
					}
				}//end of switch

				//̓t@N^[C (recv_resėp)
				recv_res = functor__( (*it) , state , tempbuff.get(), readsize, pointer );
				
				if(recv_res==false)
				{//t@N^[G[ɂȂB΂IIȂB
					(*it).mProcessValid = false;
					(*it).mAccessValid = (state != http_error);
					break;

				}

				if(http_end==state){//听!!!
					(*it).mAccessValid = true;
					(*it).mProcessValid = true;
					break;
				}	
				if( http_error==state)
				{//s!!!
					if(-1==back_state){
						(*it).mAccessValid = false;
					}else{
						(*it).mAccessValid = true;
					}
					(*it).mProcessValid = false;
					break;
				}
			}//end of recv for

		}//end of for
	
	End:
		if(it==flist.end()){
			r = true;
		}
		disconnect();

		return r;
	}


};



}//end of dkutil namespace



#endif