/**
@file download.hpp
@brief Windowsp_E[h邽߂̃WbN

*/

#ifndef DKUTIL_NETWORK_WIN32_DOWNLOAD_HPP
#define DKUTIL_NETWORK_WIN32_DOWNLOAD_HPP

#include <Urlmon.h>
#include <helper/windows.h>
#include <dkutil/dll.hpp>


namespace dkutil{



/**

_E[hNXB
IDownload::URLDownloadToFileł_E[h͏oB


W[ƂĊɂ́A
̃NXpăK`K`MFCoɒ`Ďg
̓Iɂ
<PRE>
	STDMETHODIMP_(ULONG) AddRef()	{ return (++m_cRef); }
	STDMETHODIMP_(ULONG) Release()	{ return (m_cRef ? --m_cRef : 0L); }
	STDMETHODIMP GetBindInfo( DWORD*, BINDINFO* ) { return E_NOTIMPL; }
	STDMETHODIMP GetPriority( LONG* ) { return E_NOTIMPL; }
	STDMETHODIMP OnLowResource( DWORD ) { return E_NOTIMPL; }
	STDMETHODIMP OnDataAvailable( DWORD, DWORD, FORMATETC*, STGMEDIUM* ) { return E_NOTIMPL; }
	STDMETHODIMP OnObjectAvailable( REFIID, IUnknown* ) { return E_NOTIMPL; }
	STDMETHODIMP OnStartBinding( DWORD, IBinding* ) { return E_NOTIMPL; }
	STDMETHODIMP OnStopBinding( HRESULT, LPCWSTR ) { return E_NOTIMPL; }
	STDMETHODIMP QueryInterface( REFIID riid, void** ppv )
	STDMETHODIMP OnProgress( ULONG cur, ULONG max, ULONG status, LPCWSTR txt )
</PRE>
`B
ڂ[google:caldix]̃\[XQlɂȂB

*/
class IDownload : public IBindStatusCallback{	
public:
	/*typedef HRESULT (*URLDownloadToFile_type)(
		LPUNKNOWN pCaller,
    LPCTSTR szURL,
    LPCTSTR szFileName,
    DWORD dwReserved,
    LPBINDSTATUSCALLBACK lpfnCB
	);*/
	typedef HRESULT  (WINAPI *URLDownloadToFile_type)(
		LPUNKNOWN pCaller,
    LPCTSTR szURL,
    LPCTSTR szFileName,
    DWORD dwReserved,
    LPBINDSTATUSCALLBACK lpfnCB
	);
	virtual ~IDownload()
	{
	}


	static bool URLDownloadToFile(parm_string URL,parm_string local_filename,
		IBindStatusCallback *onProgressP=NULL)
	{
		DLLManager mgr("urlmon.dll");
		
		URLDownloadToFile_type pf = 
#ifndef UNICODE
			(URLDownloadToFile_type)mgr.find("URLDownloadToFileA");
#else
			(URLDownloadToFile_type)mgr.find("URLDownloadToFileW");
#endif
		if(NULL==pf){
			return false;
		}
		return S_OK == pf(NULL,URL.c_str(),local_filename.c_str(),0,onProgressP);
	}

	bool download(parm_string URL,parm_string local_filename)
	{
		return URLDownloadToFile(URL,local_filename,this);
	}
	/*

	STDMETHODIMP OnProgress( 
		ULONG ulProgress,
    ULONG ulProgressMax,
    ULONG ulStatusCode,
    LPCWSTR szStatusText
		)
	{


	}*/

	/*
	template<class FUNCTOR>
	bool download(
	*/
};

///@note caldix̃\[XɍĂ݂B
class CDownload : public IDownload
{
public:
	CDownload() : 
		m_cRef( 1 ) , m_stateCancel(false),
		mPrevTime(0) , mCur(0) , mMax(0),mStatus(0)
	{}

private:
	//const kiArray<DLLInfo*>& m_lst;
	//const kiPath& m_pth;
	unsigned long m_cRef;
	/*
	unsigned long m_total;
	unsigned long m_step;
	unsigned long m_startTime, m_lastTime;
	*/
	bool m_stateCancel;

	DWORD mPrevTime;
	ULONG mCur;
	ULONG mMax;
	ULONG mStatus;
public:


	STDMETHODIMP_(ULONG) AddRef()	{ return (++m_cRef); }
	STDMETHODIMP_(ULONG) Release()	{ return (m_cRef ? --m_cRef : 0L); }
	STDMETHODIMP GetBindInfo( DWORD*, BINDINFO* ) { return E_NOTIMPL; }
	STDMETHODIMP GetPriority( LONG* ) { return E_NOTIMPL; }
	STDMETHODIMP OnLowResource( DWORD ) { return E_NOTIMPL; }
	STDMETHODIMP OnDataAvailable( DWORD, DWORD, FORMATETC*, STGMEDIUM* ) { return E_NOTIMPL; }
	STDMETHODIMP OnObjectAvailable( REFIID, IUnknown* ) { return E_NOTIMPL; }
	STDMETHODIMP OnStartBinding( DWORD, IBinding* ) { return E_NOTIMPL; }
	STDMETHODIMP OnStopBinding( HRESULT, LPCWSTR ) { return E_NOTIMPL; }
	
	STDMETHODIMP QueryInterface( REFIID riid, void** ppv )
	{
		*ppv = NULL;
		AddRef();
		if( IsEqualIID( riid, IID_IUnknown ) || IsEqualIID( riid, IID_IBindStatusCallback ) )
			*ppv = (IBindStatusCallback*)this;
		else
		{
			Release();
			return E_NOINTERFACE;
		}
		return NOERROR;
	}
	void notifyCancel(){
		m_stateCancel = true;
	}
	///oߎԂ擾
	DWORD getProgressTime()const{
		return ::GetTickCount() - mPrevTime;
	}
	ULONG getProgress()const{
		return mCur;
	}
	ULONG getProgressMax()const{
		return mMax;
		}
	///@return CDownload::OnProgress()Ă
	ULONG getStatusCode()const{
		return mStatus;
		}
	

	/**
	@note
	http://msdn.microsoft.com/workshop/networking/moniker/reference/enums/bindstatus.asp
	2005/03/06 http://www.microsoft.com/japan/msdn/library/ja/vclib/html/_mfc_CAsyncMonikerFile.3a3a.OnProgress.asp?frame=true
	p
	
	BINDSTATUS_FINDINGRESOURCE 
	oCh́AIuWFNgĂ郊\[X܂̓oChXg[WłBszStatusText ɂ́A郊\[X̕\ (Ƃ "www.microsoft.com") w肵܂B 
	BINDSTATUS_CONNECTING 
	oCh́AoChIuWFNg܂̓Xg[W郊\[XɐڑłBszStatusText ɂ́Aڑ郊\[X̕\ (Ƃ IP AhX) w肵܂B 
	BINDSTATUS_SENDINGREQUEST 
	oCh́AoChIuWFNg܂̓Xg[WvłBszStatusText ɂ́AIuWFNg̕\ (Ƃ΃t@C) w肵܂B 
	BINDSTATUS_REDIRECTING 
	oCh́Aʂ̃f[^̏ꏊɃ_CNg܂BszStatusText ɂ́AVf[^̏ꏊ̕\w肵܂B 
	BINDSTATUS_USINGCACHEDCOPY 
	oCh́AvꂽIuWFNg܂̓Xg[WLbVꂽRs[擾łBszStatusText  NULL łB 
	BINDSTATUS_BEGINDOWNLOADDATA 
	oCh́AoChIuWFNg܂̓Xg[W̎MJn܂BszStatusText ɂ́Af[^̏ꏊ̕\w肵܂B 
	BINDSTATUS_DOWNLOADINGDATA 
	oCh́AoChIuWFNg܂̓Xg[W̎MpĂ܂BszStatusText ɂ́Af[^̏ꏊ̕\w肵܂B 
	BINDSTATUS_ENDDOWNLOADDATA 
	oCh́AoChIuWFNg܂̓Xg[W̎MI܂BszStatusText ɂ́Af[^̏ꏊ̕\w肵܂B 
	BINDSTATUS_CLASSIDAVAILABLE 
	oChIuWFNg̃CX^X쐬łBszStatusText ɂ́AVIuWFNg CLSID 𕶎`Ŏw肵ANCAg̓oChKvɉăLZł܂B 
	
	*/
	STDMETHODIMP OnProgress( ULONG cur, ULONG max, ULONG status, LPCWSTR txt )
	{
		//msgLoop( PEEK );

		if( m_stateCancel || status == BINDSTATUS_ENDDOWNLOADDATA)
		{
			m_stateCancel = false;
			return E_ABORT;
		}
		mCur = cur;
		mMax = max;
		mStatus = status;


		mPrevTime = ::GetTickCount();

		//sendMsgToItem( IDC_BAR, PBM_SETPOS, (int)(((double)(m_step+cur))/m_total*32768) );
		return S_OK;
	}
};

}//end of dkutil namespace



#endif