
#ifndef DKUTIL_OS_HPP
#define DKUTIL_OS_HPP

#include <dkutil/config.hpp>
#include <dkutil_c/dkcOS.h>

namespace dkutil{


inline bool isOSWin95_First_or_SP1(OSVERSIONINFO *os){

	if(os->dwPlatformId == VER_PLATFORM_WIN32_WINDOWS){
		if(os->dwMajorVersion == 4){
			if(os->dwMinorVersion == 0){
				if(os->dwBuildNumber <= 950){
					return true;
				}
			}
		}
	}
	return false;
}

inline bool isOSWin95_OSR2_or_21(OSVERSIONINFO *os){
	if(os->dwPlatformId == VER_PLATFORM_WIN32_WINDOWS){
		if(os->dwMajorVersion == 4){
			if(os->dwMinorVersion == 0){
				if( 950 < os->dwBuildNumber && os->dwBuildNumber <= 1111){
					return true;
				}
			}
		}
	}
	return false;
}

inline bool isOSWin95_OSR_25(OSVERSIONINFO *os){
	if(os->dwPlatformId == VER_PLATFORM_WIN32_WINDOWS){
		if(os->dwMajorVersion == 4){
			if(os->dwMinorVersion == 0){
				if(1111 < os->dwBuildNumber && os->dwBuildNumber <= 1212){
					return true;
				}
			}
		}
	}
	return false;
}

inline bool isOSWin95(){
	/*	OSVERSIONINFO os;
	os.dwOSVersionInfoSize=sizeof(os);

	 
	if(GetVersionEx(&os)==0){
		throw std::runtime_error("GetVersionEx Error");
	}*/
	return (dkcGetOSVersion() == enuWindows95);
}
inline bool isOSWinNT40(){
	return (dkcGetOSVersion() ==enuWindowsNT4_0);
}




///WindowsOSNTnǂ
inline bool isOSNT(){
	int r=dkcGetOSVersion();
	if(r != enuWindows3_1 && 
		r != enuWindows95 && 
		r != enuWindowsMe && 
		r != enuWindows98)
	{
		return true;
	}
	return false;
}

///OS9xnǂ
inline bool isOS9x(){
	return (!isOSNT());
}

/*!
dkcGetOSVersion֐ŎgĂƂWindows̎ނ𕶎ɂB<br>
@param [out] copybuff obt@̃AhXn܂
@param [in] buffsize copybuff̃TCYoCgPʂœ܂B
@return true = succeeded / false = failed
*/
///Windows̎ނ𕶎ɂB
inline bool GetOSName(char *copybuff,size_t buffsize){
	int temp=dkcGetOSVersion();
	if(temp < 0)
		return false;
	static char *table[8]={
		"Windows3.1",
		"WindowsNT3.51",
		"WindowsNT4.0",
		"Windows95",
		"Windows98",
		"Windows2000",
		"WindowsMe",
		"WindowsXP"
	};
	if(copybuff != NULL && buffsize !=0){
		_snprintf(copybuff,buffsize,table[temp]);
	}else{
		return false;
	}
	return true;
}


}//end of dkutil namespace



#endif
