

#ifndef _dkutilLog__h__
#define _dkutilLog__h__


#include <dkutil/dktl/map_ex.hpp>
#include <dkutil/filesystem/utility.hpp>
#include <dkutil/filesystem/std_filestream.hpp>
//#include <dkutil/parser/general_purpose_data.hpp>

//#include <dkutil/dktl/array_onebyone.hpp>
#include <dkutil/math/utility.hpp>

namespace dkutil{


//extern bool dInitLog( const char *filename );

//extern bool dAddLog( const char *filename,const char *str , ... );


///G[O(t@C) @param filename[in] t@C̖O
inline bool dInitLog( const char *filename )
{
	FILE *fp;
	// G[Ot@CJ()
	if(NULL==(fp = fopen( filename , "wt" ))){
		return false;
	}
	fclose( fp ) ;
	
	return true;
}
///Of @param filename[in] t@Cl[ @param str[in] f
inline bool dAddLog( const char *filename,const char *str , ... ){
	FILE *fp=NULL;
	char s[2048]="";
	SET_VA_LIST_INSERT_YEN_N(s,2048,str);
	
	//t@CI[v
	if(NULL == (fp = fopen( filename , "at" )))
		return false;
	// G[Ot@Cɏo
	fputs( s , fp ) ;
	fclose( fp ) ;
	return true;
}


inline bool dump(parm_string filename,const void *ptr,size_t size,bool rewrite=false)
{
	if(false==rewrite && true==FileExist(filename)){
		return false;
	}
	std_filestream stream;
	stream.reset(filename,write_mode | binary_mode);
	if(false==stream.open())
	{
		return false;
	}
	stream.responsible_write(ptr,size);
	return true;
}



#if 0

//vg^Cv錾
class dumper;
class outputer;

///ǋLpstd::string... logger,outputerNXgB
template<class STRING_=std::string>
class postscript_string_base : public STRING_{
	void add_str_logic(const char *s){
		STRING_TYPE(*this) + s;//operator+(s);
		char mys[2]={'\n','\0'};
		STRING_TYPE(*this) + mys;
	}
public:
	friend class dumper;
	friend class outputer;
	typedef STRING_ STRING_TYPE;
	postscript_string_base(const STRING_TYPE &s) : STRING_TYPE(s){

	}
	postscript_string_base(const char *str) : STRING_TYPE(str){}

	postscript_string_base(){}
	//virtual ~postscript_string_base(){}

	void add_str(const char *s){
		add_str_logic(s);
	}
	void add_str(const std::string &s){
		add_str_logic(s.c_str());
	}
	void add_str(char *str,...){
		char s[2048]="";
		SET_VA_LIST(s,sizeof(s),str);
		add_str_logic(s);
	}



};

typedef postscript_string_base<> postscript_string ;

///Ȃ񂾂Ioutputerbă_TCOͥ
class outputer{
public:
	struct output_interface{
	protected:
		///eĂˁBregistOɕKvł΁Å֐ĂłƁB
		virtual bool setFileName(const char *) = 0;
	public:
		///Ϗ֐
		virtual bool output(const char *,...) = 0;
		virtual bool output(const std::string &) = 0;
	};

private:
	typedef dkutil::map_ex<int,output_interface *> MAP_TYPE;
	MAP_TYPE mMap;
	ansi_rand mARand;
	///܂łȂ
	postscript_string mOutStr;
	///łɏ񂾕
	postscript_string mOutedStr;
	void add_str(const char *s){
		/*size_t len = strlen(s);
		if('\n' == s[len]){
			s[len] = '\0';
		}*/
		mOutStr.add_str(s);
	}
	void ClearOutedStr(){mOutedStr.clear();}

protected:
	postscript_string &getOutedStr(){return mOutedStr;}
public:
	outputer(){}
	virtual ~outputer(){}
	
	
	bool regist(output_interface *ptr){
		bool flag = false;
		for(int i=0;i<INT_MAX;i++){
			if(true==mMap.SetData(mARand.rand(),ptr)){
				break;
				flag = true;
			}
		}
		return flag;
	}
	bool regist(int priority,output_interface *ptr){
		return mMap.SetData(priority,ptr);
	}
	void put(const char *s){
		add_str(s);	
	}
	///܂œŕێĂiterate_outŏo͂B
	void out();
	///܂œo^(regist)Ăo͊֐ɕo͂B
	void iterate_out(const std::string &s){
		MAP_TYPE::iterator it = mMap.begin();
		for(;it != mMap.end();it++)
		{
			(*it).second->output(s);
		}
	}
	void iterate_out(const char *s){
		MAP_TYPE::iterator it = mMap.begin();
		for(;it != mMap.end();it++)
		{
			(*it).second->output(s);
		}
	}
	friend dumper;
};

///FfҁAҁ@Rs[^Fij_v
class dumper{
private:
	std::string mFileName;
public:
	dumper(const char *filename=NULL){
		//mFileName = filename;
		setFileName(filename);
	}
	virtual ~dumper(){}
	void setFileName(const char *filename){
		if(!filename) return;
		mFileName = filename;
	}

	///@return 肭AׂĂ߂TRUE
	virtual bool ToTextFile(const std::string &my);
	///@see ToTextFile(const std::string &my)
	virtual bool ToTextFile(outputer &ou){
		return ToTextFile(ou.getOutedStr());
	}
	//@see Windowɏo
	/*virtual bool ToWindow(const std::string &){

	}*/



};


namespace policy{

class console : public outputer::output_interface{
};
class ods: public outputer::output_interface{
};
class debug_window: public outputer::output_interface{
};


}//end of policy namespace


class HTMLLog{
protected:
	std::string m_name;
	int m_exSize;

	/**	OJn
		Oo͂̊Jn܂B
	*/
	bool LogoutStart(char *titlename)
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return false;

		fprintf( fp,
			"<HTML>\n"
			"<HEAD>\n"
			"<META http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\">\n"
			"<TITLE>%s</TITLE>\n"
			"<STYLE type=\"text/css\">\n"
			"<!--\n"
			"BODY{\n"
			"  font-size : 12px;\n"
			"  font-family : \"lr SVbN\";\n"
			"}\n"
			"-->\n"
			"</STYLE>\n"
			"</HEAD>\n"
			"<BODY bgcolor=\"#ffffff\" text=\"#000000\" link=\"#444444\" vlink=\"#444444\" alink=\"#444444\">\n",
			titlename );

		fclose( fp );
		return true;
	}

	/**	OI
		Oo͂̏I܂B
	*/

	bool LogoutEnd()
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return false;

		fprintf( fp,
			"</BODY>\n"
			"</HTML>\n" );

		fclose( fp );
		return true;
	}

public:
	///@param logfiletitle[in] HTMLOt@C̃^Cgw肵ĂB
	///@param fullpathname[in] t@CpX̓tpXwŌ肢܂B
	HTMLLog(char *logfiletitle="DebugLog",char *fullpathname = "debuglog.html")
	{
		m_name = fullpathname;
		m_exSize = MAX_PATH;
		LogoutStart(logfiletitle);
	}
	virtual ~HTMLLog()
	{
		LogoutEnd();
	}
	//eAg\̕ǂ邩Bi܂ĂȂB
	void SetExtensionStringSize(int size){
		m_exSize = size;
	}

	///@param name[in] t@C͐UpXwŌ肢܂B
	void SetLogFileName(char *name){		m_name = name;	}
	char *GetLogFileName(){return const_cast<char *>(m_name.c_str());}

	/**	Oo̓JeS[
		Oo͂JeS[p̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutMainCategory( char *pStr )
	{


		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp,
			"<TABLE width=\"100%%\" bgcolor=\"#000000\">\n"
			"  <TBODY>\n"
			"    <TR>\n"
			"      <TD align=\"center\">\n"
			"        <B>\n"
			"          <FONT color=\"WHITE\">" );

		vfprintf( fp, pStr, (char*)(&pStr + 1) );

		fprintf( fp,
			"</FONT>\n"
			"        </B>\n"
			"      </TD>\n"
			"    </TR>\n"
			"  </TBODY>\n"
			"</TABLE>\n" );

		fclose( fp );
	}
	/**	Oo̓L[[h
		Oo͂L[[hp̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutKeyword( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<B><FONT color=\"BLUE\">" );
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</FONT></B>" );

		fclose( fp );
	}
	/**	Oo̓G[
		Oo͂G[p̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutError( char *pStr,... )
	{
		
		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;
		//bool f;
		//char *str;
		//BEGIN_GET_MANY_ARG(f,str,m_exSize,pStr);
		//if(f==false) return;
		fprintf( fp, "<B><FONT color=\"RED\">" );
		//fprintf( fp, str);
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</FONT></B>" );
		//END_GET_MANY_ARG(str);
		fclose( fp );
	}

	/**	Oo͂nj
		Oo͂njp̐Fŏ܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutOK( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<B><FONT color=\"GREEN\">" );
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</FONT></B>" );

		fclose( fp );
	}

	/**	Oo͑
		Oo͂𑾎ōs܂B
		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void LogoutStrong( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<B>" );
		vfprintf( fp, pStr, (char*)(&pStr + 1) );
		fprintf( fp, "</B>" );

		fclose( fp );
	}

	/*!	Oo<BR>
		Oo͂܂B

		@param pStr		[in] `敶iprintf()Ɠl̏j
	*/
	void Logout( char *pStr,... )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		vfprintf( fp, pStr, (char*)(&pStr + 1) );

		fclose( fp );
	}
	/*!	Os<BR>
		Oo͂̉s܂B
	*/
	void LogoutNextLine( void )
	{

		FILE *fp = fopen( GetLogFileName(), "at" );
		if ( fp == NULL ) return;

		fprintf( fp, "<BR>\n" );

		fclose( fp );
	}

};
#if !defined(__GNUG__)
class HTMLLogFactory{
public:
	typedef array_onebyone_ex<HTMLLog> CONTAINER_TYPE;
	typedef CONTAINER_TYPE::handle handle;
	typedef CONTAINER_TYPE::size_type size_type;
	typedef CONTAINER_TYPE::reference reference_type;
protected:
	CONTAINER_TYPE m_c;
public:
	HTMLLogFactory(){}
	virtual ~HTMLLogFactory(){}
	handle Construct(char *title,char *filefullpath){ 
		return m_c.push(HTMLLog(title,filefullpath));
	}
	void Destroy(handle h){
		m_c.pop(h);
	}
	HTMLLog &Reference(handle h){
		return m_c.at(h);
	}
	size_type size(){	return m_c.size();}
};
#endif

void outputer::out(){
	PARSE_STRING_CONTAINER c;
	const char sep[]={'\n','\0'};
	ParseString(c,sep,mOutStr.c_str(),mOutStr.size(),true);
	PARSE_STRING_CONTAINER::iterator it=c.begin();
	for(;it != c.end();it++){
		iterate_out((*it));
	}
	//AEgvbgۑB
	mOutedStr.add_str(mOutStr);
	//AEgvbg炠Ƃ̓NA`
	mOutStr.clear();
}


bool dumper::ToTextFile(const std::string &my)
{
	if(mFileName.empty()) return false;
	file_operator file(mFileName.c_str(),
		"at");
	size_t tmp = 0;
	file.open();
	tmp = file.write(my.c_str(),my.size());
	file.close();
	return (tmp == my.size());
}
/*
void HTMLLogTest(){
#	ifdef USE_DKINGYO_OBJECT_TEST
	HTMLLogFactory f;
	char *titlename="HTMLLogTest Debug";
	char *filefullpath="HTMLLogTestReport.html";
	typedef HTMLLogFactory::handle handle;
	typedef HTMLLogFactory::reference_type r_type;
	//B
	handle h = f.Construct(titlename,filefullpath);
	//QƂĂǂA
	f.Reference(h).LogoutMainCategory("HTMLLogTest");
	
	//̂悤Ƀt@X擾ĂƖʓ|ȕ
	r_type ref = f.Reference(h);
	ref.Logout("Directory of Windows is %s",GetWindowsDirReturnCharPtr());

	ref.LogoutStrong("ł܂OO");
	ref.LogoutStrong("<font size=10>s鎞LogoutNextLine();ĂяoĂˁOO</font>");
	ref.LogoutNextLine();
	ref.LogoutError("G[̎@F");
	ref.LogoutOK("OKȎ@F");

	ref.LogoutKeyword("KeywordF");
	ref.LogoutNextLine();
	ref.Logout("AOo͂鎞̓^OOKłOOł``ił́A悤Ȃ̗j");
	//ʂɌnȂĂOK HTMLLogFactoryŏIɊJĂ̂
	f.Destroy(h);
#	else
	ODS("Please use USE_DKINGYO_OBJECT_TEST \n");
#endif
}*/
//extern void HTMLLogTest();

/*	
inline bool GetVersionInfoForProgrammer(std::string &s){
	char buff[1024]="";
	GetVersionInfo v;

	const int num = 
	const char *dllname[num]={
		"KERNEL32.DLL",
		"AVIFIL32.DLL",
		"MSVFW32.DLL",
		"COMCTL32.DLL",
		"MSVCRT.dll",
		"OLEPRO32.dll",
		"OLEAUT32.dll",
		"MSHTML.dll",
	}
	s += 

}
*/

#endif //end of if 0

}//end of dkutil namespace



#endif //end of include once

	
