#include <dkutil/parser/ini.hpp>
#include <dkutil/parser/spirit_ini_definition.hpp>

namespace dkutil{
CINIParser::CINIParser(const char *filename){
	mObj = NULL;
	mObj = (void *)new INIManager;
	if(NULL==mObj){
		return;
	}
	reset(filename);
}

CINIParser::~CINIParser(){
	INIManager *p = (INIManager *)mObj;
	delete p;
}

void CINIParser::clear(){
	if(good()){
			INIManager *p = (INIManager *)mObj;
		p->clear();
	}
}
bool CINIParser::reset(const char *filename){
	INIManager *p = (INIManager *)mObj;
	if(NULL == p){
		return false;
	}
	return p->reset(filename);
}
bool CINIParser::good()const{
	if(NULL == mObj){
		return false;
	}
	INIManager *p = (INIManager *)mObj;
	return ( !p->empty() );
}
int CINIParser::find_ex(const char *section,const char *key,GeneralPurposeVariable *value,
												UINT option)
{
	//INIManager *p = mObj;
	return find(section,key,value);
}
int CINIParser::find(const char *section,const char *key,GeneralPurposeVariable *value)
{
		INIManager *p = (INIManager *)mObj;
	typedef dkutil::INIManager INIM;
	int result = not_found_section;
	
	INIM::const_section_iterator sit;
	
	sit = p->find_section(section);
	if(p->end() == sit){
		return result;
	}
	//߂l̊iグ
	result = not_found_key;

	INIM::const_key_iterator kit;
	kit = p->find_key_from_found_section(sit,key);
	if(kit == (*sit).second.end()){
		return result;
	}

	result = found;

	if(NULL==value){
		return error;
	}

	*value = (*kit).second.Data;
	
	return result;

	/*
	for(INIM::const_section_iterator it=m.begin();it!=m.end();it++)
	{
		result = not_found_key;
		//dODS("[%s]",(*it).first.c_str());
		for(INIM::const_key_iterator kit=(*it).second.begin();
			kit!=(*it).second.end();
			kit++)
		{
			*value = (*kit).second.Data;
			//dODSNoNewLine("%s = ",(*kit).first.c_str());
			//(*kit).second.Data.print();
		}
	}
	*/
}

}//eon