
/**
@file string_printf.hpp
@brief std::stringprintf悤ȓz

 */
#ifndef DKUTIL_STRING_PRINTF_HPP
#define DKUTIL_STRING_PRINTF_HPP

#include <string>
#include <dkutil/macro.hpp>
#include <malloc.h>



namespace dkutil{

inline std::string string_nprintf(size_t num,const char *p,...){
	char *t = (char *)malloc(num);
	if(NULL==t){
		throw std::runtime_error("out of memory!!!");
	}
	SET_VA_LIST(t,num,p);
	std::string str(t);
	free(t);
	return str;
}

}
#endif 

