
#ifndef DKUTIL_POLICY_ALLOCATE_HPP
#define DKUTIL_POLICY_ALLOCATE_HPP

#include <dkutil/config.hpp>
#include <dkutil/macro.hpp>
#include <malloc.h>
#ifdef WIN32
#	include <windows.h>
#else

#endif

namespace dkutil{


//S`BundefĂ炢math.
/*#ifdef malloc
#	undef malloc
#endif

#ifdef free
#	undef free
#endif

#ifdef realloc
#	undef realloc
#endif
*/

namespace policy{



struct allocate_policy_malloc{
	typedef allocate_policy_malloc self_type;

	static inline void *malloc(const size_t bytes)
	//void * malloc(const size_t bytes)const
  { 
		void *p = DKUTIL_SAFE_MALLOC(bytes);//::malloc(bytes); 
		if(!p) return NULL;
		memset(p,0,bytes);
		return p; 
	}
	static inline void free(void * block)
	//void free(void * block)const
  { 
		DKUTIL_SAFE_FREE(block);
		//if(block){		free(block);}
	}
	static inline void *realloc(void *block,size_t size){
	//void *realloc(void *block,size_t size)const{
		return (void *)DKUTIL_SAFE_REALLOC(block,size);
		//return (void *)realloc(block,size);
	}
	/*void *operator new(size_t size,self_type x)
	{
		return malloc(size);
	}
	void operator delete(void *p,self_type x){
		free(p);
	}
	void *New(size_t size)const{
		return new self_type(self_type());
	}
	void Delete(void * block){
		delete(self_type()) block;
	}*/
};

struct allocate_policy_malloc_uninitialize_block{
	typedef allocate_policy_malloc_uninitialize_block self_type;
	static inline void *malloc(size_t bytes)
  { 
		return DKUTIL_SAFE_MALLOC(bytes); 
		//return malloc(bytes);
	}
	
	static inline void free(void * block)
  { 
		DKUTIL_SAFE_FREE(block);
		//if(block){	free(block);}
	}
	static inline void *realloc(void *block,size_t size)
	{
		return (void *)DKUTIL_SAFE_REALLOC(block,size);
		//return (void *)realloc(block,size);
	}

};
#ifdef WIN32

struct allocate_policy_globalalloc{
	void * malloc(const size_t bytes)const
  { return ::GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT,bytes); }

	void free(void * block)const
  { 
		if(block){
			::GlobalFree(block);
		}
	}
	void *realloc(void *block,size_t size)const{
		if(block){
			return (void *)::GlobalReAlloc(block,size,NULL);//킩ȂONULL^^G
		}else{
			return malloc(size);
		}
	}

};
#endif
#if 0 



//^uAgȂBłڂĂBDxExŎgH
///< ACg}N
#define ALIGNED(N1,N2)			(((N1)+((N2)-1))&(~((N2)-1)))	


struct allocate_policy_virtualalloc{
	///< VirtuakAllocm
	void * malloc(const size_t Size)const
  {
		void *pData = ::VirtualAlloc( NULL, ALIGNED(Size,4096), MEM_COMMIT, PAGE_READWRITE );
		::FillMemory(pData,Size,0x00)
		return pData;
	}
	///< VirtualAllocJ
	void free(void * P)const
  { 
		if ( (P) != NULL ) {
			::VirtualFree( (P), 0, MEM_RELEASE ); (P) = NULL; 
		}	

	}
/*	void *realloc(void *block,size_t size)const{
		if(block){
			return (void *)::GlobalReAlloc(block,size,NULL);//킩ȂONULL^^G
		}else{
			return malloc(size);
		}
	}
*/
};
#undef ALIGNED

#endif

/*!
C^[tFCXʂɂČƁB݊̂߂Ȃ񂾁B
*/
	#if 0
///yaneSDK3rdyaneAllocator.h̃AP[^[C^[tFCXƌ݊^^;(Ǝv)
template<class IMPL>
class AllocatorInterface{
public:
	typedef std::size_t size_type;
  typedef std::ptrdiff_t difference_type;
private:
	IMPL ma;
public:
	/*///@return 0ɏ̈ւ̃|C^Ԃ
	BYTE *Alloc(int size)const{
		return ma.malloc(size);
	}
	///GlobalFreegpAlloc()Ŋmۂ̈J
	void Free(BYTE *pb)const{
		ma.free(pb);
	}
	BYTE* ReAlloc(BYTE *ptr,int size)const{
		return (BYTE *)ma.realloc(ptr,size);
	}

	///@return 0ɏ̈ւ̃|C^Ԃ Alloc()Ɠ
	char * malloc(const size_type bytes)const
  { return (char *)ma.malloc(bytes); }
  ///mallocŊmۂ̂J Free()ƓB
	void free(char * const block)const
  { ma.free(block); }

	char *realloc(char *block,size_type size)const{
		return (char *)ma.realloc((void *)block,size);
	}*/
		///@return 0ɏ̈ւ̃|C^Ԃ
	static BYTE *Alloc(int size){
		return ma.malloc(size);
	}
	///GlobalFreegpAlloc()Ŋmۂ̈J
	static void Free(BYTE *pb){
		ma.free(pb);
	}
	static BYTE* ReAlloc(BYTE *ptr,int size){
		return (BYTE *)ma.realloc(ptr,size);
	}

	///@return 0ɏ̈ւ̃|C^Ԃ Alloc()Ɠ
	static char * malloc(const size_type bytes)
  { 
		return (char *)ma.malloc(bytes); 
	}
  ///mallocŊmۂ̂J Free()ƓB
	static void free(char * const block)
  {
		ma.free(block); 
	}

	static char *realloc(char *block,size_type size){
		return (char *)ma.realloc((void *)block,size);
	}
};


typedef AllocatorInterface<allocate_policy_globalalloc> globalalloc_allocator;
typedef AllocatorInterface<allocate_policy_malloc> malloc_allocator; 
#endif

/*

class default_reference_allocator : public reference_allocator_interface{
	allocate_policy_malloc mA;
public:
	default_reference_allocator(){
	}
	///MainNewg
	virtual void *New(size_t s)const{
		return new BYTE[s];
		}
	///MainDeleteg
	virtual void Delete(void *p)const{
		delete [] (BYTE *)p;
	}
	///Mainmalloc(n)g
	virtual void *Allocate(size_t size)const{
		return mA.malloc(size);
		}

	///Mainfree(n)g
	virtual void Free(void *p)const {
		mA.free(p);
		}
	///Mainrealloc(n)g
	virtual void *Reallocate(void *p,size_t size)const {
		return mA.realloc(p,size);
		}
};*/

}//end of policy namespace

}//end of dkutil namespace



#endif
