/*!
@brief OSprocess̗D揇ʓ̏
*/
#ifndef DKUTIL_PROCESS_HPP
#define DKUTIL_PROCESS_HPP

#include <dkutil/dkutil_c.hpp>
//#include <dkutil_c/dkcThread.h>
#include <dkutil/synchronized.hpp>
#include <dkutil/boost/noncopyable.hpp>

namespace dkutil{

	class scoped_current_process_priority : public boost::noncopyable{
		int mPriority;
	public:
		///@param prio[in] enum edkcProcessPriority
		scoped_current_process_priority(int prio){
			::dkcGetCurrentProcessPriority(&mPriority);
			::dkcSetCurrentProcessPriority(prio);
		}
		~scoped_current_process_priority(){
			::dkcSetCurrentProcessPriority(mPriority);
		}
	};
	
	class scoped_current_thread_priority : public boost::noncopyable{
		int mPriority;
	public:
		///@param prio[in] enum edkcThreadPriority
		scoped_current_thread_priority(int prio){
			::dkcGetCurrentThreadPriority(&mPriority);
			::dkcSetCurrentThreadPriority(prio);
		}
		~scoped_current_thread_priority(){
			::dkcSetCurrentThreadPriority(mPriority);
		}
	};
	///Current ThreadSɃA^CԂɂBCPU̓ƐԂɂB
	class realtime_lock : public scoped_current_thread_priority ,
		public scoped_current_process_priority,
		public synchronized
	{
		public:
		///@todo edkcThreadPriorityTimeCriticalŗǂǂȂB
		realtime_lock() : 
			scoped_current_thread_priority(edkcThreadPriorityTimeCritical) ,
		scoped_current_process_priority(edkcProcessPriorityRealTime)
		{
			
			
		}
		~realtime_lock(){}
		
	};

}//end of dkutil namespace



#endif