
#ifndef DKUTIL_SCOPED_ARRAY_EX_HPP
#define DKUTIL_SCOPED_ARRAY_EX_HPP

#include <dkutil/macro.hpp>
#include <dkutil/boost/scoped_array.hpp>


namespace dkutil{

/**
boost::scoped_arraybytePʂ̃TCYŤL^łł悤ɂNXł
*/
template<class T>
class scoped_array_ex : public boost::scoped_array<T>{
public:
	typedef scoped_array_ex<T> self_type;
	typedef boost::scoped_array<T> base_type;
	typedef T element_type;
private:
	size_t msize;
	size_t mnum;
public:
	scoped_array_ex(){
		msize = 0;
		mnum = 0;
	}
	scoped_array_ex(size_t num){
		msize = 0;
		mnum = 0;
		reset(num);
	}
	///Tnummۂ܂B
	void reset(size_t num){
		base_type::reset(new T[num]);
		msize = sizeof(T) * num;
		mnum = num;
	}
	///ێĂ郁J܂B
	void clear(){
		base_type::reset();
		msize = 0;
		mnum = 0;
	}
	///ێĂ郁bytePʂ̃TCYԂ܂B
	size_t size()const{
		return msize;
	}
	///ŤԂ܂B
	size_t num()const{
		return mnum;
	}
};

}//end of dkutil namespace



#endif