
#ifndef DKUTIL_SIGNATURE_BASE_HPP
#define DKUTIL_SIGNATURE_BASE_HPP

#include <dkutil/signature/interface.hpp>
#include <dkutil/filesystem/big_filestream.hpp>

namespace dkutil{
class ISignature_Base : public ISignature{
public:
	virtual ~ISignature_Base(){}

	class signature_load_functor{
		ISignature_Base *mp;
	public:
		signature_load_functor(ISignature_Base *p){
			mp = p;
		}
		inline void operator()(const BYTE *buff,size_t size){
			mp->load(buff,size);
		}
	};

	virtual bool FileToSignature(const char *filename,BYTE *buff,size_t buffsize,
		int flag,size_t innerbuffsize = 1024 * 512)
	{
		big_filestream fs(filename,read_mode | binary_mode);
		

		if(false==fs.open()){
			return false;
		}
		
		init();
		
		signature_load_functor functor(this);

		div_read_each_functor<big_filestream,signature_load_functor> div_read_each;
		div_read_each(&fs,functor,innerbuffsize);
		
		final();

		return getSignature(buff,buffsize,flag);
	}

	virtual bool MemoryToSignature(const BYTE *src,size_t srcsize,BYTE *dest,size_t destsize,int flag)
	{
		init();
		load(src,srcsize);
		final();
		return getSignature(dest,destsize,flag);
	}
	
	
};

}//end of dkutil namespace



#endif//end of include once

