
#ifndef DKUTIL_SIGNATURE_INTERFACE_HPP
#define DKUTIL_SIGNATURE_INTERFACE_HPP

#include <dkutil/detail/stream_interface.hpp>
#include <dkutil/filesystem/interface.hpp>
#include <dkutil/utility.hpp>
#include <string>

namespace dkutil{


enum{
	///̃VOl`o͂Ƃ
	string_signature = text_mode,
	///oCĩVOl`o͂Ƃ
	binary_signature = binary_mode,
};


struct signature_error : public std::runtime_error{
	signature_error (const char *p) : std::runtime_error(p){}
	signature_error (const std::string &p) : std::runtime_error(p){}
};

///VOl`o̓C^[tFCX
class ISignature{
public:
	virtual void init() = 0;
	virtual void load(const BYTE *,size_t size) = 0;
	virtual void final() = 0;
	virtual bool getSignature(BYTE *,size_t size,int flag) = 0;
	//virtual bool getBinarySignature(BYTE *,size_t size) = 0;
	//virtual bool getStringSignature(char *,size_t buffsize) = 0;
	///
	virtual size_t getOutputSize(int flag)const = 0;
	//virtual size_t getStringOutputSize()const = 0;

	//virtual bool FileToSignature(const char *filename,BYTE *buff,size_t buffsize,int flag,size_t innerbuffsize = 1024 * 512) = 0;
	//virtual bool MemoryToSignature(const BYTE *src,size_t srcsize,BYTE *dest,size_t destsize,int flag) = 0;
	
};

class CSignatureLoadStreamAction : public IStreamAction{
	ISignature *mps;
public:
	BOOST_STATIC_CONSTANT(bool,is_read = false);
	CSignatureLoadStreamAction(ISignature *ps){
		mps = ps;
	}
	virtual bool action(uint8 *pd,size_t size){
		mps->load(pd,size);
		return true;
	}
};


}//end of dkutil namespace



#endif//end of include once

