
#ifndef DKUTIL_SIGNATURE_MD2_HPP
#define DKUTIL_SIGNATURE_MD2_HPP

#include <dkutil_c/dkcMD2.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CMD2 : public ISignature_Base{
private:
	DKC_MD2 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = MD2_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = MD2_STR_BUFFER_SIZE);
	CMD2(){
		init();
	}
	virtual void init(){
		dkcMD2Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcMD2Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcMD2Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcMD2Digest(&mH,buffer,size);
		}else{
			r = dkcMD2DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return MD2_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return MD2_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return MD2_STR_BUFFER_SIZE;
	}*/
};

}//end of dkutil namespace



#endif