
#ifndef DKUTIL_SIGNATURE_MD4_HPP
#define DKUTIL_SIGNATURE_MD4_HPP

#include <dkutil_c/dkcMD4.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CMD4 : public ISignature_Base{
private:
	DKC_MD4 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = MD4_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = MD4_STR_BUFFER_SIZE);
	CMD4(){
		init();
	}
	virtual void init(){
		dkcMD4Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcMD4Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcMD4Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcMD4Digest(&mH,buffer,size);
		}else{
			r = dkcMD4DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return MD4_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return MD4_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return MD4_STR_BUFFER_SIZE;
	}*/
};

}//end of dkutil namespace



#endif