
#ifndef DKUTIL_SIGNATURE_MD5_HPP
#define DKUTIL_SIGNATURE_MD5_HPP

#include <dkutil_c/dkcMD5.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CMD5 : public ISignature_Base{
private:
	DKC_MD5 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = MD5_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = MD5_STR_BUFFER_SIZE);
	CMD5(){
		init();
	}
	DKC_MD5 *getObj(){
		return &mH;
	}
	virtual void init(){
		dkcMD5Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcMD5Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcMD5Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcMD5Digest(&mH,buffer,size);
		}else{
			r = dkcMD5DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return MD5_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return MD5_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return MD5_STR_BUFFER_SIZE;
	}*/
};

}//end of dkutil namespace



#endif