
#ifndef DKUTIL_SIGNATURE_RIPEMD_HPP
#define DKUTIL_SIGNATURE_RIPEMD_HPP

#include <dkutil_c/dkcRIPEMD.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CRIPEMD128 : public ISignature_Base{
private:
	DKC_RIPEMD128 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = RIPEMD128_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = RIPEMD128_STR_BUFFER_SIZE);
	CRIPEMD128(){
		init();
	}
	DKC_RIPEMD128 *getObj(){
		return &mH;
	}
	virtual void init(){
		dkcRIPEMD128Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcRIPEMD128Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcRIPEMD128Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcRIPEMD128Digest(&mH,buffer,size);
		}else{
			r = dkcRIPEMD128DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return RIPEMD128_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return RIPEMD128_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return RIPEMD128_STR_BUFFER_SIZE;
	}*/
};

class CRIPEMD256 : public ISignature_Base{
private:
	DKC_RIPEMD256 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = RIPEMD256_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = RIPEMD256_STR_BUFFER_SIZE);
	CRIPEMD256(){
		init();
	}
	DKC_RIPEMD256 *getObj(){
		return &mH;
	}
	virtual void init(){
		dkcRIPEMD256Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcRIPEMD256Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcRIPEMD256Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcRIPEMD256Digest(&mH,buffer,size);
		}else{
			r = dkcRIPEMD256DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return RIPEMD256_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return RIPEMD256_STR_BUFFER_SIZE;
		}
	}

};
	
class CRIPEMD160 : public ISignature_Base{
private:
	DKC_RIPEMD160 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = RIPEMD160_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = RIPEMD160_STR_BUFFER_SIZE);
	CRIPEMD160(){
		init();
	}
	DKC_RIPEMD160 *getObj(){
		return &mH;
	}
	virtual void init(){
		dkcRIPEMD160Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcRIPEMD160Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcRIPEMD160Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcRIPEMD160Digest(&mH,buffer,size);
		}else{
			r = dkcRIPEMD160DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return RIPEMD160_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return RIPEMD160_STR_BUFFER_SIZE;
		}
	}

};
	
	
class CRIPEMD320 : public ISignature_Base{
private:
	DKC_RIPEMD320 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = RIPEMD320_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = RIPEMD320_STR_BUFFER_SIZE);
	CRIPEMD320(){
		init();
	}
	DKC_RIPEMD320 *getObj(){
		return &mH;
	}
	virtual void init(){
		dkcRIPEMD320Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcRIPEMD320Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcRIPEMD320Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcRIPEMD320Digest(&mH,buffer,size);
		}else{
			r = dkcRIPEMD320DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return RIPEMD320_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return RIPEMD320_STR_BUFFER_SIZE;
		}
	}

};
	
}//end of dkutil namespace



#endif