
#ifndef DKUTIL_SIGNATURE_SHA1_HPP
#define DKUTIL_SIGNATURE_SHA1_HPP

#include <dkutil_c/dkcSHA1.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CSHA1 : public ISignature_Base{
private:
	DKC_SHA1 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = SHA1_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = SHA1_STR_BUFFER_SIZE);
	CSHA1(){
		init();
	}
	virtual void init(){
		dkcSHA1Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcSHA1Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcSHA1Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcSHA1Digest(&mH,buffer,size);
		}else{
			r = dkcSHA1DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return SHA1_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return SHA1_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return SHA1_STR_BUFFER_SIZE;
	}*/
};
///SHA1160bit̒l𐶐邩
typedef CSHA1 CSHA160;

}//end of dkutil namespace



#endif