
#ifndef DKUTIL_SIGNATURE_SHA256_HPP
#define DKUTIL_SIGNATURE_SHA256_HPP

#include <dkutil_c/dkcSHA256.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CSHA256 : public ISignature_Base{
private:
	DKC_SHA256 mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = SHA256_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = SHA256_STR_BUFFER_SIZE);
	CSHA256(){
		init();
	}
	virtual void init(){
		dkcSHA256Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcSHA256Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcSHA256Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcSHA256Digest(&mH,buffer,size);
		}else{
			r = dkcSHA256DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return SHA256_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return SHA256_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return SHA256_STR_BUFFER_SIZE;
	}*/
};

}//end of dkutil namespace



#endif