
#ifndef DKUTIL_SIGNATURE_SHA384_HPP
#define DKUTIL_SIGNATURE_SHA384_HPP

#include <dkutil_c/dkcSHA384.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CSHA384 : public ISignature_Base{
private:
	DKC_SHA384 mH;
public:

	BOOST_STATIC_CONSTANT(size_t,bin_size = SHA384_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = SHA384_STR_BUFFER_SIZE);
	CSHA384(){
		init();
	}
	virtual void init(){
		dkcSHA384Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcSHA384Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcSHA384Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcSHA384Digest(&mH,buffer,size);
		}else{
			r = dkcSHA384DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return SHA384_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return SHA384_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return SHA384_STR_BUFFER_SIZE;
	}*/
};

}//end of dkutil namespace



#endif