
#ifndef DKUTIL_SIGNATURE_SHA512_HPP
#define DKUTIL_SIGNATURE_SHA512_HPP

#include <dkutil_c/dkcSHA512.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CSHA512 : public ISignature_Base{
private:
	DKC_SHA512 mH;
public:

	BOOST_STATIC_CONSTANT(size_t,bin_size = SHA512_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = SHA512_STR_BUFFER_SIZE);
	CSHA512(){
		init();
	}
	virtual void init(){
		dkcSHA512Init(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcSHA512Load(&mH,buffer,size);
	}
	virtual void final(){
		dkcSHA512Final(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcSHA512Digest(&mH,buffer,size);
		}else{
			r = dkcSHA512DigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return SHA512_BIN_BUFFER_SIZE;
		}else{ //if(string_signature
			return SHA512_STR_BUFFER_SIZE;
		}
	}
	/*virtual size_t getStringOutputSize()const{
		return SHA512_STR_BUFFER_SIZE;
	}*/
};

}//end of dkutil namespace



#endif