
#ifndef DKUTIL_SIGNATURE_Whirlpool_HPP
#define DKUTIL_SIGNATURE_Whirlpool_HPP

#include <dkutil_c/dkcWhirlpool.h>
#include <dkutil/signature/base.hpp>

namespace dkutil{

class CWhirlpool : public ISignature_Base{
private:
	DKC_WHIRLPOOL mH;
public:
	BOOST_STATIC_CONSTANT(size_t,bin_size = WHIRLPOOL_BIN_BUFFER_SIZE);
	BOOST_STATIC_CONSTANT(size_t,str_size = WHIRLPOOL_STR_BUFFER_SIZE);
	CWhirlpool(){
		init();
	}
	DKC_WHIRLPOOL *getObj(){
		return &mH;
	}
	virtual void init(){
		dkcWhirlpoolInit(&mH);
	}
	virtual void load(const BYTE *buffer,size_t size){
		dkcWhirlpoolLoad(&mH,buffer,size);
	}
	virtual void final(){
		dkcWhirlpoolFinal(&mH);
	}
	virtual bool getSignature(BYTE *buffer,size_t size,int flag){
		int r;
		if(binary_signature == flag){
			r = dkcWhirlpoolDigest(&mH,buffer,size);
		}else{
			r = dkcWhirlpoolDigestStr(&mH,(char *)buffer,size);
		}
		return DKUTIL_SUCCEEDED_BOOL(r);
	}
	virtual size_t getOutputSize(int flag)const{
		if(binary_signature == flag){
			return bin_size;
		}else{ //if(string_signature
			return str_size;
		}
	}
};

}//end of dkutil namespace



#endif