
#ifndef DKUTIL_UTILITY_HPP
#define DKUTIL_UTILITY_HPP

#include <dkutil/macro.hpp>
#include <dkutil/config.hpp>

//stl
#include <stdexcept>
#	include <string>
#	include <deque>
#	include <map>
#	include <list>
#	include <set>
#	include <vector>
#	include <stack>
#	include <queue>
#	include <algorithm>
#	include <iterator>
#	include <functional>

#	ifdef DKUTIL_STDLIB_STLPORT
#		include <hash_map>
#		include <hash_set>
#	endif

//STLPort̃nbVn̂̂Ɏ􂢂ĂOOG
#ifdef DKUTIL_STDLIB_STLPORT
#	define DKUTIL_HASHMAP std::hash_map
#	define DKUTIL_HASHSET std::hash_set
#else
#	define DKUTIL_HASHMAP std::map
#	define DKUTIL_HASHSET std::set
#	undef std
#endif

//static container
#include <static_container/vector.h>
#include <static_container/list.h>
#include <static_container/string.h>
#include <static_container/lodge_list.h>
#include <static_container/hash.h>
#include <static_container/list_hash.h>

namespace dkutil{




}//end of dkutil namespace



#endif