unit dmsh;

(*
  DMonkey Script Host

  History:
  2005/07/23
    ERpCς݃oCisgpIvV(-b)

  2005/06/24
    E_CAÕtB^𑝂₵

  2003/10/21
    Eoߎԏo̓IvV(-t)

  2003/04/09
    EAllocConsole(IvV -c)

  2002/12/26
    EGWo[W0.2.0.1
    EhelpNIvV
    EJgfBNgύX
    Et@C݂Ȃ̓_CAOJ悤ɂ
    EWo͂ɁARpCAsԏǉ
    E̎dldm.exeɍ킹ĕύXB
    Eo[WGWƓ
    Eargumentsɂ̓p[^̂݊i[

  2002/11/23
    EDMonkey0.1.7ō蒼B
    EWo͂t@Cɓf悤ɂB
    Eecma_guiobjectQƂȂ悤ɂB
*)


interface


uses
  Windows, Classes, SysUtils, Forms, Dialogs, ShellAPI,
  dmonkey, ecma_type, ecma_misc;

type
  TDMSH = class(TObject)
  private
    FDM: TDMonkey;
    FStdout: string;
    FLogout: Boolean;
    procedure DMStdout(Sender: TObject; S: string);
    procedure DMStderr(Sender: TObject; S: string);
    function OpenFile: string;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Run;
  end;


implementation


{ TDMSH }

constructor TDMSH.Create;
begin
  inherited Create;
  FDM := TDMonkey.Create(nil);
  FDM.CompiledBinary := True;
  FDM.OnStdout := DMStdout;
  FDM.OnStderr := DMStderr;
end;

destructor TDMSH.Destroy;
begin
  FDM.Free;
  inherited;
end;

procedure TDMSH.DMStdout(Sender: TObject; S: string);
begin
  FLogout := True;
  FStdout := FStdout + S;
end;

procedure TDMSH.DMStderr(Sender: TObject; S: string);
begin
  ShowDMonkeyException(Sender as TDMonkey);
end;

function TDMSH.OpenFile: string;
var
  dlg: TOpenDialog;
begin
  Result := '';
  dlg := TOpenDialog.Create(nil);
  try
    dlg.Filter := 'DMonkey File (*' + DMS_EXT + ';*' + DMS_COMPILED_EXT + ')|*' + DMS_EXT + ';*' + DMS_COMPILED_EXT +
                  '|DMonkey Script File (*' + DMS_EXT + ')|*' + DMS_EXT +
                  '|DMonkey Compiled Script File (*' + DMS_COMPILED_EXT + ')|*' + DMS_COMPILED_EXT +
                  '|ׂẴt@C (*.*)|*.*';
    if dlg.Execute then
      Result := dlg.FileName;
  finally
    dlg.Free;
  end;
end;

procedure TDMSH.Run;
var
  prm: TJValueList;
  src,hlp,opt: string;
  sl: TStringList;
  i,opcount: Integer;
  cout,tout: Boolean;
begin
  cout := False;
  tout := False;
  opcount := 0; //NIvV̐

  for i := 1 to ParamCount do
  begin
    opt := ParamStr(i);
    if (Length(opt) > 0) and (opt[1] in ['-','/']) then
    begin
      Inc(opcount);
      opt := Copy(opt,2,MaxInt);
      //helpN
      if (opt = 'help') or (opt = 'h') or (opt = '?') then
      begin
        hlp := ExtractFilePath(ParamStr(0)) + 'dmsref.hlp';
        ShellExecute(0,nil,PChar(hlp),nil,nil,SW_SHOW);
        Exit;
      end
      //consoleo
      else if opt = 'c' then
        cout := True
      //oߎԏo
      else if opt = 't' then
        tout := True
      //RpCς݃oCigpȂ
      else if opt = 'b' then
        FDM.CompiledBinary := False;
    end
    else
      Break;
  end;

  //NIvV̎\[Xt@C
  src := ParamStr(opcount + 1);

  if ExtractFileExt(src) = '' then
    src := src + DMS_EXT;

  if not FileExists(src) then
  begin
    src := OpenFile;
    if not FileExists(src) then Exit;
  end;

  //JgdirύX
  SetCurrentDir(ExtractFileDir(src));

  prm := TJValueList.Create;
  try
    for i := (opcount + 2) to ParamCount do
      prm.Add(BuildString(ParamStr(i)));

    if FDM.CompileFile(src) then
      FDM.Run(prm);
  finally
    prm.Free;
  end;

  if FLogout or tout then
  begin
    if not cout then
    begin
      sl := TStringList.Create;
      try try
        sl.Text := FStdout;
        if tout then
        begin
          sl.Add('---------------------');
          sl.Add('compile: ' + MSecToStr2(FDM.TookTimeToCompile));
          sl.Add('run    : ' + MSecToStr2(FDM.TookTimeToRun));
        end;
        sl.SaveToFile(ChangeFileExt(src, '.log'));
      except
        MsgBox('Ot@C쐬ł܂',
            PChar(Application.Title), MB_OK or MB_ICONHAND);
      end;
      finally
        sl.Free;
      end;
    end
    else begin
      Win32Check(AllocConsole);
      try
        Write(FStdout);
        if tout then
        begin
          Writeln('---------------------');
          Writeln('compile: ' + MSecToStr2(FDM.TookTimeToCompile));
          Writeln('run    : ' + MSecToStr2(FDM.TookTimeToRun));
        end;
        Readln;
      finally
        FreeConsole;
      end;
    end;
  end;
end;

end.
