unit ecma_misc;

interface

//̑낢
//2001/04/25~
//by Wolfy
//

{..$DEFINE MB_NO_OWNER}  //I[i[ȂMessageBoxɂ

uses
  windows,sysutils,classes,regexpr,
{$IFNDEF CONSOLE}
  forms,
{$ENDIF}
  gsocketmisc;

type
  TECMATime = Double;

//t֌W  ECMATime
function SystemTimeToECMATime(SystemTime: TSystemTime): TECMATime;
function ECMATimeToSystemTime(ECMATime: TECMATime): TSystemTime;
function GetLocalTime: TECMATime;
function GetUTCTime: TECMATime;
function DateTimeToECMATime(DateTime: TDateTime): TECMATime;
function ECMATimeToDateTime(ECMATime: TECMATime): TDateTime;
function GetLocalTZA: TECMATime;

//DateTime
function LocalDateTimeToGMT(DateTime: TDateTime): TDateTime;
function GMTToLocalDateTime(DateTime: TDateTime): TDateTime;
function GetTimezone: TDateTime;
function GMTNow: TDateTime;


//t
function DateParse(S: String): TDateTime;

function HexToBitStr(hex : string) : string;
function IntToBitStr(Num: Integer): String;

//bZ[W{bNX
function MsgBox(Text,Caption: String; uType: UINT): Integer; overload;
function MsgBox(Text,Caption: PChar; uType: UINT): Integer; overload;

//AvP[V
function GetApplicationTitle: String;

//_b𕶎
function MSecToStr(MSec: Cardinal): String;
function MSecToStr2(MSec: Cardinal): String;

//bit
const
  BYTE_FLAGS: array[0..7] of Byte =
  (
    1,2,4,8,16,32,64,128
  );

function SetByteFlag(Flags: array of Boolean): Byte;
function GetByteFlag(Flags: Byte; Num: Byte): Boolean;

//}`oCg
function MBCopy(S: String; Index, Count: Integer): string;
procedure MBInsert(Source: string; var S: string; Index: Integer);
procedure MBDelete(var S: string; Index, Count: Integer);
function MBLength(S: String): Integer;
function MBGetCharAt(S: String; Index: Integer): String;
procedure MBSetCharAt(Source: String; var S: String; Index: Integer);
function MBSlice(S: String; Start,Last: Integer): String;
procedure MBReplace(Source: String; var S: String; Start,Last: Integer);
function MBIndexOf(const Substr, S: string; StartIndex: Integer = 1): Integer;
function MBLastIndexOf(const Substr, S: string; StartIndex: Integer = 1): Integer;
function MBReverse(const S: string): String;
//ϊ
function Zenkaku(const Source: string) : string;
function Hankaku(const Source: string) : string;
function Hiragana(const Source: string) : string;
function Katakana(const Source: string) : string;

function ForceDirectories(Dir: string): Boolean;
function DirectoryExists(const Name: string): Boolean;

implementation


const
  UnixDateDelta = 25569;  //1970/01/01
  MSecsPerDay = SecsPerDay * 1000; 

function DateTimeToECMATime(DateTime: TDateTime): TECMATime;
//datetime -> ecma time_t
begin
  Result := Round((DateTime - UnixDateDelta) * MSecsPerDay);
end;

function ECMATimeToDateTime(ECMATime: TECMATime): TDateTime;
//ecma time_t -> datetime
begin
  Result := ECMATime / MSecsPerDay + UnixDateDelta;
end;

function SystemTimeToECMATime(SystemTime: TSystemTime): TECMATime;
//SystemTime -> ECMATime
begin
  Result :=
    DateTimeToECMATime(SystemTimeToDateTime(SystemTime));
end;

function ECMATimeToSystemTime(ECMATime: TECMATime): TSystemTime;
//ECMATime -> SystemTime
begin
  DateTimeToSystemTime(ECMATimeToDateTime(Trunc(ECMATime)),Result);
end;

function GetLocalTime: TECMATime;
var
  time: TSystemTime;
begin
  windows.GetLocalTime(time);
  Result := SystemTimeToECMATime(time);
end;

function GetUTCTime: TECMATime;
var
  time: TSystemTime;
begin
  windows.GetSystemTime(time);
  Result := SystemTimeToECMATime(time);
end;

function GetLocalTZA: TECMATime;
//
begin
  Result := GetLocalTime - GetUTCTime;
end;

function GetTimezone: TDateTime;
//擾
var
  snow: TSystemTime;
begin
  GetSystemTime(snow);
  //
  Result := SystemTimeTodateTime(snow) - Now;
end;

function LocalDateTimeToGMT(DateTime: TDateTime): TDateTime;
//Local to GMT
begin
  Result := DateTime + GetTimezone;
end;

function GMTToLocalDateTime(DateTime: TDateTime): TDateTime;
//GMT -> LocalTime
begin
  Result := DateTime - GetTimezone;
end;

function GMTNow: TDateTime;
//EW
begin
  Result := LocalDateTimeToGMT(Now);
end;

function DateParse(S: String): TDateTime;
//tɕϊ
var
  sl: TStringList;
  y,m,d,ho,mi,se,ms: Word;
begin
  S := Trim(S);
  Result := Now;
  DecodeDate(Result,y,m,d);
  DecodeTime(Result,ho,mi,se,ms);

  try
    Result := StrToDateTime(S);
  except
    //ϊs Dec 31, 1999 23:59:59
    on EConvertError do
    begin
      sl := TStringList.Create;
      try
        SplitRegExpr('[,:\s]+',S,sl);
        try
          y := StrToIntDef(sl[2],y);
          //1Ђ
          m := GetMonth(sl[0]) - 1;
          d := StrToIntDef(sl[1],d);
          ho := StrToIntDef(sl[3],ho);
          mi := StrToIntDef(sl[4],mi);
          se := StrToIntDef(sl[5],se);
          ms := StrToIntDef(sl[6],ms);
        except
          on EStringListError do
        end;

        try
          Result := EncodeDate(y,m,d);
          Result := Result + EncodeTime(ho,mi,se,ms);
        except
          on EConvertError do
        end;

      finally
        sl.Free;
      end;
    end;
  end; //except

end;


function IntToBitStr(Num: Integer): String;
begin
  Result := HexToBitStr(IntToHex(Num,8));
end;

function HexToBitStr(hex : string) : string;
var
  i,d : integer;
  s: String;
const
  bitstr : array[0..21] of string = (
  '0000','0001','0010','0011','0100','0101','0110','0111',
  '1000','1001','1010','1011','1100','1101','1110','1111',
  '1010','1011','1100','1101','1110','1111' );
  hexstr : string = '0123456789abcdefABCDEF';
begin
  Result := '';
  for i:=1 to Length(hex) do begin
    d := Pos(copy(hex,i,1), hexstr);
    if d = 0 then
    begin
      // sFSPACE()
      result := result + '    ';
    end
    else begin
      result := result + bitstr[d-1];
    end;
  end;
  //ŏ0폜
  if Result <> '' then
  begin
    s := '0';  // ׂ'0'Ƃ'0'Ԃ
    for i := 1 to Length(Result) do
      if Result[i] <> '0' then
      begin
        s := Copy(Result,i,MaxInt);
        Break;
      end;

    Result := s;
  end;
end;

function MsgBox(Text,Caption: String; uType: UINT): Integer;
//bZ[W{bNX
begin
  Result := MsgBox(PChar(Text), PChar(Caption), uType);
end;

function MsgBox(Text,Caption: PChar; uType: UINT): Integer;
{$IFNDEF MB_NO_OWNER}
var
  old,app: HWND;
{$ENDIF}
begin
{$IFDEF MB_NO_OWNER}
  Result := MessageBox(0, Text, Caption, uType);
{$ELSE}
  old := GetActiveWindow;
  {$IFNDEF CONSOLE}
    app := Application.Handle;
  {$ELSE}
    app := 0;
  {$ENDIF}

  Result := MessageBox(app,Text,Caption,uType);
  if old <> 0 then
    SetForegroundWindow(old);
{$ENDIF}      
end;    

//AvP[V
function GetApplicationTitle: String;
begin
{$IFNDEF CONSOLE}
  Result := Application.Title;
{$ELSE}
  Result := ChangeFileExt(ExtractFileName(ParamStr(0)),'');
  Result := AnsiUpperCase(Copy(Result,1,1)) + AnsiLowerCase(Copy(Result,2,MaxInt));
{$ENDIF}
end;

function MSecToStr(MSec: Cardinal): String;
//~bԂɕϊstring
var
 h,n,s,tmp: Cardinal;
begin
  if MSec > 0 then
  begin
    tmp := Msec div 1000;

    h := tmp div 3600;
    tmp := tmp mod 3600;
    n := tmp div 60;
    s := tmp mod 60;
  end
  else begin
    h := 0;
    n := 0;
    s := 0;
  end;

  Result := Format('%u:%.2u:%.2u',[h,n,s]);
end;

function MSecToStr2(MSec: Cardinal): String;
//~bԂɕϊstring
var
 h,n,s,tmp: Cardinal;
begin
  if MSec > 0 then
  begin
    tmp := MSec div 1000;
    MSec := MSec mod 1000;

    h := tmp div 3600;
    tmp := tmp mod 3600;
    n := tmp div 60;
    s := tmp mod 60;
  end
  else begin
    h := 0;
    n := 0;
    s := 0;
    MSec := 0;
  end;

  Result := Format('%u:%.2u:%.2u:%.3u',[h,n,s,MSec]);
end;

function SetByteFlag(Flags: array of Boolean): Byte;
//bit flagZbg
var
  i: Integer;
begin
  Result := 0;
  for i := 0 to High(Flags) do
    if Flags[i] then
      Result := Result or BYTE_FLAGS[i];
end;

function GetByteFlag(Flags: Byte; Num: Byte): Boolean;
//bit flag𓾂 0`7
begin
 Result := ((Flags shr Num) and 1) = 1;
end;

function MBCopy(S: String; Index, Count: Integer): string;
//MBRs[
var
  start,last: Integer;
begin
  start := CharToByteIndex(S,Index);
  last := CharToByteIndex(S,Index + Count);
  if last = 0 then
    last := MaxInt;

  Result := Copy(S,start,last - start);
end;

procedure MBInsert(Source: string; var S: string; Index: Integer);
//MB}
begin
  Insert(Source,S,CharToByteIndex(S,Index));
end;

procedure MBDelete(var S: string; Index, Count: Integer);
//MB폜
var
  start,last: Integer;
begin
  start := CharToByteIndex(S,Index);
  last := CharToByteIndex(S,Index + Count);
  if last = 0 then
    last := MaxInt;
    
  Delete(S,start,last - start);
end;

function MBLength(S: String): Integer;
//MB
begin
  Result := ByteToCharLen(S,MaxInt);
end;

function MBGetCharAt(S: String; Index: Integer): String;
//MB s[]
begin
  Result := MBCopy(S,Index,1);
end;

procedure MBSetCharAt(Source: String; var S: String; Index: Integer);
//MB s[] :=
begin
  MBDelete(S,Index,1);
  MBInsert(Source,S,Index);
end;

function MBSlice(S: String; Start,Last: Integer): String;
//Start - (Last - 1)܂łRs[
var
  len: Integer;
begin
  //
  if (Start < 1) or (Last < 1) then
  begin
    len := MBLength(S);
    if Start < 1 then
      Start := len + Start;

    if Last < 1 then
      Last := len + Last;
  end;

  Result := MBCopy(S,Start,Last - Start);
end;

procedure MBReplace(Source: String; var S: String; Start,Last: Integer);
//Start - (Last - 1)܂łu
var
  len: Integer;
begin
  //
  if (Start < 1) or (Last < 1) then
  begin
    len := MBLength(S);
    if Start < 1 then
      Start := len + Start;

    if Last < 1 then
      Last := len + Last;
  end;

  MBDelete(S,Start,Last - Start);
  MBInsert(Source,S,Start);
end;

function MBIndexOf(const Substr, S: string; StartIndex: Integer): Integer;
var
  v: String;
  index: Integer;
begin
  if StartIndex > 1 then
    v := MBCopy(S,StartIndex,MaxInt)
  else
    v := S;
    
  index := ByteToCharIndex(v,AnsiPos(SubStr,v));
  if index = 0 then
    Result := 0
  else
    Result := StartIndex + index - 1;
end;

function MBLastIndexOf(const Substr, S: string; StartIndex: Integer): Integer;
var
  v: String;
  index: Integer;
begin
  if StartIndex > 1 then
    v := MBCopy(S,StartIndex,MaxInt)
  else
    v := S;

  index := MBIndexOf(Substr,MBReverse(v));
  if index = 0 then
    Result := 0
  else
    Result := MBLength(S) - index + 1;
end;

function MBReverse(const S: string): String;
var
  i,j,len: Integer;
  c: Char;
begin
  len := Length(S);
  SetLength(Result,len);
  //tɂ
  j := 1;
  for i := len downto 1 do
  begin
    Result[j] := S[i];
    //ꕶڂȂΓւ
    if ByteType(S,i) = mbLeadByte then
    begin
      try
        c := Result[j];
        Result[j] := Result[j - 1];
        Result[j - 1] := c;
      except
        on EListError do
      end;
    end;
    Inc(j);
  end; 
end;

// LCMapString API̎gp(C)
function MapString(const Source: string; Flag: integer): string;
var
  Chr : array [0..255] of char;
begin
  if Length(Source)<257 then
  begin
    Windows.LCMapString(
      GetUserDefaultLCID(),
      Flag,
      PChar(Source),
      Length(Source) + 1,
      chr,
      Sizeof(chr)
      );
    Result := chr;
  end
  else begin
    Result := Source;
  end;
end;

//pSpɕϊ
function Zenkaku(const Source: string) : string;
var
  i, wl : Cardinal;
  str, strTemp : String;
  WStr: WideString;
begin
  WStr := Source;
  wl := Length(WStr) div 126;
  str := '';
  for i := 1 to wl+1 do
  begin
    strTemp := '';
    strTemp := System.Copy(WStr, i + (i-1) * 126,127);
    str := str + MapString(strTemp, LCMAP_FULLWIDTH);
  end;
  Result := str;
end;

//Sp𔼊pɕϊ
function Hankaku(const Source: string) : string;
var
  i, wl : Cardinal;
  str, strTemp : String;
  WStr : WideString;
begin
  WStr := Source;
  wl := Length(WStr) div 127;
  str := '';
  for i := 1 to wl+1 do
  begin
    strTemp := '';
    strTemp := System.Copy(WStr, i + (i-1) * 127,128);
    str := str + MapString(strTemp, LCMAP_HALFWIDTH);
  end;
  Result := str;
end;

//SpJ^JiSpЂ炪Ȃ
function Hiragana(const Source: string) : string;
var
  i, wl : Cardinal;
  str, strTemp : String;
  WStr : WideString;
begin
  WStr := Source;
  wl := Length(WStr) div 127;
  str := '';
  for i := 1 to wl+1 do
  begin
    strTemp := '';
    strTemp := System.Copy(WStr, i + (i-1) * 127,128);
    str := str + MapString(strTemp, LCMAP_HIRAGANA);
  end;
  Result := str;
end;

//SpЂ炪ȂSpJ^Ji
function Katakana(const Source: string) : string;
var
  i, wl : Cardinal;
  str, strTemp : String;
  WStr : WideString;
begin
  WStr := Source;
  wl := Length(WStr) div 127;
  str := '';
  for i := 1 to wl+1 do
  begin
    strTemp := '';
    strTemp := System.Copy(WStr, i + (i-1) * 127,128);
    str := str + MapString(strTemp, LCMAP_KATAKANA);
  end;
  Result := str;
end;


function DirectoryExists(const Name: string): Boolean;
var
  Code: Integer;
begin
  Code := GetFileAttributes(PChar(Name));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

function ForceDirectories(Dir: string): Boolean;
begin
  Result := True;
  if Length(Dir) = 0 then
    raise Exception.Create('Cannot Create Dir');
  Dir := ExcludeTrailingBackslash(Dir);
  if (Length(Dir) < 3) or DirectoryExists(Dir)
    or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
  Result := ForceDirectories(ExtractFilePath(Dir)) and CreateDir(Dir);
end;





end.
