require File.dirname(__FILE__) + '/../test_helper'
require 'msproject_controller'

# Re-raise errors caught by the controller.
class MsprojectController; def rescue_action(e) raise e end; end

class MsprojectControllerTest < Test::Unit::TestCase
  fixtures :ms_projects

  def setup
    @controller = MsprojectController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ms_projects(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ms_projects)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ms_project)
    assert assigns(:ms_project).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ms_project)
  end

  def test_create
    num_ms_projects = MsProject.count

    post :create, :ms_project => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ms_projects + 1, MsProject.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ms_project)
    assert assigns(:ms_project).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      MsProject.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      MsProject.find(@first_id)
    }
  end
end
