require File.dirname(__FILE__) + '/../test_helper'
require 'msuser_controller'

# Re-raise errors caught by the controller.
class MsuserController; def rescue_action(e) raise e end; end

class MsuserControllerTest < Test::Unit::TestCase
  fixtures :ms_users

  def setup
    @controller = MsuserController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    @first_id = ms_users(:first).id
  end

  def test_index
    get :index
    assert_response :success
    assert_template 'list'
  end

  def test_list
    get :list

    assert_response :success
    assert_template 'list'

    assert_not_nil assigns(:ms_users)
  end

  def test_show
    get :show, :id => @first_id

    assert_response :success
    assert_template 'show'

    assert_not_nil assigns(:ms_user)
    assert assigns(:ms_user).valid?
  end

  def test_new
    get :new

    assert_response :success
    assert_template 'new'

    assert_not_nil assigns(:ms_user)
  end

  def test_create
    num_ms_users = MsUser.count

    post :create, :ms_user => {}

    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_equal num_ms_users + 1, MsUser.count
  end

  def test_edit
    get :edit, :id => @first_id

    assert_response :success
    assert_template 'edit'

    assert_not_nil assigns(:ms_user)
    assert assigns(:ms_user).valid?
  end

  def test_update
    post :update, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'show', :id => @first_id
  end

  def test_destroy
    assert_nothing_raised {
      MsUser.find(@first_id)
    }

    post :destroy, :id => @first_id
    assert_response :redirect
    assert_redirected_to :action => 'list'

    assert_raise(ActiveRecord::RecordNotFound) {
      MsUser.find(@first_id)
    }
  end
end
