#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: 
#  untar home.tgz etc.tgz opt.tgz in /initrd/cdrom/DATA in tmpfs

case "$1" in
  "start")
    mount -t tmpfs -o size={TMPFS_SIZE} none /drbl
    for i in home etc opt; do 
      tar -C /drbl -xmzf /initrd/cdrom/DATA/$i.tgz 
    done
    ## /home/$user
    for user in `ls /drbl/home`; do
      ln -sf /drbl/home/$user /home/$user
    done
    ## /etc/sudoers
    cp /drbl/etc/sudoers /etc
    ;;
  *)
    ;;
esac
