#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: download nvidia driver from nvidia web site and install it

imageroot="/var/lib/diskless/default/root"

NVIDIA_DOWNLOAD=http://download.nvidia.com/XFree86/Linux-x86/1.0-4496
NVIDIA_DRIVER=NVIDIA-Linux-x86-1.0-4496-pkg2.run
KERNEL_INCLUDE_PATH=/usr/src/kernel-headers-$(uname -r)/include

wget $NVIDIA_DOWNLOAD/$NVIDIA_DRIVER
chmod 755 $NVIDIA_DRIVER
export IGNORE_CC_MISMATCH=1; ./$NVIDIA_DRIVER -a -n --kernel-include-path=$KERNEL_INCLUDE_PATH

if [ -d $imageroot ]; then
  cp $NVIDIA_DRIVER $imageroot/root
  cat <<-EOF > $imageroot/root/nvidia-driver.sh
export IGNORE_CC_MISMATCH=1; /root/$NVIDIA_DRIVER -a -n --kernel-include-path=$KERNEL_INCLUDE_PATH
EOF
  chmod 755 $imageroot/root/nvidia-driver.sh
  chroot $imageroot /root/nvidia-driver.sh
  rm -f $imageroot/root/nvidia-driver.sh
  rm -f $imageroot/root/$NVIDIA_DRIVER
fi

rm -f $NVIDIA_DRIVER
