#!/bin/sh

tar -C / -xvzf /opt/drbl/misc/openoffice.tar.gz

# autoresponse-network.conf
cat <<-EOF > /etc/openoffice/autoresponse-network.conf
[ENVIRONMENT]
INSTALLATIONMODE=INSTALL_NETWORK
INSTALLATIONTYPE=STANDARD
DESTINATIONPATH=/opt/OpenOffice.org1.1.2
OUTERPATH=
LOGFILE=

[JAVA]
JavaSupport=none
EOF
# autoresponse-workstation.conf
cat <<-EOF > /etc/openoffice/autoresponse-workstation.conf
[ENVIRONMENT]
INSTALLATIONMODE=INSTALL_WORKSTATION
INSTALLATIONTYPE=WORKSTATION
UPDATEMODE=IF_AVAILABLE
DESTINATIONPATH=<home>/.openoffice/1.1.2
OUTERPATH=
LOGFILE=

[JAVA]
JavaSupport=none
EOF
# settings.conf
cat <<-EOF > /etc/openoffice/settings.conf
OOVERSION="OpenOffice.org 1.1.2"
OOPATH="/opt/OpenOffice.org1.1.2"
PRELINK="false"
EOF

# setup
if [ "$LC_ALL" = "zh_TW.Big5" ]; then

  wget http://openoffice.nchc.org.tw/download/1.1.2_zh-TW/OOo_1.1.2_LinuxIntel_install_zh-TW.tar.gz

  tar -C /tmp -xvzf OOo_1.1.2_LinuxIntel_install_zh-TW.tar.gz
  /tmp/OOo_1.1.2_LinuxIntel_install_zh-TW/setup -r /etc/openoffice/autoresponse-network.conf
  cp /etc/openoffice/Common.xcu /opt/OpenOffice.org1.1.2/share/registry/data/org/openoffice/Office/

  rm -rf /tmp/OOo_1.1.2_LinuxIntel_install_zh-TW
  rm -f OOo_1.1.2_LinuxIntel_install_zh-TW.tar.gz

else

  wget http://openoffice.nchc.org.tw/download/mirror/stable/1.1.2/OOo_1.1.2_LinuxIntel_install.tar.gz

  tar -C /tmp -xvzf OOo_1.1.2_LinuxIntel_install.tar.gz
  /tmp/OOo_1.1.2_LinuxIntel_install/setup -r /etc/openoffice/autoresponse-network.conf

  rm -rf /tmp/OOo_1.1.2_LinuxIntel_install
  rm -f OOo_1.1.2_LinuxIntel_install.tar.gz

fi
