#!/bin/sh

user_home_default() {

  rsync -a /etc/skel/ /home/$1
  ln -fs .drbl/.kde-mac /home/$1/.kde

}

password_len_default="8"
set_password() {
  username=$1
  password_opt=$2

  case "$password_opt" in
    [0-9]|"") 
      if [ -z "$password_opt" ]; then password_opt="$password_len_default"; fi
      password=$(useradd/rand.pl $password_opt)
      ;;
    *)
      password=$password_opt
      ;;
  esac
  useradd/autopasswd "$username" "$password"
  echo "The password of $username is \"$password\"" >> useradd.gen
}

create_range_user() {
  prefix=$1
  start=$2
  end=$3
  password_opt=$4
  groupname=$5

  if [ "$groupname" != "" ]; then
    if [ "$(grep "^$groupname:" /etc/group)" = "" ]; then groupadd $groupname; fi
  fi

  nnum=`echo -n "$end" | wc -c`
  i=$start
  while [ $i -le $end ] ; do
    label="$i"
    # Blake, 2004/01/28
    n=`echo -n "$label" | wc -c`
    while [ $n -lt $nnum ]; do
      label="0$label"
      n=`echo -n "$label" | wc -c`
    done
    #if [ $i -lt 10 ] ; then 
    #  label="00$i"
    #elif [ $i -lt 100 ] ; then
    #  label="0$i"
    #fi

    #passwd=`crypt_pwd $label`
    #echo "useradd -p $passwd student$label"
    if [ "$groupname" != "" ]; then
      useradd -G $groupname "$prefix$label"
    else
      useradd "$prefix$label"
    fi
#    # 2003/08/15 add 4th argument for numpwd
#    if [ "$numpwd" != "" ]; then
#      randpwd=$(useradd/rand.pl $numpwd)
#      useradd/autopasswd "$prefix$label" "$randpwd"
#      echo -e "$prefix$label\t$randpwd" >> useradd.gen
#    else
#      useradd/autopasswd "$prefix$label" "$prefix$label"
#    fi
    # Blake, 2004/02/04
    set_password $prefix$label $password_opt

    mkdir /home/$prefix$label
    user_home_default $prefix$label
    chown -R $prefix$label.users /home/$prefix$label
    useradd/autosshkeygen $prefix$label > /etc/null
    mv /home/$prefix$label/.ssh/id_rsa.pub /home/$prefix$label/.ssh/authorized_keys
    chown -R $prefix$label.users /home/$prefix$label

    i=`expr $i + 1`
  done
}

## single
if [ "$1" = "--single" -o "$1" = "-s" ]; then
    username="$2"
    if [ "$3" != "" ]; then
      if [ "$(grep "^$3:" /etc/group)" = "" ]; then groupadd $3; fi
      useradd -G $3 $username
    else 
      useradd $username
    fi
    # 2003/08/15 --single will ask user to input passwd for the user..
	#useradd/autopasswd $username $username
    passwd $username
	mkdir /home/$username
    user_home_default $username
	chown -R $username.users /home/$username
    useradd/autosshkeygen $username
    mv /home/$username/.ssh/id_rsa.pub /home/$username/.ssh/authorized_keys
	chown -R $username.users /home/$username
    exit

## file
elif [ "$1" = "--file" -o "$1" = "-f" ]; then

  filename=$2
  #password_opt=$3
  rm -f useradd.gen
  touch useradd.gen

  if [ ! -f $filename ]; then exit; fi
  while read line; do
    if [ "$line" = "" ]; then continue; fi
    if [ "$(echo $line | grep -e "^#")" != "" ]; then continue; fi
    echo $line | \
    while read prefix start end password_opt group; do
      create_range_user $prefix $start $end $password_opt $group
    done
  done < $filename 

## list
elif [ "$1" = "--list" -o "$1" = "-l" ]; then

  filename=$2
  rm -f useradd.gen
  touch useradd.gen

  if [ ! -f $filename ]; then exit; fi
  while read line; do
    if [ "$line" = "" ]; then continue; fi
    if [ "$(echo $line | grep -e "^#")" != "" ]; then continue; fi
    echo $line | \
    while read username password_opt groupname; do

      if [ "$groupname" != "" ]; then 
        if [ "$(grep -e "^$groupname:" /etc/group)" = "" ]; then groupadd $groupname; fi
        useradd -G $groupname $username
      else
        useradd $username
      fi
      set_password $username $password_opt
      mkdir /home/$username
      user_home_default $username
      chown -R $username.users /home/$username
      useradd/autosshkeygen $username
      mv /home/$username/.ssh/id_rsa.pub /home/$username/.ssh/authorized_keys
      chown -R $username.users /home/$username
    done
  done < $filename 

## range
else

  prefix=$1
  start=$2
  end=$3
  password_opt=$4
  groupname=$5
  # Blake, 2004/02/04
  #if [ "$numpwd" != "" ]; then
  rm -f useradd.gen
  touch useradd.gen
  #fi
  #echo "[$prefix][$start][$end][$password_opt][$groupname]"
  create_range_user $prefix $start $end $password_opt $groupname
fi
